/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Talent;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogTalentData;
import doggytalents.common.util.DogUtil;
import doggytalents.forge_imitate.network.ForgeNetworkHandler;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2359;
import net.minecraft.class_2540;

public class DogTalentPacket
extends DogPacket<DogTalentData> {
    @Override
    public void encode(DogTalentData data, class_2540 buf) {
        super.encode(data, buf);
        buf.method_42065((class_2359)DoggyTalentsAPI.TALENTS.get(), (Object)data.talent);
    }

    @Override
    public DogTalentData decode(class_2540 buf) {
        int entityId = buf.readInt();
        Talent talent = (Talent)buf.method_42064((class_2359)DoggyTalentsAPI.TALENTS.get());
        return new DogTalentData(entityId, talent);
    }

    @Override
    public void handleDog(Dog dogIn, DogTalentData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
        if (!dogIn.canInteract((class_1309)ctx.get().getSender())) {
            return;
        }
        if (!DogUtil.playerCanTrainTalent((class_1657)ctx.get().getSender(), data.talent)) {
            return;
        }
        if (!data.talent.isDogEligible(dogIn)) {
            return;
        }
        int level = dogIn.getDogLevel(data.talent);
        if (level < data.talent.getMaxLevel() && dogIn.canSpendPoints(data.talent.getLevelCost(level + 1))) {
            dogIn.setTalentLevel(data.talent, level + 1);
        }
    }
}

