/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogEatingParticleData;
import doggytalents.common.network.packet.data.DogShakingData;
import doggytalents.common.network.packet.data.ParticleData;
import doggytalents.forge_imitate.network.ForgeNetworkHandler;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class ParticlePackets {

    public static class DogShakingPacket
    implements IPacket<DogShakingData> {
        @Override
        public void encode(DogShakingData data, class_2540 buf) {
            buf.writeInt(data.dogId);
            buf.writeByte((int)((byte)data.state.getId()));
        }

        @Override
        public DogShakingData decode(class_2540 buf) {
            int dogId = buf.readInt();
            DogShakingData.State state = DogShakingData.State.fromId(buf.readByte());
            return new DogShakingData(dogId, state);
        }

        @Override
        public void handle(DogShakingData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    class_310 mc = class_310.method_1551();
                    class_1297 e = mc.field_1687.method_8469(data.dogId);
                    if (e instanceof Dog) {
                        Dog d = (Dog)e;
                        d.handleDogShakingUpdate(data.state);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendDogShakingPacket(AbstractDog dog, DogShakingData.State state) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> dog), new DogShakingData(dog.method_5628(), state));
        }
    }

    public static class DogEatingParticlePacket
    implements IPacket<DogEatingParticleData> {
        @Override
        public void encode(DogEatingParticleData data, class_2540 buf) {
            buf.writeInt(data.dogId);
            buf.method_10793(data.food);
        }

        @Override
        public DogEatingParticleData decode(class_2540 buf) {
            int dogId = buf.readInt();
            class_1799 food = buf.method_10819();
            return new DogEatingParticleData(dogId, food);
        }

        @Override
        public void handle(DogEatingParticleData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    class_310 mc = class_310.method_1551();
                    class_1297 e = mc.field_1687.method_8469(data.dogId);
                    if (e instanceof Dog) {
                        Dog dog = (Dog)e;
                        if (data.food != null) {
                            float a1 = dog.getClientAnimatedYBodyRotInRadians();
                            double dx1 = (double)(-class_3532.method_15374((float)a1)) * ((double)dog.getDogVisualBbWidth() * 1.5);
                            double dz1 = (double)class_3532.method_15362((float)a1) * ((double)dog.getDogVisualBbWidth() * 1.5);
                            for (int i = 0; i < 15; ++i) {
                                double d1 = mc.field_1687.method_8409().method_43059() * 0.5;
                                double d3 = mc.field_1687.method_8409().method_43059() * 0.8;
                                double d5 = mc.field_1687.method_8409().method_43059() * 0.5;
                                double d6 = mc.field_1687.method_8409().method_43059() * 0.1;
                                double d7 = mc.field_1687.method_8409().method_43059() * 0.1;
                                double d8 = mc.field_1687.method_8409().method_43059() * 0.1;
                                mc.field_1687.method_8406((class_2394)new class_2392(class_2398.field_11218, data.food), dog.method_23317() + dx1 + d1, dog.method_23318() + (double)dog.method_5751() + d3, dog.method_23321() + dz1 + d5, d6, d7, d8);
                            }
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendDogEatingParticlePacketToNearby(AbstractDog dog, class_1799 food) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> dog), new DogEatingParticleData(dog.method_5628(), food));
        }
    }

    public static class CritEmitterPacket
    implements IPacket<ParticleData.CritEmitterData> {
        @Override
        public void encode(ParticleData.CritEmitterData data, class_2540 buf) {
            buf.writeInt(data.targetId);
        }

        @Override
        public ParticleData.CritEmitterData decode(class_2540 buf) {
            return new ParticleData.CritEmitterData(buf.readInt());
        }

        @Override
        public void handle(ParticleData.CritEmitterData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    class_310 mc = class_310.method_1551();
                    class_1297 e = mc.field_1687.method_8469(data.targetId);
                    if (e != null) {
                        class_310.method_1551().field_1713.method_3061(e, (class_2394)class_2398.field_11205);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }

        public static void sendCritEmitterPacketToNearClients(class_1297 e) {
            PacketHandler.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> e), new ParticleData.CritEmitterData(e.method_5628()));
        }
    }
}

