/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyAttributes;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import java.util.UUID;
import net.minecraft.class_1322;
import net.minecraft.class_5134;

public class BlackPeltTalent
extends TalentInstance {
    private static final UUID BLACK_PELT_DAMAGE_ID = UUID.fromString("9abeafa9-3913-4b4c-b46e-0f1548fb19b3");
    private static final UUID BLACK_PELT_CRIT_CHANCE_ID = UUID.fromString("f07b5d39-a8cc-4d32-b458-6efdf1dc6836");
    private static final UUID BLACK_PELT_CRIT_BONUS_ID = UUID.fromString("e19e0d42-6ee3-4ee1-af1c-7519af4354cd");

    public BlackPeltTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        dogIn.setAttributeModifier(class_5134.field_23721, BLACK_PELT_DAMAGE_ID, this::createPeltModifier);
        dogIn.setAttributeModifier(DoggyAttributes.CRIT_CHANCE.get(), BLACK_PELT_CRIT_CHANCE_ID, this::createPeltCritChance);
        dogIn.setAttributeModifier(DoggyAttributes.CRIT_BONUS.get(), BLACK_PELT_CRIT_BONUS_ID, this::createPeltCritBonus);
    }

    @Override
    public void set(AbstractDog dogIn, int levelBefore) {
        dogIn.setAttributeModifier(class_5134.field_23721, BLACK_PELT_DAMAGE_ID, this::createPeltModifier);
        dogIn.setAttributeModifier(DoggyAttributes.CRIT_CHANCE.get(), BLACK_PELT_CRIT_CHANCE_ID, this::createPeltCritChance);
        dogIn.setAttributeModifier(DoggyAttributes.CRIT_BONUS.get(), BLACK_PELT_CRIT_BONUS_ID, this::createPeltCritBonus);
    }

    @Override
    public void remove(AbstractDog dogIn) {
        dogIn.removeAttributeModifier(class_5134.field_23721, BLACK_PELT_DAMAGE_ID);
        dogIn.removeAttributeModifier(DoggyAttributes.CRIT_CHANCE.get(), BLACK_PELT_CRIT_CHANCE_ID);
        dogIn.removeAttributeModifier(DoggyAttributes.CRIT_BONUS.get(), BLACK_PELT_CRIT_BONUS_ID);
    }

    public class_1322 createPeltModifier(AbstractDog dogIn, UUID uuidIn) {
        if (this.level() > 0) {
            double damageBonus = this.level();
            if (this.level() >= 5) {
                damageBonus += 2.0;
            }
            return new class_1322(uuidIn, "Black Pelt", damageBonus, class_1322.class_1323.field_6328);
        }
        return null;
    }

    public class_1322 createPeltCritChance(AbstractDog dogIn, UUID uuidIn) {
        if (this.level() <= 0) {
            return null;
        }
        double damageBonus = 0.15 * (double)this.level();
        if (this.level() >= 5) {
            damageBonus = 1.0;
        }
        return new class_1322(uuidIn, "Black Pelt Crit Chance", damageBonus, class_1322.class_1323.field_6328);
    }

    public class_1322 createPeltCritBonus(AbstractDog dogIn, UUID uuidIn) {
        if (this.level() <= 0) {
            return null;
        }
        return new class_1322(uuidIn, "Black Pelt Crit Bonus", 1.0, class_1322.class_1323.field_6331);
    }
}

