/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.apache.commons.lang3.ObjectUtils;

public class MobRetrieverTalent
extends TalentInstance {
    private class_1309 targetEntity;

    public MobRetrieverTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.method_37908().field_9236) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        this.updateRidingPassanger(dog);
        this.updateAndSetRetrieveTarget(dog);
    }

    private void updateRidingPassanger(Dog dog) {
        class_1297 riding = dog.method_31483();
        if (riding == null) {
            return;
        }
        if (riding instanceof class_1657) {
            return;
        }
        if (!this.canStillRideTarget(dog, riding)) {
            dog.method_18375();
        }
    }

    private void updateAndSetRetrieveTarget(Dog dog) {
        if (this.targetEntity == null) {
            return;
        }
        class_1309 target = this.targetEntity;
        this.targetEntity = null;
        if (!this.isValidTarget(dog, target)) {
            return;
        }
        if (dog.isBusy() || !this.readyForNewRider(dog)) {
            return;
        }
        if (dog.method_24345()) {
            return;
        }
        dog.triggerAction(new DogRetrieveMobAction(dog, target, this));
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (dog.method_37908().field_9236) {
            return;
        }
        if (levelBefore > 0 && this.level() <= 0) {
            dog.method_18375();
        }
    }

    public boolean isValidTarget(Dog dog, class_1309 target) {
        if (target == dog) {
            return false;
        }
        if (target.method_5858((class_1297)dog) >= (double)(MobRetrieverTalent.getSelectTargetRange() * MobRetrieverTalent.getSelectTargetRange())) {
            return false;
        }
        if (!target.method_5805()) {
            return false;
        }
        if (target.method_7325()) {
            return false;
        }
        if (target.method_5782()) {
            return false;
        }
        boolean onlyDog = (Boolean)ConfigHandler.SERVER.MOB_RETRIEVER_ONLY_CARRY_DOG.get();
        if (onlyDog && !(target instanceof Dog)) {
            return false;
        }
        if (!(target instanceof class_1309)) {
            return false;
        }
        if (target instanceof class_1657) {
            return false;
        }
        if (target instanceof class_1569) {
            return false;
        }
        if (target.method_5864().method_20210(DoggyTags.MOB_RETRIEVER_MUST_IGNORE)) {
            return false;
        }
        if (target instanceof class_1321) {
            class_1321 otherDog = (class_1321)target;
            if (dog.method_6139() != null && ObjectUtils.notEqual((Object)otherDog.method_6139(), (Object)dog.method_6139())) {
                return false;
            }
        }
        return this.canLevelRideTarget(dog, (class_1297)target);
    }

    private boolean canStillRideTarget(Dog dog, class_1297 target) {
        if (!target.method_5805()) {
            return false;
        }
        if (target.method_7325()) {
            return false;
        }
        if (target.method_5782()) {
            return false;
        }
        boolean onlyDog = (Boolean)ConfigHandler.SERVER.MOB_RETRIEVER_ONLY_CARRY_DOG.get();
        if (onlyDog && !(target instanceof Dog)) {
            return false;
        }
        if (dog.method_6172()) {
            return false;
        }
        if (!dog.isDoingFine()) {
            return false;
        }
        if (!(target instanceof class_1309)) {
            return false;
        }
        if (target instanceof class_1569) {
            return false;
        }
        if (target.method_5864().method_20210(DoggyTags.MOB_RETRIEVER_MUST_IGNORE)) {
            return false;
        }
        if (target instanceof class_1321) {
            class_1321 otherDog = (class_1321)target;
            if (dog.method_6139() != null && ObjectUtils.notEqual((Object)otherDog.method_6139(), (Object)dog.method_6139())) {
                return false;
            }
        }
        return this.canLevelRideTarget(dog, target);
    }

    @Override
    public class_1271<Float> gettingAttackedFrom(AbstractDog dog, class_1282 source, float damage) {
        if (!dog.method_37908().field_9236) {
            this.maybeDropRiding(dog);
        }
        return super.gettingAttackedFrom(dog, source, damage);
    }

    private void maybeDropRiding(AbstractDog dog) {
        class_1321 otherDog;
        if (!dog.method_5782()) {
            return;
        }
        class_1297 passenger = dog.method_31483();
        if (passenger == null) {
            return;
        }
        if (passenger instanceof class_1657) {
            return;
        }
        if (passenger instanceof class_1321 && (otherDog = (class_1321)passenger).method_35057() == dog.method_35057()) {
            return;
        }
        dog.method_18375();
    }

    private boolean canLevelRideTarget(Dog dog, class_1297 target) {
        int lvl = this.level();
        float target_bbW = target.method_17681();
        float target_bbH = target.method_17682();
        float w_ratio = target_bbW / dog.getDogVisualBbWidth();
        float h_ratio = target_bbH / dog.getDogVisualBbHeight();
        if (target_bbW >= 1.0f) {
            return false;
        }
        if ((double)w_ratio > 1.2) {
            return false;
        }
        if (lvl >= 5) {
            return h_ratio <= 2.0f;
        }
        if (lvl >= 3) {
            return (double)h_ratio <= 1.5;
        }
        return h_ratio <= 1.0f;
    }

    private boolean readyForNewRider(Dog dog) {
        return dog.isDoingFine() && !dog.method_6172() && !dog.method_5782();
    }

    public void setTarget(Dog dog, class_1309 target) {
        if (!this.isValidTarget(dog, target)) {
            return;
        }
        this.targetEntity = target;
    }

    public static Optional<Dog> chooseNearestDog(class_1657 player, class_1937 level) {
        List valid_dogs = level.method_8390(Dog.class, player.method_5829().method_1009(4.0, 2.0, 4.0), d -> {
            if (!d.isDoingFine()) {
                return false;
            }
            if (d.getDogLevel(DoggyTalents.MOB_RETRIEVER) <= 0) {
                return false;
            }
            return !d.isBusy();
        });
        if (valid_dogs.isEmpty()) {
            return Optional.empty();
        }
        double min_dist = ((Dog)valid_dogs.get(0)).method_5858((class_1297)player);
        Dog choosen_dog = (Dog)valid_dogs.get(0);
        for (Dog dog : valid_dogs) {
            double dist = dog.method_5858((class_1297)player);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            choosen_dog = dog;
        }
        return Optional.of(choosen_dog);
    }

    @Override
    public class_1269 blockIdleAnim(AbstractDog dogIn) {
        if (dogIn.method_5782()) {
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static int getSelectTargetRange() {
        return 20;
    }

    public static class DogRetrieveMobAction
    extends TriggerableAction {
        private MobRetrieverTalent inst;
        private class_1309 target;
        private int tickTillPathRecalc;
        private int stopDist = 3;
        private boolean isBringingBack = false;
        private class_1309 owner = null;

        public DogRetrieveMobAction(Dog dog, class_1309 target, MobRetrieverTalent inst) {
            super(dog, false, false);
            this.target = target;
            this.inst = inst;
        }

        @Override
        public void onStart() {
        }

        @Override
        public void tick() {
            if (!this.inst.isValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.isBringingBack && !this.dog.method_5685().isEmpty()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack && this.dog.method_5685().isEmpty()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack && this.owner == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack && (!this.ownerIsStillThere() || this.returnedToOwner())) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isBringingBack) {
                this.returnToOwner();
            } else {
                this.goGetMob();
            }
        }

        private void goGetMob() {
            if (this.dog.method_5858((class_1297)this.target) > (double)(this.stopDist * this.stopDist)) {
                this.dog.method_5988().method_6226((class_1297)this.target, 10.0f, (float)this.dog.method_5978());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.method_5934() && !this.dog.method_5765()) {
                        this.dog.method_5942().method_6335((class_1297)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.method_5942().method_6340();
                this.target.method_5804((class_1297)this.dog);
                this.owner = this.dog.method_35057();
                this.isBringingBack = true;
            }
        }

        private void returnToOwner() {
            if (this.dog.method_5858((class_1297)this.owner) > (double)(this.stopDist * this.stopDist)) {
                this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.method_5934() && !this.dog.method_5765()) {
                        this.dog.method_5942().method_6335((class_1297)this.owner, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            }
        }

        @Override
        public void onStop() {
        }

        private boolean ownerIsStillThere() {
            if (!this.owner.method_5805()) {
                return false;
            }
            if (this.owner.method_7325()) {
                return false;
            }
            return !(this.owner.method_5858((class_1297)this.dog) > 256.0);
        }

        private boolean returnedToOwner() {
            return this.dog.method_5858((class_1297)this.owner) <= (double)(this.stopDist * this.stopDist);
        }
    }
}

