/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1429;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;

public class ShepherdDogTalent
extends TalentInstance {
    private List<class_1429> targets = List.of();
    private static final int SEARCH_RANGE = 12;
    private static final int SEARCH_RANGE_EXT = 16;
    private static final int VALID_FOLLOWING_DISTANCE = 400;
    private int tickTillSearch;

    public ShepherdDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.method_37908().field_9236) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        class_1309 owner = dog.method_35057();
        if (owner == null) {
            return;
        }
        if (dog.readyForNonTrivialAction() && dog.getMode() == DogMode.DOCILE && !dog.method_24345() && --this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            this.refreshShepherdTargets(dog, 12);
            if (!this.targets.isEmpty() && EntityUtil.isHolding((class_1297)owner, DoggyItems.WHISTLE.get(), nbt -> nbt.method_10545("mode") && nbt.method_10550("mode") == 4)) {
                if (!this.triggerShepherdAction(dog, owner)) {
                    this.targets = List.of();
                }
            } else {
                this.targets = List.of();
            }
        }
    }

    private boolean triggerShepherdAction(Dog dog, class_1309 owner) {
        if (owner instanceof class_3222) {
            class_3222 sP = (class_3222)owner;
            return dog.triggerAction(new ShepherdAction(dog, sP, this));
        }
        return false;
    }

    public static int getMaxFollowers(int level) {
        switch (level) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
        }
        return 0;
    }

    public boolean isValidAnimal(Dog dog, class_1429 animal) {
        if (!animal.method_5805()) {
            return false;
        }
        if (animal.method_5767()) {
            return false;
        }
        if (animal instanceof class_1321) {
            return false;
        }
        if (animal.method_5858((class_1297)dog) > 400.0) {
            return false;
        }
        return animal.method_5985().method_6369((class_1297)dog);
    }

    public void refreshShepherdTargets(Dog dog, int searchRange) {
        this.targets = dog.method_37908().method_8390(class_1429.class, dog.method_5829().method_1009((double)searchRange, 4.0, (double)searchRange), e -> this.isValidAnimal(dog, (class_1429)e));
        if (this.targets.isEmpty()) {
            return;
        }
        Collections.sort(this.targets, new EntityUtil.Sorter((class_1297)dog));
        int followCap = ShepherdDogTalent.getMaxFollowers(this.level());
        if (followCap < this.targets.size()) {
            this.targets = this.targets.subList(0, Math.min(followCap, this.targets.size()));
        }
    }

    private static class ShepherdAction
    extends TriggerableAction {
        private static final int LOOK_OWNER_INTERVAL = 20;
        private final ShepherdDogTalent talentInst;
        @Nonnull
        private class_3222 owner;
        private int tickTillPathRecalc;
        private int tickTillLook;

        public ShepherdAction(Dog dog, @Nonnull class_3222 owner, ShepherdDogTalent talentInst) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.owner = owner;
        }

        @Override
        public void onStart() {
            this.tickTillPathRecalc = 0;
            this.tickTillLook = 0;
        }

        @Override
        public void tick() {
            boolean update;
            if (this.dog.getMode() != DogMode.DOCILE) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!EntityUtil.isHolding((class_1297)this.owner, DoggyItems.WHISTLE.get(), nbt -> nbt.method_10545("mode") && nbt.method_10550("mode") == 4)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            boolean bl = update = --this.tickTillPathRecalc <= 0;
            if (update) {
                this.tickTillPathRecalc = 20;
            }
            if (update) {
                this.talentInst.refreshShepherdTargets(this.dog, 16);
            }
            if (this.talentInst.targets.isEmpty()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (--this.tickTillLook <= 0) {
                this.tickTillLook = 20;
                this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
            }
            if (update) {
                this.herdTargets();
            }
        }

        private void herdTargets() {
            boolean teleport = this.owner.method_5858((class_1297)this.talentInst.targets.get(0)) > 256.0;
            for (class_1429 target : this.talentInst.targets) {
                double distanceAway = target.method_5858((class_1297)this.owner);
                target.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)target.method_5978());
                if (teleport) {
                    if (target.method_5934() || target.method_5765()) continue;
                    EntityUtil.tryToTeleportNearEntity((class_1309)target, target.method_5942(), (class_1309)this.owner, 4);
                    continue;
                }
                if (distanceAway >= 25.0) {
                    if (target.method_5942().method_6335((class_1297)this.owner, 1.2) || target.method_5934() || target.method_5765() || !(distanceAway >= 400.0)) continue;
                    EntityUtil.tryToTeleportNearEntity((class_1309)target, target.method_5942(), (class_1309)this.owner, 4);
                    continue;
                }
                target.method_5942().method_6340();
            }
            this.moveInTheMiddleOfHerdingGroup(teleport);
            if (this.dog.method_5858((class_1297)this.owner) > 1600.0) {
                DogUtil.guessAndTryToTeleportToOwner(this.dog, (class_1309)this.owner, 2);
            }
            if (this.dog.method_6051().method_43057() < 0.15f) {
                this.dog.method_5783(class_3417.field_14724, this.dog.method_6107() + 1.0f, (this.dog.method_6051().method_43057() - this.dog.method_6051().method_43057()) * 0.1f + 0.9f);
            }
        }

        private void moveInTheMiddleOfHerdingGroup(boolean teleport) {
            class_243 avgPosVec = class_243.field_1353;
            for (class_1429 target : this.talentInst.targets) {
                avgPosVec = avgPosVec.method_1019(target.method_19538());
            }
            avgPosVec = avgPosVec.method_1021(1.0 / (double)this.talentInst.targets.size());
            double d_avgPosX_ownerX = avgPosVec.field_1352 - this.owner.method_23317();
            double d_avgPosZ_ownerZ = avgPosVec.field_1350 - this.owner.method_23321();
            double size = Math.sqrt(d_avgPosX_ownerX * d_avgPosX_ownerX + d_avgPosZ_ownerZ * d_avgPosZ_ownerZ);
            double tpPosX = avgPosVec.field_1352 + d_avgPosX_ownerX / size * (double)(2 + this.talentInst.targets.size() / 16);
            double tpPosZ = avgPosVec.field_1350 + d_avgPosZ_ownerZ / size * (double)(2 + this.talentInst.targets.size() / 16);
            if (teleport) {
                EntityUtil.tryToTeleportNearEntity((class_1309)this.dog, this.dog.method_5942(), new class_2338(class_3532.method_15357((double)tpPosX), class_3532.method_15357((double)this.dog.method_23318()), class_3532.method_15357((double)tpPosZ)), 1);
            }
            this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
            if (!this.dog.method_5942().method_6337(tpPosX, this.owner.method_5829().field_1322, tpPosZ, 1.0) && this.dog.method_5649(tpPosX, this.owner.method_5829().field_1322, tpPosZ) > 144.0 && !this.dog.method_5934() && !this.dog.method_5765()) {
                EntityUtil.tryToTeleportNearEntity((class_1309)this.dog, this.dog.method_5942(), new class_2338(class_3532.method_15357((double)tpPosX), class_3532.method_15357((double)this.dog.method_23318()), class_3532.method_15357((double)tpPosZ)), 4);
            }
        }

        @Override
        public void onStop() {
            this.talentInst.targets = List.of();
        }

        @Override
        public boolean canOverrideSit() {
            return false;
        }
    }
}

