/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class WaterHolderTalent
extends TalentInstance {
    private static int EFFECT_RANGE = 5;
    private static int SEARCH_RADIUS = 12;
    private int waterUnitLeft;
    private int ticktillSearch;
    private int tickTillRegenWater;
    private int tickScheduledForExtinguish = 0;
    private boolean scheduledExtinguish = false;

    public WaterHolderTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
    }

    private int getMaxWaterHold() {
        return 5 + this.level() * 3;
    }

    private float getOnFireTickFactor() {
        return 0.2f * (float)this.level();
    }

    private int decreaseTickOnFire(int tickOnFire) {
        if (tickOnFire <= 2) {
            return 0;
        }
        return class_3532.method_15375((float)((float)tickOnFire - this.getOnFireTickFactor() * (float)tickOnFire));
    }

    private int getWaterUnitleft() {
        return this.waterUnitLeft;
    }

    private void setWaterUnitLeft(int unit) {
        this.waterUnitLeft = class_3532.method_15340((int)unit, (int)0, (int)this.getMaxWaterHold());
    }

    private void incWaterUnitLeft() {
        this.setWaterUnitLeft(this.getWaterUnitleft() + 1);
    }

    private void decWaterUnitLeft() {
        this.setWaterUnitLeft(this.getWaterUnitleft() - 1);
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.method_37908().field_9236) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        if (dog.readyForNonTrivialAction() && !dog.getMode().shouldAttack() && dog.method_24828() && --this.ticktillSearch <= 0) {
            this.ticktillSearch = 10;
            class_1309 target = this.findOnFireTarget(abstractDog);
            if (target != null && this.stillValidTarget(dog, target)) {
                this.triggerExtinguishAction(dog, target);
            }
        }
        if (this.scheduledExtinguish && abstractDog.field_6012 >= this.tickScheduledForExtinguish) {
            this.extinguishNearby(abstractDog);
            this.scheduledExtinguish = false;
        }
        if (abstractDog.method_5721() && --this.tickTillRegenWater <= 0) {
            this.tickTillRegenWater = 10;
            this.incWaterUnitLeft();
        }
    }

    public void triggerExtinguishAction(Dog dog, class_1309 target) {
        dog.triggerAction(new ExtinguishAction(dog, this, target));
    }

    @Override
    public class_1269 processInteract(AbstractDog dog, class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_6047();
        if (stack.method_7909() instanceof class_1755 && !dog.method_37908().field_9236 && player.method_5715()) {
            class_5250 c1 = class_2561.method_43469((String)"talent.doggytalents.water_holder.amount", (Object[])new Object[]{dog.method_5477().getString()});
            c1.method_10852((class_2561)class_2561.method_43470((String)": "));
            if (this.level < this.talent.getMaxLevel()) {
                c1.method_10852((class_2561)class_2561.method_43470((String)("" + this.getWaterUnitleft())).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(239100)));
                c1.method_10852((class_2561)class_2561.method_43470((String)("/" + this.getMaxWaterHold())));
            } else {
                c1.method_10852((class_2561)class_2561.method_43471((String)"talent.doggytalents.water_holder.amount.unlim").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(239100)));
            }
            player.method_43496((class_2561)c1);
            return class_1269.field_5812;
        }
        if (stack.method_7909() == class_1802.field_8705) {
            if (!dog.method_37908().field_9236) {
                if (this.getWaterUnitleft() >= this.getMaxWaterHold()) {
                    return class_1269.field_5811;
                }
                this.setWaterUnitLeft(this.getMaxWaterHold());
                if (!player.method_31549().field_7477) {
                    player.method_6122(hand, new class_1799((class_1935)class_1802.field_8550));
                }
                dog.method_5783(class_3417.field_15126, dog.method_6107(), 1.0f);
                class_1937 class_19372 = dog.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    serverLevel.method_14199((class_2394)class_2398.field_11202, dog.method_23317(), dog.method_23318(), dog.method_23321(), this.level * 8, (double)dog.method_17681(), (double)0.8f, (double)dog.method_17681(), 0.5);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    @Override
    public void writeToNBT(AbstractDog dog, class_2487 compound) {
        super.writeToNBT(dog, compound);
        compound.method_10569("DTwaterUnitLeft", this.getWaterUnitleft());
    }

    @Override
    public void readFromNBT(AbstractDog dog, class_2487 compound) {
        super.readFromNBT(dog, compound);
        this.setWaterUnitLeft(compound.method_10550("DTwaterUnitLeft"));
    }

    private void extinguishNearby(AbstractDog dog) {
        List<class_1309> targets = this.getNearbyOnFire(dog);
        if (targets.isEmpty()) {
            return;
        }
        this.decWaterUnitLeft();
        for (class_1309 e : targets) {
            this.extinguishEntity(dog, e);
        }
    }

    private void extinguishEntity(AbstractDog dog, class_1309 e) {
        int a0 = e.method_20802();
        e.method_20803(this.decreaseTickOnFire(a0));
        e.method_5783(class_3417.field_15102, 0.5f, 2.6f + e.method_6051().method_43057() - e.method_6051().method_43057() * 0.8f);
        class_1937 class_19372 = dog.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11251, e.method_23317(), e.method_23318(), e.method_23321(), 15, (double)e.method_17681(), (double)0.8f, (double)e.method_17681(), 0.1);
        }
        class_2338 e_b0 = e.method_24515();
        class_2338.class_2339 e_b0m = e_b0.method_25503();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                e_b0m.method_33097(e_b0.method_10263() + i);
                e_b0m.method_33099(e_b0.method_10260() + j);
                if (e.method_37908().method_8320((class_2338)e_b0m).method_26204() != class_2246.field_10036) continue;
                e.method_37908().method_8501((class_2338)e_b0m, class_2246.field_10124.method_9564());
            }
        }
    }

    public void scheduleDelayedExtinguish(AbstractDog dog) {
        if (this.scheduledExtinguish) {
            return;
        }
        this.scheduledExtinguish = true;
        this.tickScheduledForExtinguish = dog.field_6012 + this.getDelay();
    }

    private List<class_1309> getNearbyOnFire(AbstractDog dog) {
        class_1309 owner = dog.method_35057();
        if (owner == null) {
            return List.of();
        }
        return dog.method_37908().method_8390(class_1309.class, dog.method_5829().method_1009((double)EFFECT_RANGE, 4.0, (double)EFFECT_RANGE), e -> {
            if (!e.method_5809()) return false;
            if (!(owner == e || e instanceof AbstractDog && ((AbstractDog)e).method_35057() == owner || e instanceof class_1493 && ((class_1493)e).method_35057() == owner)) {
                if (!(e instanceof class_1657)) return false;
                class_1657 p = (class_1657)e;
                if (!(dog instanceof Dog)) return false;
                Dog d = (Dog)dog;
                if (!d.regardTeamPlayers()) return false;
                if (!p.method_5722((class_1297)owner)) return false;
            }
            if (!dog.method_5985().method_6369((class_1297)e)) return false;
            return true;
        });
    }

    private class_1309 findOnFireTarget(AbstractDog dog) {
        List teamPlayers;
        Dog ddog;
        List wolves;
        List dogs;
        ArrayList<class_1309> targets = new ArrayList<class_1309>();
        Predicate<class_1309> onFireAndWitness = e -> e.method_5809() && e.method_24828() && dog.method_5985().method_6369((class_1297)e);
        class_1309 owner = dog.method_35057();
        if (owner == null) {
            return null;
        }
        if (onFireAndWitness.test(owner)) {
            targets.add(owner);
        }
        if (!(dogs = dog.method_37908().method_8390(AbstractDog.class, dog.method_5829().method_1009((double)SEARCH_RADIUS, 4.0, (double)SEARCH_RADIUS), d -> d.method_35057() == owner && onFireAndWitness.test((class_1309)d))).isEmpty()) {
            targets.addAll(dogs);
        }
        if (!(wolves = dog.method_37908().method_8390(class_1493.class, dog.method_5829().method_1009((double)SEARCH_RADIUS, 4.0, (double)SEARCH_RADIUS), w -> w.method_35057() == owner && onFireAndWitness.test((class_1309)w))).isEmpty()) {
            targets.addAll(wolves);
        }
        if (dog instanceof Dog && (ddog = (Dog)dog).regardTeamPlayers() && !(teamPlayers = dog.method_37908().method_8390(class_1657.class, dog.method_5829().method_1009((double)SEARCH_RADIUS, 4.0, (double)SEARCH_RADIUS), p -> p.method_5722((class_1297)owner) && onFireAndWitness.test((class_1309)p))).isEmpty()) {
            targets.addAll(teamPlayers);
        }
        return this.selectOnFireTarget(dog, targets);
    }

    private class_1309 selectOnFireTarget(AbstractDog dog, List<class_1309> targets) {
        if (targets.isEmpty()) {
            return null;
        }
        class_1309 target = targets.get(0);
        double mindistanceSqr = target.method_5858((class_1297)dog);
        class_1309 owner = dog.method_35057();
        for (class_1309 i : targets) {
            if (owner == i) {
                return i;
            }
            double d = i.method_5858((class_1297)dog);
            if (!(d < mindistanceSqr)) continue;
            target = i;
            mindistanceSqr = d;
        }
        return target;
    }

    public int getDelay() {
        return 10;
    }

    private boolean canAffordToExtinguish(AbstractDog dog) {
        return this.getWaterUnitleft() > 0 || this.level() >= this.talent.getMaxLevel();
    }

    private boolean stillValidTarget(Dog dog, class_1309 target) {
        if (!target.method_5805()) {
            return false;
        }
        if (target.method_20802() < 30) {
            return false;
        }
        if (!this.canAffordToExtinguish(dog)) {
            return false;
        }
        if (target.method_5771()) {
            return false;
        }
        return !(dog.method_5858((class_1297)target) > 400.0);
    }

    public static class ExtinguishAction
    extends TriggerableAction {
        private WaterHolderTalent talentInst;
        @Nonnull
        private class_1309 target;
        private int ticksUntilPathRecalc = 0;
        private final int stopDist = 2;

        public ExtinguishAction(Dog dog, WaterHolderTalent talentInst, @Nonnull class_1309 target) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.target = target;
        }

        @Override
        public void onStart() {
            this.ticksUntilPathRecalc = 0;
        }

        @Override
        public void tick() {
            if (this.dog.getMode().shouldAttack()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!this.talentInst.stillValidTarget(this.dog, this.target)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.method_5858((class_1297)this.target) > 4.0) {
                this.dog.method_5988().method_6226((class_1297)this.target, 10.0f, (float)this.dog.method_5978());
                if (--this.ticksUntilPathRecalc <= 0) {
                    this.ticksUntilPathRecalc = 10;
                    if (!this.dog.method_5934() && !this.dog.method_5765()) {
                        this.dog.method_5942().method_6335((class_1297)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.method_5942().method_6340();
                if (this.dog.canDogDoShakeAnim()) {
                    this.dog.startShakingAndBroadcast(false);
                    this.talentInst.scheduleDelayedExtinguish(this.dog);
                }
            }
        }

        @Override
        public void onStop() {
        }

        @Override
        public boolean canOverrideSit() {
            return true;
        }
    }
}

