/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.DoggyBlocks;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.util.NBTUtil;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public class DogBedUtil {
    private static final Random RANDOM = new Random(System.currentTimeMillis());

    public static void setBedVariant(DogBedTileEntity dogBedTileEntity, class_1799 stack) {
        Pair<ICasingMaterial, IBeddingMaterial> materials = DogBedUtil.getMaterials(stack);
        dogBedTileEntity.setCasing((ICasingMaterial)materials.getLeft());
        dogBedTileEntity.setBedding((IBeddingMaterial)materials.getRight());
    }

    public static class_1799 createRandomBed() {
        ICasingMaterial casing = DogBedMaterialManager.randomCasing();
        IBeddingMaterial bedding = DogBedMaterialManager.randomBedding();
        return DogBedUtil.createItemStack(casing, bedding);
    }

    public static Pair<ICasingMaterial, IBeddingMaterial> getMaterials(class_1799 stack) {
        class_2487 tag = stack.method_7941("doggytalents");
        if (tag != null) {
            ICasingMaterial casingId = DogBedMaterialManager.getCasing(tag, "casingId");
            IBeddingMaterial beddingId = DogBedMaterialManager.getBedding(tag, "beddingId");
            return Pair.of((Object)casingId, (Object)beddingId);
        }
        return Pair.of((Object)DogBedMaterialManager.NaniCasing.NULL, (Object)DogBedMaterialManager.NaniBedding.NULL);
    }

    public static class_1799 createItemStack(ICasingMaterial casingId, IBeddingMaterial beddingId) {
        class_1799 stack = new class_1799((class_1935)DoggyBlocks.DOG_BED.get(), 1);
        class_2487 tag = stack.method_7911("doggytalents");
        NBTUtil.putRegistryValue(tag, "casingId", DogBedMaterialManager.getKey(casingId));
        NBTUtil.putRegistryValue(tag, "beddingId", DogBedMaterialManager.getKey(beddingId));
        return stack;
    }

    public static ICasingMaterial getCasingFromStack(class_1799 stack) {
        for (Map.Entry<class_2960, ICasingMaterial> e : DogBedMaterialManager.getCasings().entrySet()) {
            ICasingMaterial m = e.getValue();
            if (m.getIngredient() == class_1856.field_9017 || !m.getIngredient().method_8093(stack)) continue;
            return m;
        }
        return null;
    }

    public static IBeddingMaterial getBeddingFromStack(class_1799 stack) {
        for (Map.Entry<class_2960, IBeddingMaterial> e : DogBedMaterialManager.getBeddings().entrySet()) {
            IBeddingMaterial m = e.getValue();
            if (m.getIngredient() == class_1856.field_9017 || !m.getIngredient().method_8093(stack)) continue;
            return m;
        }
        return null;
    }

    public static class_1799 createItemStackForced(class_2248 casing, class_2248 bedding) {
        class_1799 stack = new class_1799((class_1935)DoggyBlocks.DOG_BED.get(), 1);
        class_2487 tag = new class_2487();
        NBTUtil.putRegistryValue(tag, "casingId", class_7923.field_41175.method_10221((Object)casing));
        NBTUtil.putRegistryValue(tag, "beddingId", class_7923.field_41175.method_10221((Object)bedding));
        class_2487 maintag = new class_2487();
        maintag.method_10566("doggytalents", (class_2520)tag);
        stack.method_7980(maintag);
        return stack;
    }
}

