/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import com.google.common.collect.Lists;
import doggytalents.forge_imitate.registry.RegistryObject;
import io.netty.buffer.Unpooled;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1767;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class Util {
    private static final DecimalFormat dfShort = new DecimalFormat("0.0");
    private static final DecimalFormat dfShortDouble = new DecimalFormat("0.00");

    public static String format1DP(double value) {
        return dfShort.format(value);
    }

    public static String format2DP(double value) {
        return dfShortDouble.format(value);
    }

    public static boolean isPointInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)(x - 1) && mouseX < (double)(x + width + 1) && mouseY >= (double)(y - 1) && mouseY < (double)(y + height + 1);
    }

    public static float[] rgbIntToFloatArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }

    public static int[] rgbIntToIntArray(int rgbInt) {
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new int[]{r, g, b};
    }

    public static int[] srgbArrayToIntArray(float[] color_srgb) {
        int[] color_rgb = new int[color_srgb.length];
        for (int i = 0; i < color_srgb.length; ++i) {
            color_rgb[i] = (int)(color_srgb[i] * 255.0f);
        }
        return color_rgb;
    }

    public static int srgbArrayToInt(float[] color_srgb) {
        int[] color_rgb = Util.srgbArrayToIntArray(color_srgb);
        return color_rgb[0] << 16 | color_rgb[1] << 8 | color_rgb[2];
    }

    public static float getRelativeLuminance(float sr, float sg, float sb) {
        sr = sr < 0.03928f ? sr / 12.92f : (float)Math.pow(((double)sr + 0.055) / 1.055, 2.4);
        sg = sg < 0.03928f ? sg / 12.92f : (float)Math.pow(((double)sg + 0.055) / 1.055, 2.4);
        sb = sb < 0.03928f ? sb / 12.92f : (float)Math.pow(((double)sb + 0.055) / 1.055, 2.4);
        return sr + sg + sb;
    }

    public static float getRelativeLuminance(int color) {
        float[] arr = Util.rgbIntToFloatArray(color);
        return Util.getRelativeLuminance(arr[0], arr[1], arr[2]);
    }

    public static int getTextBlackOrWhite(int background_color) {
        float white_contrast;
        float luminance = Util.getRelativeLuminance(background_color);
        float black_contrast = (luminance + 0.05f) / 0.05f;
        return black_contrast > (white_contrast = 1.05f / (luminance + 0.05f)) ? 0 : -1;
    }

    public static int colorDye(int startColor, class_1767 dye) {
        return Util.colorDye(startColor, Lists.newArrayList((Object[])new class_1767[]{dye}));
    }

    public static int colorDye(int startColor, Collection<class_1767> dyes) {
        ArrayList<int[]> colors = new ArrayList<int[]>(dyes.size());
        for (class_1767 dye : dyes) {
            float[] color_srgb = dye.method_7787();
            int[] color_rgb = new int[color_srgb.length];
            for (int i = 0; i < color_srgb.length; ++i) {
                color_rgb[i] = (int)(color_srgb[i] * 255.0f);
            }
            colors.add(color_rgb);
        }
        if (startColor != -1) {
            colors.add(0, Util.rgbIntToIntArray(startColor));
        }
        return Util.colorDye(colors);
    }

    public static int colorDye(Collection<int[]> colors) {
        int[] temp = new int[3];
        int maxCompSum = 0;
        for (int[] color : colors) {
            maxCompSum += Math.max(color[0], Math.max(color[1], color[2]));
            temp[0] = temp[0] + color[0];
            temp[1] = temp[1] + color[1];
            temp[2] = temp[2] + color[2];
        }
        int redAve = temp[0] / colors.size();
        int greenAve = temp[1] / colors.size();
        int blueAve = temp[2] / colors.size();
        float maxAve = (float)maxCompSum / (float)colors.size();
        float max = Math.max(redAve, Math.max(greenAve, blueAve));
        redAve = (int)((float)redAve * maxAve / max);
        greenAve = (int)((float)greenAve * maxAve / max);
        blueAve = (int)((float)blueAve * maxAve / max);
        int finalColor = (redAve << 8) + greenAve;
        finalColor = (finalColor << 8) + blueAve;
        return finalColor;
    }

    public static class_2960 getResource(String name) {
        return Util.getResource("doggytalents", name);
    }

    public static class_2960 getResource(String modId, String name) {
        return new class_2960(modId, name);
    }

    public static class_2960 getVanillaResource(String name) {
        return new class_2960(name);
    }

    public static class_2960 parseResource(String str) {
        return class_2960.method_12829((String)str);
    }

    public static String getResourcePath(String name) {
        return Util.getResourcePath("doggytalents", name);
    }

    public static String getResourcePath(String modId, String name) {
        return Util.getResource(modId, name).toString();
    }

    public static class_2960 modifyPath(class_2960 target, Function<String, String> modifier) {
        String namespace = target.method_12836();
        String path = target.method_12832();
        String new_path = modifier.apply(path);
        return Util.getResource(namespace, new_path);
    }

    public static class_2540 createBuf() {
        return new class_2540(Unpooled.buffer());
    }

    public static <T> T make(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T make(T object, Consumer<T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static <T> Supplier<T> acceptOrElse(Supplier<T> opt, Consumer<T> consumer, Runnable orElse) {
        if (opt.get() != null) {
            consumer.accept(opt.get());
        } else {
            orElse.run();
        }
        return opt;
    }

    public static <T> Optional<T> acceptOrElse(Optional<T> opt, Consumer<T> consumer, Runnable orElse) {
        if (opt.isPresent()) {
            consumer.accept(opt.get());
        } else {
            orElse.run();
        }
        return opt;
    }

    public static <T> boolean allMatch(Iterable<T> input, Predicate<T> matcher) {
        Objects.requireNonNull(matcher);
        for (T e : input) {
            if (matcher.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean anyMatch(Iterable<T> input, Predicate<T> matcher) {
        Objects.requireNonNull(matcher);
        for (T e : input) {
            if (!matcher.test(e)) continue;
            return true;
        }
        return false;
    }

    public static class_2960 getRegistryId(Object obj) {
        if (obj instanceof class_2960) {
            return (class_2960)obj;
        }
        if (obj instanceof String) {
            return class_2960.method_12829((String)((String)obj));
        }
        if (obj instanceof RegistryObject) {
            return ((RegistryObject)obj).getId();
        }
        return null;
    }

    public static long tickMayWithPartialToMillis(double tickMayWithPartial) {
        double second = tickMayWithPartial / 20.0;
        return class_3532.method_15372((double)(second * 1000.0));
    }

    public static double millisToTickMayWithPartial(long millis) {
        double second = (double)millis / 1000.0;
        return second * 20.0;
    }
}

