/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.forge_imitate.event;

import doggytalents.forge_imitate.event.Event;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class EventCallbacksRegistry {
    private static ArrayList<EventCallBack<?>> CALLBACKS = new ArrayList();

    public static synchronized void registerCallback(EventCallBack<?> callback) {
        CALLBACKS.add(callback);
    }

    public static <E extends Event> E postEvent(E event) {
        CALLBACKS.forEach((Consumer<EventCallBack<?>>)((Consumer<EventCallBack>)x -> x.mayInvoke(event)));
        return event;
    }

    public static interface EventCallBack<E extends Event> {
        public void mayInvoke(Event var1);
    }

    public static class InstanceEventCallBack<T, E extends Event>
    implements EventCallBack<E> {
        private T self;
        private Class<E> eventType;
        private BiConsumer<T, E> callBack;

        public InstanceEventCallBack(T self, Class<E> eventType, BiConsumer<T, E> callBack) {
            this.self = self;
            this.eventType = eventType;
            this.callBack = callBack;
        }

        public Class<E> getEventType() {
            return this.eventType;
        }

        @Override
        public void mayInvoke(Event event) {
            if (event.getClass() != this.eventType) {
                return;
            }
            this.callBack.accept(this.self, (Event)this.eventType.cast(event));
        }
    }

    public static class SingleEventCallBack<E extends Event>
    implements EventCallBack<E> {
        private Class<E> eventType;
        private Consumer<E> callBack;

        public SingleEventCallBack(Class<E> eventType, Consumer<E> callBack) {
            this.eventType = eventType;
            this.callBack = callBack;
        }

        public Class<E> getEventType() {
            return this.eventType;
        }

        @Override
        public void mayInvoke(Event event) {
            if (event.getClass() != this.eventType) {
                return;
            }
            this.callBack.accept((Event)this.eventType.cast(event));
        }
    }
}

