/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.forge_imitate.network;

import com.google.common.collect.Maps;
import doggytalents.common.util.Util;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1255;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ForgeNetworkHandler {
    public static class_2960 CHANNEL_ID = Util.getResource("channel");
    private static Map<Integer, PacketCodec<?>> PACKET_MAP = Maps.newHashMap();
    private static Map<Class<?>, Integer> DATACLASS_ID_MAP = Maps.newHashMap();

    public synchronized <D> void registerMessage(int id, Class<D> dataClass, BiConsumer<D, class_2540> encoder, Function<class_2540, D> decoder, BiConsumer<D, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_MAP.put(id, new PacketCodec<D>(dataClass, encoder, decoder, messageConsumer));
        DATACLASS_ID_MAP.put(dataClass, id);
    }

    public <D> void send(PacketDistributor.PacketTarget<?> target, D data) {
        Integer dataId = DATACLASS_ID_MAP.get(data.getClass());
        if (dataId == null) {
            return;
        }
        PacketCodec<?> codec = PACKET_MAP.get(dataId);
        if (codec == null) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(dataId.intValue());
        codec.encoder.accept(data, buf);
        target.sendPacket(buf, CHANNEL_ID);
    }

    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL_ID, (server, player, handler, buff, response) -> {
            int id = buff.readInt();
            PacketCodec<?> packet = PACKET_MAP.get(id);
            if (packet == null) {
                return;
            }
            NetworkEvent.Context ctx = new NetworkEvent.Context();
            ctx.sender = player;
            ctx.executor = server;
            packet.decodeAndConsume(buff, ctx);
        });
    }

    public static void onToClientPacket(class_1255<?> exec, class_2540 buf) {
        int id = buf.readInt();
        PacketCodec<?> packet = PACKET_MAP.get(id);
        if (packet == null) {
            return;
        }
        NetworkEvent.Context ctx = new NetworkEvent.Context();
        ctx.sender = null;
        ctx.isClientRecipent = true;
        ctx.executor = exec;
        packet.decodeAndConsume(buf, ctx);
    }

    private static class PacketCodec<T> {
        public final Class<T> dataClass;
        public final BiConsumer<T, class_2540> encoder;
        public final Function<class_2540, T> decoder;
        public final BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer;

        PacketCodec(Class<T> dataClass, BiConsumer<T, class_2540> encoder, Function<class_2540, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
            this.dataClass = dataClass;
            this.encoder = encoder;
            this.decoder = decoder;
            this.messageConsumer = messageConsumer;
        }

        public void decodeAndConsume(class_2540 buf, NetworkEvent.Context ctx) {
            T data = this.decoder.apply(buf);
            this.messageConsumer.accept(data, () -> ctx);
        }
    }

    public static class NetworkEvent {

        public static class Context {
            @Nullable
            private class_3222 sender;
            private class_1255<?> executor;
            private boolean isClientRecipent = false;

            public void enqueueWork(Runnable runnable) {
                this.executor.execute(runnable);
            }

            @Nullable
            public class_3222 getSender() {
                return this.sender;
            }

            public boolean isClientRecipent() {
                return this.isClientRecipent;
            }

            public boolean isServerRecipent() {
                return !this.isClientRecipent;
            }

            public void setPacketHandled(boolean val) {
            }
        }
    }
}

