/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.api.targeting;

import net.minecraft.class_238;
import net.minecraft.class_243;

public class VectorHelper {
    public static double angleBetween(class_243 a, class_243 b) {
        double cosineTheta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        double angle = Math.acos(cosineTheta) * 57.29577951308232;
        return Double.isNaN(angle) ? 0.0 : angle;
    }

    public static double angleWithSignBetween(class_243 a, class_243 b, class_243 planeNormal) {
        double cosineTheta = a.method_1026(b) / (a.method_1033() * b.method_1033());
        double angle = Math.toDegrees(Math.acos(cosineTheta));
        class_243 cross = a.method_1036(b);
        return Double.isNaN(angle *= Math.signum(cross.method_1026(planeNormal))) ? 0.0 : angle;
    }

    public static class_243 distanceVector(class_243 point, class_238 box) {
        double dx = 0.0;
        if (box.field_1323 > point.field_1352) {
            dx = box.field_1323 - point.field_1352;
        } else if (box.field_1320 < point.field_1352) {
            dx = box.field_1320 - point.field_1352;
        }
        double dy = 0.0;
        if (box.field_1322 > point.field_1351) {
            dy = box.field_1322 - point.field_1351;
        } else if (box.field_1325 < point.field_1351) {
            dy = box.field_1325 - point.field_1351;
        }
        double dz = 0.0;
        if (box.field_1321 > point.field_1350) {
            dz = box.field_1321 - point.field_1350;
        } else if (box.field_1324 < point.field_1350) {
            dz = box.field_1324 - point.field_1350;
        }
        return new class_243(dx, dy, dz);
    }

    public static class_243 rotateTowards(class_243 vector, class_243 towards, double angleToRotate) {
        class_243 rotated;
        if (angleToRotate == 0.0) {
            return vector;
        }
        class_243 originalVector = new class_243(vector.field_1352, vector.field_1351, vector.field_1350);
        double angleBetween = VectorHelper.angleWithSignBetween(vector = vector.method_1029(), towards = towards.method_1029(), vector.method_1036(towards));
        if (angleBetween == 0.0) {
            return originalVector;
        }
        if (angleBetween <= angleToRotate) {
            rotated = towards;
        } else {
            double towardsLength = Math.sin(Math.toRadians(angleToRotate)) / Math.cos(Math.toRadians(90.0 - angleBetween + angleToRotate));
            class_243 v2 = towards.method_1021(towardsLength);
            rotated = vector.method_1019(v2).method_1029();
        }
        rotated = rotated.method_1021(originalVector.method_1033());
        return rotated;
    }

    public static class_243 axisFromRotation(float yaw, float pitch) {
        double yawRadians = Math.toRadians(-yaw);
        double pitchRadians = Math.toRadians(-pitch);
        double x = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double y = -Math.sin(pitchRadians);
        double z = Math.cos(yawRadians) * Math.cos(pitchRadians);
        return new class_243(x, y, z).method_1029();
    }

    public static class_243 rotateAround(class_243 vector, float angleDegrees, float yaw, float pitch) {
        class_243 axisOfRotation = VectorHelper.axisFromRotation(yaw, pitch);
        return VectorHelper.rotateAround(vector, axisOfRotation, angleDegrees);
    }

    public static class_243 rotateAround(class_243 vector, class_243 axisOfRotation, double angleDegrees) {
        double angleRadians = Math.toRadians(angleDegrees);
        double sinHalfAngle = Math.sin(angleRadians / 2.0);
        double cosHalfAngle = Math.cos(angleRadians / 2.0);
        double rx = axisOfRotation.field_1352 * sinHalfAngle;
        double ry = axisOfRotation.field_1351 * sinHalfAngle;
        double rz = axisOfRotation.field_1350 * sinHalfAngle;
        double invRx = -rx;
        double invRy = -ry;
        double invRz = -rz;
        double[] q = VectorHelper.multiplyQuaternions(new double[]{rx, ry, rz, cosHalfAngle}, new double[]{vector.field_1352, vector.field_1351, vector.field_1350, 0.0});
        double[] p = VectorHelper.multiplyQuaternions(q, new double[]{invRx, invRy, invRz, cosHalfAngle});
        return new class_243(p[0], p[1], p[2]);
    }

    private static double[] multiplyQuaternions(double[] q1, double[] q2) {
        double x = q1[3] * q2[0] + q1[0] * q2[3] + q1[1] * q2[2] - q1[2] * q2[1];
        double y = q1[3] * q2[1] + q1[1] * q2[3] + q1[2] * q2[0] - q1[0] * q2[2];
        double z = q1[3] * q2[2] + q1[2] * q2[3] + q1[0] * q2[1] - q1[1] * q2[0];
        double w = q1[3] * q2[3] - q1[0] * q2[0] - q1[1] * q2[1] - q1[2] * q2[2];
        return new double[]{x, y, z, w};
    }

    public static double yawFromNormalized(class_243 vector) {
        return Math.toDegrees(Math.atan2(-vector.field_1352, vector.field_1350));
    }

    public static double pitchFromNormalized(class_243 vector) {
        return Math.toDegrees(-Math.asin(vector.field_1351));
    }
}

