/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.handler;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import fuzs.puzzleslib.api.event.v1.data.MutableInt;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class HuntingBowHandler {
    private static final float BOW_MULTISHOT_ANGLE = 10.0f;

    public static EventResult onArrowLoose(class_1657 player, class_1799 stack, class_1937 level, MutableInt charge, boolean hasAmmo) {
        if (hasAmmo && class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)stack) > 0) {
            float velocity = class_1753.method_7722((int)charge.getAsInt());
            if (!level.field_9236 && velocity >= 0.1f) {
                class_1799 projectile = player.method_18808(stack);
                class_1744 item = (class_1744)(projectile.method_7909() instanceof class_1744 ? projectile.method_7909() : class_1802.field_8107);
                for (int i = 0; i < 2; ++i) {
                    HuntingBowHandler.createAndShootArrow(player, stack, level, item, projectile, -10.0f + (float)i * 10.0f * 2.0f, velocity);
                }
            }
        }
        return EventResult.PASS;
    }

    private static void createAndShootArrow(class_1657 player, class_1799 stack, class_1937 level, class_1744 item, class_1799 projectile, float shootAngle, float velocity) {
        class_1665 abstractArrow = item.method_7702(level, projectile, (class_1309)player);
        abstractArrow.method_24919((class_1297)player, player.method_36455(), player.method_36454() + shootAngle, 0.0f, velocity * 3.0f, 1.5f);
        if (velocity == 1.0f) {
            abstractArrow.method_7439(true);
        }
        HuntingBowHandler.applyPowerEnchantment(abstractArrow, stack);
        HuntingBowHandler.applyPunchEnchantment(abstractArrow, stack);
        HuntingBowHandler.applyFlameEnchantment(abstractArrow, stack);
        HuntingBowHandler.applyPiercingEnchantment(abstractArrow, stack);
        HuntingBowHandler.applyWitheringEnchantment(abstractArrow, stack);
        abstractArrow.field_7572 = class_1665.class_1666.field_7594;
        level.method_8649((class_1297)abstractArrow);
        level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0f, 1.0f / (level.method_8409().method_43057() * 0.4f + 1.2f) + velocity * 0.5f);
    }

    public static EventResult onUseItemTick(class_1309 entity, class_1799 useItem, MutableInt useItemRemaining) {
        if (useItem.method_7909() instanceof class_1753 && useItem.method_7935() - useItemRemaining.getAsInt() < 20) {
            int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)useItem);
            useItemRemaining.mapInt(duration -> duration - quickChargeLevel);
        }
        return EventResult.PASS;
    }

    public static void applyPowerEnchantment(class_1665 arrow, class_1799 stack) {
        int level = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack);
        if (level > 0) {
            arrow.method_7438(arrow.method_7448() + (double)level * 0.5 + 0.5);
        }
    }

    public static void applyPunchEnchantment(class_1665 arrow, class_1799 stack) {
        int level = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)stack);
        if (level > 0) {
            arrow.method_7449(level);
        }
    }

    public static void applyFlameEnchantment(class_1665 arrow, class_1799 stack) {
        if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)stack) > 0) {
            arrow.method_5639(100);
        }
    }

    public static void applyPiercingEnchantment(class_1665 arrow, class_1799 stack) {
        int level = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)stack);
        if (level > 0) {
            arrow.method_7451((byte)level);
        }
    }

    public static void applyWitheringEnchantment(class_1665 arrow, class_1799 stack) {
        HuntingBowHandler.applyWitheringEnchantment(arrow, class_1890.method_8225((class_1887)((class_1887)ModRegistry.WITHERING_ENCHANTMENT.get()), (class_1799)stack));
    }

    public static void applyWitheringEnchantment(class_1665 arrow, class_1309 shooter) {
        HuntingBowHandler.applyWitheringEnchantment(arrow, class_1890.method_8203((class_1887)((class_1887)ModRegistry.WITHERING_ENCHANTMENT.get()), (class_1309)shooter));
    }

    private static void applyWitheringEnchantment(class_1665 arrow, int level) {
        if (level > 0 && arrow instanceof class_1667) {
            ((class_1667)arrow).method_7463(new class_1293(class_1294.field_5920, 100 * level));
        }
    }
}

