/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.ai.goal;

import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1380;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_3532;

public class RangedBowEasyAttackGoal<T extends class_1588>
extends class_1380<T> {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private final int maxAttackTime;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;

    public RangedBowEasyAttackGoal(T mob, double speedModifier, int attackIntervalMin, int maxAttackTime, float attackRadius) {
        super(mob, speedModifier, attackIntervalMin, attackRadius);
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.maxAttackTime = maxAttackTime;
        this.attackRadiusSqr = attackRadius * attackRadius;
    }

    public void method_6305(int attackCooldownIn) {
        this.attackIntervalMin = attackCooldownIn;
    }

    protected boolean method_6306() {
        return this.mob.method_24520(stack -> stack.method_7909() instanceof class_1753);
    }

    public void method_6270() {
        this.mob.method_19540(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.method_6021();
    }

    public void method_6268() {
        class_1309 attackTarget = this.mob.method_5968();
        if (attackTarget != null) {
            double distanceToTarget = this.mob.method_5649(attackTarget.method_23317(), attackTarget.method_23318(), attackTarget.method_23321());
            boolean canSeeTarget = this.mob.method_5985().method_6369((class_1297)attackTarget);
            if (canSeeTarget != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            boolean moveTowardsTarget = false;
            if (distanceToTarget <= (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.mob.method_5942().method_6340();
                moveTowardsTarget = distanceToTarget > (double)(this.attackRadiusSqr * 0.75f);
            } else {
                this.mob.method_5942().method_6335((class_1297)attackTarget, this.speedModifier);
            }
            if (moveTowardsTarget) {
                this.mob.method_5962().method_6243(0.5f, 0.0f);
                this.mob.method_5951((class_1297)attackTarget, 30.0f, 30.0f);
            } else {
                this.mob.method_5988().method_6226((class_1297)attackTarget, 30.0f, 30.0f);
            }
            if (this.mob.method_6115()) {
                int useCount;
                if (!canSeeTarget && this.seeTime < -this.maxAttackTime) {
                    this.mob.method_6021();
                } else if (canSeeTarget && (useCount = this.mob.method_6048()) >= 20) {
                    this.mob.method_6021();
                    double distanceVelocity = Math.sqrt(distanceToTarget) / Math.sqrt(this.attackRadiusSqr);
                    ((class_1603)this.mob).method_7105(attackTarget, class_3532.method_15363((float)((float)distanceVelocity), (float)0.1f, (float)1.0f) * class_1753.method_7722((int)useCount));
                    this.attackTime = class_3532.method_15357((double)(distanceVelocity * (double)((float)this.maxAttackTime - (float)this.attackIntervalMin / 2.0f) + (double)((float)this.attackIntervalMin / 2.0f)));
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -this.maxAttackTime) {
                this.mob.method_6019(RangedBowEasyAttackGoal.getWeaponHoldingHand(this.mob, stack -> stack.method_7909() instanceof class_1753));
            }
        }
    }

    public static class_1268 getWeaponHoldingHand(class_1309 entity, Predicate<class_1799> filter) {
        return filter.test(entity.method_6047()) ? class_1268.field_5808 : class_1268.field_5810;
    }
}

