/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.init.ModRegistry;
import fuzs.enderzoology.world.entity.ai.goal.FollowPackLeaderGoal;
import fuzs.enderzoology.world.entity.monster.PackMob;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_6019;
import org.jetbrains.annotations.Nullable;

public class DireWolf
extends class_1493
implements class_1569,
PackMob {
    private static final class_6019 EATING_TIME = class_4802.method_24505((int)20, (int)39);
    private static final Predicate<class_1542> ALLOWED_ITEMS = itemEntity -> !itemEntity.method_6977() && itemEntity.method_5805() && !(itemEntity.method_6983().method_7909() instanceof class_1747);
    @Nullable
    private DireWolf wolfPackLeader;
    private int wolfPackSize = 1;
    private int ticksSinceEaten;

    public DireWolf(class_1299<? extends class_1493> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6194 = 10;
        this.method_5952(true);
        this.ticksSinceEaten = EATING_TIME.method_35008(this.field_5974);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1359((class_1308)this, 0.4f));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(4, (class_1352)new SearchForItemsGoal((class_1308)this));
        this.field_6201.method_6277(5, new FollowPackLeaderGoal<DireWolf>(this));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1493.class, 8, true, false, entity -> entity.method_5864() == class_1299.field_6055));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1308.class, 12, true, false, entity -> (entity instanceof class_1429 || entity instanceof class_1642) && !(entity instanceof class_1493) && this.isHungry() && !this.method_6047().method_19267()));
        this.field_6185.method_6277(5, (class_1352)new class_5398((class_1308)this, true));
    }

    public int method_6110() {
        return this.field_6194;
    }

    protected boolean method_23734() {
        return true;
    }

    public int method_5945() {
        return this.getMaxSchoolSize();
    }

    @Override
    public int getMaxSchoolSize() {
        return super.method_5945();
    }

    @Override
    public boolean isFollower() {
        return this.wolfPackLeader != null && this.wolfPackLeader.method_5805();
    }

    @Override
    public void startFollowing(PackMob leader) {
        if (leader == this) {
            throw new IllegalStateException("Wolf cannot follow itself");
        }
        this.wolfPackLeader = (DireWolf)leader;
        leader.addFollower();
    }

    @Override
    public void addFollower() {
        ++this.wolfPackSize;
    }

    @Override
    public void removeFollower() {
        --this.wolfPackSize;
    }

    @Override
    public void stopFollowing() {
        this.wolfPackLeader.removeFollower();
        this.wolfPackLeader = null;
    }

    @Override
    public boolean canBeFollowed() {
        return this.hasFollowers() && this.wolfPackSize < this.getMaxSchoolSize();
    }

    public void method_5773() {
        List list;
        super.method_5773();
        if (this.hasFollowers() && this.method_37908().field_9229.method_43048(200) == 1 && (list = this.method_37908().method_18467(this.getClass(), this.method_5829().method_1009(8.0, 8.0, 8.0))).size() <= 1) {
            this.wolfPackSize = 1;
        }
    }

    @Override
    public boolean hasFollowers() {
        return this.wolfPackSize > 1;
    }

    @Override
    public boolean inRangeOfLeader() {
        return this.method_5858((class_1297)this.wolfPackLeader) <= 121.0;
    }

    @Override
    public boolean tooCloseToLeader() {
        return this.method_5858((class_1297)this.wolfPackLeader) < 9.0;
    }

    @Override
    public void pathToLeader() {
        if (this.isFollower()) {
            this.method_5942().method_6335((class_1297)this.wolfPackLeader, 1.0);
        }
    }

    @Override
    public void addFollowers(Stream<? extends PackMob> followers) {
        followers.limit(this.getMaxSchoolSize() - this.wolfPackSize).filter(packMob -> packMob != this).forEach(packMob -> packMob.startFollowing(this));
    }

    @Nullable
    public class_1315 method_5943(class_5425 pLevel, class_1266 pDifficulty, class_3730 pReason, @Nullable class_1315 pSpawnData, @Nullable class_2487 pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new PackSpawnGroupData(this);
        } else if (pSpawnData instanceof PackSpawnGroupData) {
            PackSpawnGroupData packSpawnData = (PackSpawnGroupData)((Object)pSpawnData);
            this.startFollowing(packSpawnData.leader);
        }
        return super.method_5943(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void method_6007() {
        if (!this.method_37908().field_9236 && this.method_5805() && this.method_6034()) {
            class_1799 itemStack = this.method_6118(class_1304.field_6173);
            if (this.canEat(itemStack) && --this.ticksSinceEaten < 40 && this.field_5974.method_43057() < 0.1f && !this.method_6115()) {
                this.method_6019(class_1268.field_5808);
            } else if (this.ticksSinceEaten < 0) {
                this.ticksSinceEaten = EATING_TIME.method_35008(this.field_5974);
            }
        }
        super.method_6007();
    }

    public class_1799 method_18866(class_1937 level, class_1799 food) {
        class_1792 item = food.method_7909();
        if (item.method_19263()) {
            this.method_6025((float)item.method_19264().method_19230() * (item.method_19264().method_19232() ? 2.0f : 1.0f));
            this.method_37908().method_8421((class_1297)this, (byte)18);
        }
        return super.method_18866(level, food);
    }

    public void method_5711(byte id) {
        if (id == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        } else {
            super.method_5711(id);
        }
    }

    private boolean isHungry() {
        return this.method_6032() < this.method_6063();
    }

    private boolean canEat(class_1799 stack) {
        return stack.method_7909().method_19263() && this.method_5968() == null && this.method_24828() && this.isHungry();
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public boolean method_18397(class_1799 stack) {
        class_1304 equipmentSlot = class_1308.method_32326((class_1799)stack);
        if (!this.method_6118(equipmentSlot).method_7960()) {
            return false;
        }
        return equipmentSlot == class_1304.field_6173 && super.method_18397(stack);
    }

    public boolean method_5939(class_1799 stack) {
        class_1792 item = stack.method_7909();
        class_1799 itemStack = this.method_6118(class_1304.field_6173);
        return itemStack.method_7960() || item.method_19263() && !itemStack.method_7909().method_19263();
    }

    private void spitOutItem(class_1799 stack) {
        if (!stack.method_7960() && !this.method_37908().field_9236) {
            class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317() + this.method_5720().field_1352, this.method_23318() + 1.0, this.method_23321() + this.method_5720().field_1350, stack);
            itemEntity.method_6982(40);
            itemEntity.method_6981(this.method_5667());
            this.method_5783(class_3417.field_18054, 1.0f, 1.0f);
            this.method_37908().method_8649((class_1297)itemEntity);
        }
    }

    private void dropItemStack(class_1799 stack) {
        class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack);
        this.method_37908().method_8649((class_1297)itemEntity);
    }

    protected void method_5949(class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        if (this.method_5939(itemStack)) {
            int i = itemStack.method_7947();
            if (i > 1) {
                this.dropItemStack(itemStack.method_7971(i - 1));
            }
            this.spitOutItem(this.method_6118(class_1304.field_6173));
            this.method_29499(itemEntity);
            this.method_5673(class_1304.field_6173, itemStack.method_7971(1));
            this.method_25939(class_1304.field_6173);
            this.method_6103((class_1297)itemEntity, itemStack.method_7947());
            itemEntity.method_31472();
            this.ticksSinceEaten = EATING_TIME.method_35008(this.field_5974);
        }
    }

    protected void method_16080(class_1282 damageSource) {
        class_1799 itemStack = this.method_6118(class_1304.field_6173);
        if (!itemStack.method_7960()) {
            this.method_5775(itemStack);
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        super.method_16080(damageSource);
    }

    protected class_3414 method_5994() {
        return this.field_5974.method_43057() < 0.1f ? (class_3414)ModRegistry.DIRE_WOLF_HOWL_SOUND_EVENT.get() : (class_3414)ModRegistry.DIRE_WOLF_GROWL_SOUND_EVENT.get();
    }

    protected class_3414 method_6011(class_1282 pDamageSource) {
        return (class_3414)ModRegistry.DIRE_WOLF_HURT_SOUND_EVENT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModRegistry.DIRE_WOLF_DEATH_SOUND_EVENT.get();
    }

    public boolean method_6181() {
        return false;
    }

    public void method_6173(boolean tamed) {
    }

    public boolean method_29511() {
        return true;
    }

    public boolean method_6710() {
        return false;
    }

    public boolean method_6172() {
        return false;
    }

    public int method_5618() {
        return 0;
    }

    public void method_5614(int age) {
    }

    public void method_6712(boolean isInterested) {
    }

    public class_1493 method_6717(class_3218 level, class_1296 otherParent) {
        return null;
    }

    static class SearchForItemsGoal
    extends class_1352 {
        private final class_1308 mob;

        public SearchForItemsGoal(class_1308 mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!this.mob.method_6118(class_1304.field_6173).method_7960()) {
                return false;
            }
            if (this.mob.method_5968() == null && this.mob.method_6065() == null) {
                if (this.mob.method_6051().method_43048(SearchForItemsGoal.method_38848((int)10)) != 0) {
                    return false;
                }
                List list = this.mob.method_37908().method_8390(class_1542.class, this.mob.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
                return !list.isEmpty() && this.mob.method_6118(class_1304.field_6173).method_7960();
            }
            return false;
        }

        public void method_6268() {
            List list = this.mob.method_37908().method_8390(class_1542.class, this.mob.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            class_1799 itemStack = this.mob.method_6118(class_1304.field_6173);
            if (itemStack.method_7960() && !list.isEmpty()) {
                this.mob.method_5942().method_6335((class_1297)list.get(0), 1.2);
            }
        }

        public void method_6269() {
            List list = this.mob.method_37908().method_8390(class_1542.class, this.mob.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!list.isEmpty()) {
                this.mob.method_5942().method_6335((class_1297)list.get(0), 1.2);
            }
        }
    }

    public static class PackSpawnGroupData
    extends class_1296.class_4697 {
        public final PackMob leader;

        public PackSpawnGroupData(PackMob leader) {
            super(false);
            this.leader = leader;
        }
    }
}

