/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enderzoology.world.entity.monster;

import fuzs.enderzoology.core.CommonAbstractions;
import fuzs.enderzoology.init.ModRegistry;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1344;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1384;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1496;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4059;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class FallenMount
extends class_1496
implements class_1569 {
    public static final String TAG_HORSE_DATA = "HorseData";
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("870A1AC8-9BD8-11ED-A8FC-0242AC120002");
    private static final class_2940<Boolean> DATA_CONVERTING_ID = class_2945.method_12791(FallenMount.class, (class_2941)class_2943.field_13323);
    @Nullable
    private class_2487 horseData;
    private int conversionTime;
    @Nullable
    private UUID conversionStarter;

    public FallenMount(class_1299<? extends class_1496> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6194 = 5;
    }

    protected static String getEncodeId(class_1297 entity) {
        class_1299 entityType = entity.method_5864();
        class_2960 resourceLocation = class_1299.method_5890((class_1299)entityType);
        return entityType.method_5893() && resourceLocation != null ? resourceLocation.toString() : null;
    }

    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new MountRestrictSunGoal((class_1314)this));
        this.field_6201.method_6277(3, (class_1352)new MountFleeSunGoal((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1366((class_1314)this, 1.2f, false){

            public boolean method_6264() {
                return !this.field_6503.method_5782() && super.method_6264();
            }
        });
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1496.class, false, entity -> entity.method_5864().method_20210(ModRegistry.FALLEN_MOUNT_TARGETS_ENTITY_TYPE_TAG)));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    public int method_6110() {
        return this.field_6194;
    }

    protected boolean method_23734() {
        return true;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_CONVERTING_ID, (Object)false);
    }

    protected void method_6001(class_5819 randomSource) {
        this.method_5996(class_5134.field_23728).method_6192(FallenMount.method_6774(() -> ((class_5819)randomSource).method_43058()));
    }

    public void method_5773() {
        if (!this.method_37908().field_9236 && this.method_5805() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime <= 0) {
                this.finishConversion();
            }
        }
        super.method_5773();
    }

    public boolean method_6762() {
        return false;
    }

    public boolean method_6765() {
        return false;
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        if (passenger instanceof class_1309) {
            class_1309 living = (class_1309)passenger;
            living.field_6283 = this.field_6283;
            living.field_6241 = this.field_6241;
            living.method_36456(this.method_36454());
            living.method_36457(this.method_36455());
        }
    }

    public boolean method_5810() {
        return this.method_5805() && !this.method_7325() && !this.method_6101();
    }

    public boolean method_6062() {
        return this.method_29504();
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (itemStack.method_31574(class_1802.field_8463)) {
            if (this.method_6059(class_1294.field_5911)) {
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                if (!this.method_37908().field_9236) {
                    this.startConverting(player.method_5667(), this.field_5974.method_43048(2400) + 3600);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public void method_6007() {
        if (this.method_5805() && this.method_5972() && !this.method_5782() && !this.method_6753()) {
            this.method_5639(8);
        }
        super.method_6007();
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        float selector = random.method_43057();
        class_1792 item = selector < 0.015f ? class_1802.field_8807 : (selector < 0.05f ? class_1802.field_8560 : (selector < 0.2f ? class_1802.field_18138 : class_1802.field_8578));
        this.setArmor(new class_1799((class_1935)item));
    }

    public boolean method_6725() {
        return true;
    }

    public boolean method_6735() {
        return true;
    }

    public boolean method_6773(class_1799 stack) {
        return stack.method_7909() instanceof class_4059;
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.horseData != null) {
            compoundTag.method_10566(TAG_HORSE_DATA, (class_2520)this.horseData);
        }
        if (!this.field_6962.method_5438(1).method_7960()) {
            compoundTag.method_10566("ArmorItem", (class_2520)this.field_6962.method_5438(1).method_7953(new class_2487()));
        }
        compoundTag.method_10569("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        if (this.conversionStarter != null) {
            compoundTag.method_25927("ConversionPlayer", this.conversionStarter);
        }
    }

    public class_1799 getArmor() {
        return this.method_6118(class_1304.field_6174);
    }

    private void setArmor(class_1799 pStack) {
        this.method_5673(class_1304.field_6174, pStack);
        this.method_5946(class_1304.field_6174, 0.0f);
    }

    public void method_5749(class_2487 compoundTag) {
        class_1799 itemstack;
        super.method_5749(compoundTag);
        this.horseData = compoundTag.method_10562(TAG_HORSE_DATA);
        if (compoundTag.method_10573("ArmorItem", 10) && !(itemstack = class_1799.method_7915((class_2487)compoundTag.method_10562("ArmorItem"))).method_7960() && this.method_6773(itemstack)) {
            this.field_6962.method_5447(1, itemstack);
        }
        if (compoundTag.method_10573("ConversionTime", 99) && compoundTag.method_10550("ConversionTime") > -1) {
            this.startConverting(compoundTag.method_25928("ConversionPlayer") ? compoundTag.method_25926("ConversionPlayer") : null, compoundTag.method_10550("ConversionTime"));
        }
        this.method_6731();
    }

    protected void method_6731() {
        if (!this.method_37908().field_9236) {
            super.method_6731();
            this.setArmorEquipment(this.field_6962.method_5438(1));
            this.method_5946(class_1304.field_6174, 0.0f);
        }
    }

    private void setArmorEquipment(class_1799 stack) {
        this.setArmor(stack);
        if (!this.method_37908().field_9236) {
            int i;
            this.method_5996(class_5134.field_23724).method_6200(ARMOR_MODIFIER_UUID);
            if (this.method_6773(stack) && (i = ((class_4059)stack.method_7909()).method_18455()) != 0) {
                this.method_5996(class_5134.field_23724).method_26835(new class_1322(ARMOR_MODIFIER_UUID, "Horse armor bonus", (double)i, class_1322.class_1323.field_6328));
            }
        }
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.isConverting() && (this.horseData == null || !this.horseData.method_10577("Tame"));
    }

    public boolean isConverting() {
        return (Boolean)this.method_5841().method_12789(DATA_CONVERTING_ID);
    }

    private void startConverting(@Nullable UUID conversionStarter, int conversionTime) {
        this.conversionStarter = conversionStarter;
        this.conversionTime = conversionTime;
        this.method_5841().method_12778(DATA_CONVERTING_ID, (Object)true);
        this.method_6016(class_1294.field_5911);
        this.method_6092(new class_1293(class_1294.field_5910, conversionTime, Math.min(this.method_37908().method_8407().method_5461() - 1, 0)));
        this.method_37908().method_8421((class_1297)this, (byte)16);
    }

    public void method_5711(byte id) {
        if (id == 16) {
            if (!this.method_5701()) {
                this.method_37908().method_8486(this.method_23317(), this.method_23320(), this.method_23321(), class_3417.field_14905, this.method_5634(), 1.0f + this.field_5974.method_43057(), this.field_5974.method_43057() * 0.7f + 0.3f, false);
            }
        } else {
            super.method_5711(id);
        }
    }

    private void finishConversion() {
        this.recreateHorseFromData(this.method_37908(), this).or(this::createFreshHorse).ifPresent(entity -> {
            entity.method_6092(new class_1293(class_1294.field_5916, 200, 0));
            if (!this.method_5701()) {
                this.method_37908().method_8444(null, 1027, this.method_24515(), 0);
            }
            CommonAbstractions.INSTANCE.onLivingConvert((class_1309)this, (class_1309)entity);
        });
    }

    private Optional<class_1496> recreateHorseFromData(class_1937 level, FallenMount source) {
        class_2487 tag = source.horseData;
        if (!level.field_9236 && tag != null && !tag.method_33133()) {
            return class_1299.method_5892((class_2487)tag, (class_1937)level).map(entity -> {
                class_1496 horse = (class_1496)entity;
                horse.method_5719((class_1297)source);
                source.method_31472();
                level.method_8649((class_1297)horse);
                return horse;
            });
        }
        return Optional.empty();
    }

    private Optional<class_1496> createFreshHorse() {
        class_1299 entityType = this.field_5974.method_43048(6) == 0 ? class_1299.field_6067 : class_1299.field_6139;
        class_1496 abstractHorse = (class_1496)this.method_29243(entityType, false);
        for (int i = 0; i < class_1304.values().length; ++i) {
            class_1304 equipmentSlot = class_1304.values()[i];
            class_1799 itemStack = this.method_6118(equipmentSlot);
            if (itemStack.method_7960()) continue;
            if (class_1890.method_8224((class_1799)itemStack)) {
                abstractHorse.method_32318(equipmentSlot.method_5927() + 300).method_32332(itemStack);
                continue;
            }
            double d = this.method_5929(equipmentSlot);
            if (!(d > 1.0)) continue;
            this.method_5775(itemStack);
        }
        abstractHorse.method_5943((class_5425)this.method_37908(), this.method_37908().method_8404(abstractHorse.method_24515()), class_3730.field_16468, (class_1315)new class_1296.class_4697(0.0f), null);
        abstractHorse.method_6766(true);
        if (this.conversionStarter != null) {
            abstractHorse.method_6732(this.conversionStarter);
        }
        abstractHorse.method_7217(false);
        return Optional.of(abstractHorse);
    }

    public boolean method_5874(class_3218 level, class_1309 entity) {
        boolean flag = super.method_5874(level, entity);
        if ((level.method_8407() == class_1267.field_5802 || level.method_8407() == class_1267.field_5807) && entity instanceof class_1496) {
            class_1496 horse = (class_1496)entity;
            if (CommonAbstractions.INSTANCE.canLivingConvert(entity, (class_1299<? extends class_1309>)((class_1299)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get()), timer -> {})) {
                if (level.method_8407() != class_1267.field_5807 && this.field_5974.method_43056()) {
                    return flag;
                }
                FallenMount fallenMount = (FallenMount)horse.method_29243((class_1299)ModRegistry.FALLEN_MOUNT_ENTITY_TYPE.get(), true);
                fallenMount.method_5943((class_5425)level, level.method_8404(fallenMount.method_24515()), class_3730.field_16468, (class_1315)new class_1296.class_4697(0.0f), null);
                class_2487 compoundtag = new class_2487();
                compoundtag.method_10582("id", FallenMount.getEncodeId((class_1297)horse));
                horse.method_6033(horse.method_6063());
                horse.method_18799(class_243.field_1353);
                horse.method_5647(compoundtag);
                fallenMount.horseData = compoundtag;
                CommonAbstractions.INSTANCE.onLivingConvert(entity, (class_1309)fallenMount);
                if (!this.method_5701()) {
                    level.method_8444(null, 1026, this.method_24515(), 0);
                }
                flag = false;
            }
        }
        return flag;
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        class_1315 spawnGroupData = super.method_5943(level, difficulty, reason, spawnData, dataTag);
        this.method_5964(level.method_8409(), difficulty);
        return spawnGroupData;
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    protected class_3414 method_5994() {
        return class_3417.field_15154;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14543;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15179;
    }

    protected void method_5734(float volume) {
        if (this.method_24828()) {
            super.method_5734(0.3f);
        } else {
            super.method_5734(Math.min(0.1f, volume * 25.0f));
        }
    }

    protected float method_6120() {
        return 0.96f;
    }

    static class MountRestrictSunGoal
    extends class_1384 {
        private final class_1314 mob;

        public MountRestrictSunGoal(class_1314 pathfinderMob) {
            super(pathfinderMob);
            this.mob = pathfinderMob;
        }

        public boolean method_6264() {
            return !this.mob.method_5782() && super.method_6264();
        }
    }

    static class MountFleeSunGoal
    extends class_1344 {
        public MountFleeSunGoal(class_1314 pathfinderMob, double d) {
            super(pathfinderMob, d);
        }

        public boolean method_6264() {
            return !this.field_6419.method_5782() && super.method_6264();
        }
    }
}

