/*
 * Decompiled with CFR 0.152.
 */
package me.drex.magic_particles.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Map;
import java.util.stream.Stream;
import me.drex.magic_particles.particles.particle.AbstractParticle;
import me.drex.magic_particles.particles.particle.BezierParticle;
import me.drex.magic_particles.particles.particle.ImageParticle;
import me.drex.magic_particles.particles.particle.SimpleParticle;
import net.minecraft.class_2960;

public class ParticleCodec
extends MapCodec<AbstractParticle> {
    public static final Codec<AbstractParticle> CODEC = new MapCodec.MapCodecCodec((MapCodec)new ParticleCodec());
    private static final Map<class_2960, MapCodec<? extends AbstractParticle>> CODECS = Map.of(SimpleParticle.LOCATION, SimpleParticle.CODEC, BezierParticle.LOCATION, BezierParticle.CODEC, ImageParticle.LOCATION, ImageParticle.CODEC);

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString("type"), ops.createString("config"));
    }

    public <T> DataResult<AbstractParticle> decode(DynamicOps<T> ops, MapLike<T> input) {
        DataResult value = ops.getStringValue(input.get("type"));
        return value.flatMap(type -> {
            class_2960 id = class_2960.method_12829((String)type);
            MapCodec<? extends AbstractParticle> codec = CODECS.get(id);
            if (codec != null) {
                return codec.decode(ops, input);
            }
            String candidates = String.join((CharSequence)" ", CODECS.keySet().stream().map(class_2960::toString).toList());
            return DataResult.error(() -> "Invalid particle type \"" + type + "\", valid types: " + candidates + "!");
        });
    }

    public <T> RecordBuilder<T> encode(AbstractParticle input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        String type = input.location().method_12836().equals("minecraft") ? input.location().method_12832() : input.location().toString();
        return input.codec().encode((Object)input, ops, prefix.add("type", ops.createString(type)));
    }
}

