/*
 * Decompiled with CFR 0.152.
 */
package me.drex.magic_particles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import eu.pb4.playerdata.api.PlayerDataApi;
import java.util.Map;
import java.util.function.Predicate;
import me.drex.magic_particles.MagicParticlesMod;
import me.drex.magic_particles.particles.MagicParticle;
import me.drex.magic_particles.particles.ParticleManager;
import me.drex.message.api.LocalizedMessage;
import me.drex.message.api.MessageAPI;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class MagicParticlesCommand {
    private static final Predicate<class_2168> ROOT_PREDICATE = Permissions.require((String)"magic-particles.root", (int)2);
    public static final SuggestionProvider<class_2168> SUGGEST_MAGIC_PARTICLES = (context, builder) -> class_2172.method_9265(ParticleManager.particles().keySet(), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode rootNode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"magic-particles").requires(ROOT_PREDICATE)).executes(MagicParticlesCommand::sendList)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(Permissions.require((String)"magic-particles.particle", (int)2))).then(class_2170.method_9244((String)"particle", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MAGIC_PARTICLES).executes(MagicParticlesCommand::setParticle)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"disable").requires(Permissions.require((String)"magic-particles.disable", (int)2))).executes(MagicParticlesCommand::disable))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"magic-particles.reload", (int)2))).executes(MagicParticlesCommand::reload)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"mp").executes(MagicParticlesCommand::sendList)).requires(ROOT_PREDICATE)).redirect((CommandNode)rootNode));
    }

    private static int sendList(CommandContext<class_2168> ctx) {
        Map<String, MagicParticle> particles = ParticleManager.particles();
        class_5250 list = class_2564.method_36332(particles.entrySet(), (class_2561)LocalizedMessage.localized((String)"text.magic_particles.overview.list.separator"), particleEntry -> LocalizedMessage.localized((String)"text.magic_particles.overview.list.element", Map.of("id", class_2561.method_43470((String)((String)particleEntry.getKey())), "name", class_2561.method_43470((String)((MagicParticle)particleEntry.getValue()).name()))));
        ((class_2168)ctx.getSource()).method_9226(() -> LocalizedMessage.localized((String)"text.magic_particles.overview", Map.of("count", class_2561.method_43470((String)String.valueOf(particles.size())), "list", list)), false);
        return particles.size();
    }

    private static int reload(CommandContext<class_2168> ctx) {
        MessageAPI.reload();
        if (ParticleManager.load()) {
            Map<String, MagicParticle> particles = ParticleManager.particles();
            ((class_2168)ctx.getSource()).method_9226(() -> LocalizedMessage.localized((String)"text.magic_particles.reload"), false);
            return particles.size();
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)LocalizedMessage.localized((String)"text.magic_particles.error"));
        return 1;
    }

    private static int setParticle(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String particle = StringArgumentType.getString(ctx, (String)"particle");
        if (!ParticleManager.particles().containsKey(particle)) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)LocalizedMessage.localized((String)"text.magic_particles.unknown"));
            return 0;
        }
        PlayerDataApi.setGlobalDataFor((class_3222)((class_2168)ctx.getSource()).method_9207(), (class_2960)MagicParticlesMod.PARTICLE, (class_2520)class_2519.method_23256((String)particle));
        String name = ParticleManager.particles().get(particle).name();
        ((class_2168)ctx.getSource()).method_9226(() -> LocalizedMessage.localized((String)"text.magic_particles.set", Map.of("id", class_2561.method_43470((String)particle), "name", class_2561.method_43470((String)name))), false);
        return 1;
    }

    private static int disable(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        PlayerDataApi.setGlobalDataFor((class_3222)((class_2168)ctx.getSource()).method_9207(), (class_2960)MagicParticlesMod.PARTICLE, null);
        ((class_2168)ctx.getSource()).method_9226(() -> LocalizedMessage.localized((String)"text.magic_particles.unset"), false);
        return 1;
    }
}

