/*
 * Decompiled with CFR 0.152.
 */
package me.drex.magic_particles.particles;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.playerdata.api.PlayerDataApi;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import me.drex.magic_particles.MagicParticlesMod;
import me.drex.magic_particles.particles.MagicParticle;
import me.drex.vanish.api.VanishAPI;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1297;
import net.minecraft.class_2519;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4614;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.filefilter.SuffixFileFilter;

public class ParticleManager {
    public static final Path PARTICLES_FOLDER = FabricLoader.getInstance().getConfigDir().resolve("magic-particles");
    private static final String FILE_SUFFIX = ".json";
    private static final boolean VANISH = FabricLoader.getInstance().isModLoaded("melius-vanish");
    private static final Map<String, MagicParticle> particles = new HashMap<String, MagicParticle>();

    public static void init() {
        ParticleManager.load();
        ServerTickEvents.START_SERVER_TICK.register(ParticleManager::tick);
    }

    public static boolean load() {
        File[] files;
        MagicParticlesMod.LOGGER.info("Loading magic particles...");
        File folder = PARTICLES_FOLDER.toFile();
        if (folder.mkdirs()) {
            Optional optionalPath = ((ModContainer)FabricLoader.getInstance().getModContainer("magic-particles").orElseThrow()).findPath("magic-particles");
            if (optionalPath.isPresent()) {
                Path sourceFolder = (Path)optionalPath.get();
                try (Stream<Path> pathStream = Files.walk(sourceFolder, new FileVisitOption[0]);){
                    pathStream.forEach(source -> {
                        try {
                            Files.copy(source, PARTICLES_FOLDER.resolve(sourceFolder.relativize((Path)source).toString()), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            MagicParticlesMod.LOGGER.error("Failed copy copy default magic particle data \"{}\"", source, (Object)e);
                        }
                    });
                }
                catch (IOException e) {
                    MagicParticlesMod.LOGGER.error("Failed to load default magic particles", (Throwable)e);
                }
            } else {
                MagicParticlesMod.LOGGER.warn("No default magic particles found");
            }
        }
        if ((files = folder.listFiles((FileFilter)new SuffixFileFilter(FILE_SUFFIX))) == null) {
            return false;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (File file : files) {
            if (!file.isFile()) continue;
            String id = file.getName();
            id = id.substring(0, id.length() - FILE_SUFFIX.length());
            try (JsonReader jsonReader = new JsonReader((Reader)Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8));){
                jsonReader.setLenient(false);
                JsonElement jsonElement = JsonParser.parseReader((JsonReader)jsonReader);
                DataResult dataResult = MagicParticle.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
                String finalId = id;
                builder.put((Object)id, (Object)((MagicParticle)dataResult.resultOrPartial(s -> {
                    MagicParticlesMod.LOGGER.error("Failed to load magic particle \"{}\"", (Object)finalId);
                    MagicParticlesMod.LOGGER.error(s);
                }).orElseThrow()));
            }
            catch (Exception e) {
                MagicParticlesMod.LOGGER.error("Failed to load magic particle \"{}\"", (Object)id, (Object)e);
                return false;
            }
        }
        particles.clear();
        particles.putAll((Map<String, MagicParticle>)builder.build());
        return true;
    }

    private static void tick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            String particle;
            MagicParticle magicParticle;
            class_2519 tag;
            if (!ParticleManager.shouldShow(player) || (tag = (class_2519)PlayerDataApi.getGlobalDataFor((class_3222)player, (class_2960)MagicParticlesMod.PARTICLE, (class_4614)class_2519.field_21045)) == null || (magicParticle = particles.get(particle = tag.method_10714())) == null) continue;
            magicParticle.display(player.method_5671());
        }
    }

    private static boolean shouldShow(class_3222 player) {
        return (!VANISH || !VanishAPI.isVanished((class_1297)player)) && !player.method_7325();
    }

    public static Map<String, MagicParticle> particles() {
        return particles;
    }
}

