/*
 * Decompiled with CFR 0.152.
 */
package me.drex.magic_particles.particles.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.drex.magic_particles.codec.CustomCodecs;
import me.drex.magic_particles.particles.particle.AbstractParticle;
import net.minecraft.class_2168;
import net.minecraft.class_2183;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8113;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class BezierParticle
extends AbstractParticle {
    public static final class_2960 LOCATION = new class_2960("bezier");
    public static final MapCodec<BezierParticle> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)Codec.list((Codec)class_243.field_38277)).fieldOf("curves").forGetter(BezierParticle::curves), (App)Codec.INT.fieldOf("steps").forGetter(BezierParticle::steps), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(0.0f)).forGetter(BezierParticle::speed), (App)class_2398.field_25125.fieldOf("particle_type").forGetter(BezierParticle::particleOptions), (App)CustomCodecs.ANCHOR.optionalFieldOf("anchor", (Object)class_2183.class_2184.field_9853).forGetter(AbstractParticle::anchor), (App)class_243.field_38277.optionalFieldOf("origin", (Object)class_243.field_1353).forGetter(AbstractParticle::origin), (App)class_8113.class_8114.field_42410.optionalFieldOf("billboard", (Object)class_8113.class_8114.field_42406).forGetter(AbstractParticle::billboard)).apply((Applicative)instance, BezierParticle::new));
    private final List<List<class_243>> curves;
    private final int steps;
    private final float speed;
    private final class_2394 particleOptions;

    public BezierParticle(List<List<class_243>> curves, int steps, float speed, class_2394 particleOptions, class_2183.class_2184 anchor, class_243 origin, class_8113.class_8114 billboard) {
        super(LOCATION, CODEC, anchor, origin, billboard);
        this.curves = curves;
        this.steps = steps;
        this.speed = speed;
        this.particleOptions = particleOptions;
    }

    @Override
    public void sendParticles(class_2168 source, class_3222 player) {
        double step = 1.0 / (double)this.steps;
        for (List<class_243> curve : this.curves) {
            for (double t = 0.0; t < 1.0; t += step) {
                Vector3f vector3f = this.calculateBezierCurve(curve, t);
                this.sendParticles(source, player, this.particleOptions, false, new class_243(vector3f), 1, class_243.field_1353, this.speed);
            }
        }
    }

    private Vector3f calculateBezierCurve(List<class_243> points, double t) {
        Vector3f sum = new Vector3f();
        int n = points.size() - 1;
        for (int i = 0; i <= n; ++i) {
            Vector3f summand = new Vector3f((Vector3fc)points.get(i).method_46409());
            double scalar = (double)BezierParticle.binomialCoefficient(n, i) * Math.pow(1.0 - t, n - i) * Math.pow(t, i);
            sum.add((Vector3fc)summand.mul((float)scalar));
        }
        return sum;
    }

    private static int binomialCoefficient(int n, int k) {
        int[][] dp = new int[n + 1][k + 1];
        for (int i = 0; i <= n; ++i) {
            for (int j = 0; j <= Math.min(i, k); ++j) {
                dp[i][j] = j == 0 || j == i ? 1 : dp[i - 1][j - 1] + dp[i - 1][j];
            }
        }
        return dp[n][k];
    }

    public List<List<class_243>> curves() {
        return this.curves;
    }

    public float speed() {
        return this.speed;
    }

    public class_2394 particleOptions() {
        return this.particleOptions;
    }

    public int steps() {
        return this.steps;
    }
}

