/*
 * Decompiled with CFR 0.152.
 */
package me.drex.magic_particles.particles.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import me.drex.magic_particles.codec.CustomCodecs;
import me.drex.magic_particles.particles.ParticleManager;
import me.drex.magic_particles.particles.particle.AbstractParticle;
import net.minecraft.class_2168;
import net.minecraft.class_2183;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_8113;
import org.joml.Vector3f;

public class ImageParticle
extends AbstractParticle {
    public static final class_2960 LOCATION = new class_2960("image");
    public static final MapCodec<ImageParticle> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("image").forGetter(ImageParticle::image), (App)Codec.FLOAT.fieldOf("size_x").forGetter(ImageParticle::sizeX), (App)Codec.FLOAT.fieldOf("size_y").forGetter(ImageParticle::sizeY), (App)Codec.FLOAT.fieldOf("pixel_size").forGetter(ImageParticle::sizeY), (App)class_243.field_38277.optionalFieldOf("pos", (Object)class_243.field_1353).forGetter(ImageParticle::pos), (App)CustomCodecs.ANCHOR.optionalFieldOf("anchor", (Object)class_2183.class_2184.field_9853).forGetter(AbstractParticle::anchor), (App)class_243.field_38277.optionalFieldOf("origin", (Object)class_243.field_1353).forGetter(AbstractParticle::origin), (App)class_8113.class_8114.field_42410.optionalFieldOf("billboard", (Object)class_8113.class_8114.field_42406).forGetter(AbstractParticle::billboard)).apply((Applicative)instance, ImageParticle::new));
    private final String image;
    private final float sizeX;
    private final float sizeY;
    private final float pixelSize;
    private final class_243 pos;
    private final BufferedImage bufferedImage;
    private final class_5819 random;

    protected ImageParticle(String image, float sizeX, float sizeY, float pixelSize, class_243 pos, class_2183.class_2184 anchor, class_243 origin, class_8113.class_8114 billboard) {
        super(LOCATION, CODEC, anchor, origin, billboard);
        this.image = image;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.pixelSize = pixelSize;
        this.pos = pos;
        try {
            this.bufferedImage = ImageIO.read(ParticleManager.PARTICLES_FOLDER.resolve("images").resolve(image).toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.random = class_5819.method_43047();
    }

    @Override
    public void sendParticles(class_2168 source, class_3222 player) {
        double stepX = this.sizeX / (float)this.bufferedImage.getWidth();
        double stepY = this.sizeY / (float)this.bufferedImage.getHeight();
        for (int x = 0; x < this.bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < this.bufferedImage.getHeight(); ++y) {
                int color = this.bufferedImage.getRGB(x, y);
                int red = (color & 0xFF0000) >> 16;
                int green = (color & 0xFF00) >> 8;
                int blue = color & 0xFF;
                int alpha = (color & 0xFF000000) >>> 24;
                class_2390 particleOptions = new class_2390(new Vector3f((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f), this.pixelSize);
                double reversedX = this.bufferedImage.getWidth() - 1 - x;
                double centeredX = reversedX - (double)(this.bufferedImage.getWidth() - 1) / 2.0;
                double reversedY = this.bufferedImage.getHeight() - 1 - y;
                double centeredY = reversedY - (double)(this.bufferedImage.getHeight() - 1) / 2.0;
                class_243 vec3 = new class_243(stepX * centeredX, stepY * centeredY, 0.0).method_1019(this.pos);
                if (alpha < this.random.method_39332(1, 255)) continue;
                this.sendParticles(source, player, (class_2394)particleOptions, false, vec3, 1, class_243.field_1353, 0.0f);
            }
        }
    }

    public String image() {
        return this.image;
    }

    public class_243 pos() {
        return this.pos;
    }

    public float sizeX() {
        return this.sizeX;
    }

    public float sizeY() {
        return this.sizeY;
    }
}

