/*
 * Decompiled with CFR 0.152.
 */
package me.drex.meliuscommands.config;

import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.drex.meliuscommands.MeliusCommands;
import me.drex.meliuscommands.config.command.LiteralNode;
import me.drex.meliuscommands.config.modifier.matcher.CommandMatcher;
import me.drex.meliuscommands.config.modifier.matcher.CommandMatchers;
import me.drex.meliuscommands.util.CodecUtil;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Path MAIN_FOLDER = FabricLoader.getInstance().getConfigDir().resolve("melius-commands");
    public static final List<CommandMatcher> COMMAND_EXECUTION_MATCHERS = new LinkedList<CommandMatcher>();
    public static final Map<Path, List<LiteralNode>> CUSTOM_COMMANDS = new HashMap<Path, List<LiteralNode>>();
    public static final Codec<List<LiteralNode>> COMMANDS_CODEC = CodecUtil.withAlternative(Codec.list(LiteralNode.CODEC), LiteralNode.CODEC, List::of);
    public static final Codec<List<CommandMatcher>> MATCHERS_CODEC = CodecUtil.withAlternative(Codec.list(CommandMatchers.CODEC), CommandMatchers.CODEC, List::of);

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, context, selection) -> ConfigManager.load());
    }

    public static void load() {
        Path commandsPath = MAIN_FOLDER.resolve("commands");
        Path modifiersPath = MAIN_FOLDER.resolve("modifiers");
        try {
            Files.createDirectories(commandsPath, new FileAttribute[0]);
            Files.createDirectories(modifiersPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            MeliusCommands.LOGGER.error("Failed to create default folders", (Throwable)e);
        }
        CUSTOM_COMMANDS.clear();
        try (Stream<Path> commandPaths = Files.walk(commandsPath, new FileVisitOption[0]);){
            commandPaths.forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(false);
                    JsonElement jsonElement = Streams.parse((JsonReader)jsonReader);
                    List literalNodes = (List)COMMANDS_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, s -> {});
                    CUSTOM_COMMANDS.put((Path)path, literalNodes);
                }
                catch (IOException e) {
                    MeliusCommands.LOGGER.error("Couldn't access custom commands in {}", (Object)path.getFileName(), (Object)e);
                }
                catch (RuntimeException e) {
                    MeliusCommands.LOGGER.error("Couldn't to parse custom commands in {}", (Object)path.getFileName(), (Object)e);
                }
            });
        }
        catch (IOException e) {
            MeliusCommands.LOGGER.error("Failed to load custom commands", (Throwable)e);
        }
        MeliusCommands.LOGGER.info("Loaded {} custom command", (Object)CUSTOM_COMMANDS.size());
        COMMAND_EXECUTION_MATCHERS.clear();
        try (Stream<Path> modifierPaths = Files.walk(modifiersPath, new FileVisitOption[0]);){
            modifierPaths.forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(false);
                    JsonElement jsonElement = Streams.parse((JsonReader)jsonReader);
                    List matchers = (List)MATCHERS_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(false, s -> {});
                    COMMAND_EXECUTION_MATCHERS.addAll(matchers);
                }
                catch (IOException e) {
                    MeliusCommands.LOGGER.error("Couldn't access command modifiers in {}", (Object)path.getFileName(), (Object)e);
                }
                catch (RuntimeException e) {
                    MeliusCommands.LOGGER.error("Couldn't to parse command modifiers in {}", (Object)path.getFileName(), (Object)e);
                }
            });
        }
        catch (IOException e) {
            MeliusCommands.LOGGER.error("Failed to load command modifiers", (Throwable)e);
        }
        MeliusCommands.LOGGER.info("Loaded {} command modifiers", (Object)COMMAND_EXECUTION_MATCHERS.size());
    }
}

