/*
 * Decompiled with CFR 0.152.
 */
package me.drex.meliuscommands.config.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.predicate.api.MinecraftPredicate;
import eu.pb4.predicate.api.PredicateContext;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.drex.meliuscommands.MeliusCommands;
import me.drex.meliuscommands.config.command.ArgumentNode;
import me.drex.meliuscommands.config.command.LiteralNode;
import me.drex.meliuscommands.config.common.CommandAction;
import net.minecraft.class_2168;
import net.minecraft.class_7157;

public abstract class CommandNode<T extends ArgumentBuilder<class_2168, T>> {
    public final String id;
    public final List<LiteralNode> literals;
    public final List<ArgumentNode<?>> arguments;
    public final Optional<MinecraftPredicate> requires;
    public final List<CommandAction> executions;
    public final Optional<String> redirect;

    protected CommandNode(String id, List<LiteralNode> literals, List<ArgumentNode<?>> arguments, Optional<MinecraftPredicate> requires, List<CommandAction> executions, Optional<String> redirect) {
        this.id = id;
        this.literals = literals;
        this.arguments = arguments;
        this.requires = requires;
        this.executions = executions;
        this.redirect = redirect;
    }

    public T build(CommandDispatcher<class_2168> dispatcher, class_7157 buildContext) {
        T builder = this.getArgumentBuilder(buildContext);
        this.redirect.ifPresent(redirectPath -> {
            com.mojang.brigadier.tree.CommandNode dispatcherNode = dispatcher.findNode(Arrays.asList(redirectPath.split("\\.")));
            if (dispatcherNode == null) {
                MeliusCommands.LOGGER.error("Failed to find node with path '{}' for redirecting", redirectPath);
            } else {
                builder.requires(dispatcherNode.getRequirement()).forward(dispatcherNode.getRedirect(), dispatcherNode.getRedirectModifier(), dispatcherNode.isFork()).executes(dispatcherNode.getCommand());
                for (com.mojang.brigadier.tree.CommandNode child : dispatcherNode.getChildren()) {
                    builder.then(child);
                }
            }
        });
        this.requires.ifPresent(minecraftPredicate -> builder.requires(source -> minecraftPredicate.test(PredicateContext.of((class_2168)source)).success()));
        if (!this.executions.isEmpty()) {
            builder.executes(executionContext -> {
                int result = 0;
                for (CommandAction action : this.executions) {
                    result += action.execute((CommandContext<class_2168>)executionContext);
                }
                return result;
            });
        }
        for (LiteralNode literalNode : this.literals) {
            builder.then(literalNode.build(dispatcher, buildContext));
        }
        for (ArgumentNode argumentNode : this.arguments) {
            builder.then(argumentNode.build(dispatcher, buildContext));
        }
        return builder;
    }

    abstract T getArgumentBuilder(class_7157 var1);
}

