/*
 * Decompiled with CFR 0.152.
 */
package me.drex.meliuscommands.config.common;

import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import me.drex.meliuscommands.mixin.CommandContextAccessor;
import me.drex.meliuscommands.util.CodecUtil;
import net.minecraft.class_2165;
import net.minecraft.class_2168;

public record CommandAction(String command, boolean console, boolean silent, Optional<Integer> permissionLevel) {
    private static final BinaryOperator<ResultConsumer<class_2168>> CALLBACK_CHAINER = (resultConsumer, resultConsumer2) -> (commandContext, bl, i) -> {
        resultConsumer.onCommandComplete(commandContext, bl, i);
        resultConsumer2.onCommandComplete(commandContext, bl, i);
    };
    public static final Codec<CommandAction> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(CommandAction::command), (App)Codec.BOOL.optionalFieldOf("as_console", (Object)true).forGetter(CommandAction::console), (App)Codec.BOOL.optionalFieldOf("silent", (Object)true).forGetter(CommandAction::silent), (App)Codec.INT.optionalFieldOf("op_level").forGetter(CommandAction::permissionLevel)).apply((Applicative)instance, CommandAction::new));
    public static final Codec<CommandAction> CODEC = CodecUtil.withAlternative(FULL_CODEC, Codec.STRING, CommandAction::new);

    public CommandAction(String command) {
        this(command, true, true, Optional.of(4));
    }

    public int execute(CommandContext<class_2168> ctx) {
        Map arguments = ((CommandContextAccessor)ctx).getArguments();
        String command = this.command;
        for (Map.Entry entry : arguments.entrySet()) {
            String value = entry.getValue().getRange().get(ctx.getInput() + " ");
            command = command.replace("${" + entry.getKey() + "}", value);
        }
        PlaceholderContext placeholderContext = PlaceholderContext.of((class_2168)((class_2168)ctx.getSource()));
        String parsedCommand = Placeholders.parseText((TextNode)TextNode.of((String)command), (PlaceholderContext)placeholderContext).getString();
        AtomicInteger result = new AtomicInteger();
        class_2168 modifiedSource = ((class_2168)ctx.getSource()).method_9209((context, success, i) -> result.set(i), CALLBACK_CHAINER);
        if (this.console) {
            modifiedSource = modifiedSource.method_36321((class_2165)((class_2168)ctx.getSource()).method_9211());
        }
        if (this.silent) {
            modifiedSource = modifiedSource.method_9217();
        }
        if (this.permissionLevel.isPresent()) {
            modifiedSource = modifiedSource.method_9206(this.permissionLevel.get().intValue());
        }
        ((class_2168)ctx.getSource()).method_9211().method_3734().method_44252(modifiedSource, parsedCommand);
        return result.get();
    }
}

