/*
 * Decompiled with CFR 0.152.
 */
package me.drex.meliuscommands.parser;

import com.mojang.brigadier.arguments.ArgumentType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import me.drex.meliuscommands.mixin.ArgumentTypesAccessor;
import me.drex.meliuscommands.parser.ArgumentTypeParser;
import net.minecraft.class_2314;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class MinecraftArgumentTypeParser
implements ArgumentTypeParser {
    public static final MinecraftArgumentTypeParser INSTANCE = new MinecraftArgumentTypeParser();
    private static final Map<class_2960, ArgumentParserFunction> ARGUMENT_TYPE_PARSERS = Map.of(new class_2960("entity"), MinecraftArgumentTypeParser::parseEntityArgumentType, new class_2960("resource"), MinecraftArgumentTypeParser::parseResourceArgumentType, new class_2960("resource_key"), MinecraftArgumentTypeParser::parseResourceKeyArgumentType, new class_2960("resource_or_tag"), MinecraftArgumentTypeParser::parseResourceOrTagArgumentType, new class_2960("resource_or_tag_key"), MinecraftArgumentTypeParser::parseResourceOrTagKeyArgumentType, new class_2960("score_holder"), MinecraftArgumentTypeParser::parseScoreHolderArgumentType, new class_2960("time"), MinecraftArgumentTypeParser::parseTimeArgumentType, new class_2960("vec2"), MinecraftArgumentTypeParser::parseVec2ArgumentType, new class_2960("vec3"), MinecraftArgumentTypeParser::parseVec3ArgumentType);

    private MinecraftArgumentTypeParser() {
    }

    @Override
    public boolean canParse(class_2960 resourceLocation) {
        return class_7923.field_41192.method_10223(resourceLocation) != null;
    }

    @Override
    public ArgumentType<?> parse(class_7157 context, class_2960 resourceLocation, String args) {
        Object[] arguments;
        Constructor<ArgumentType<?>> constructor;
        Class<ArgumentType<?>> clazz = MinecraftArgumentTypeParser.getClassByKey(resourceLocation);
        ArgumentParserFunction parserFunction = ARGUMENT_TYPE_PARSERS.get(resourceLocation);
        if (parserFunction != null) {
            return parserFunction.parse(clazz, context, args);
        }
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            arguments = new Object[]{};
        }
        catch (NoSuchMethodException noDefaultConstructor) {
            try {
                constructor = clazz.getDeclaredConstructor(class_7157.class);
            }
            catch (NoSuchMethodException noCommandBuildContextConstructor) {
                try {
                    constructor = clazz.getDeclaredConstructor(class_7225.class_7874.class);
                }
                catch (NoSuchMethodException noHolderLookupConstructor) {
                    throw new RuntimeException("Failed to find constructor for argument type " + String.valueOf(resourceLocation) + ".", noHolderLookupConstructor);
                }
            }
            arguments = new Object[]{context};
        }
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Failed to construct argument type " + String.valueOf(resourceLocation) + ".", e);
        }
    }

    private static ArgumentType<?> parseEntityArgumentType(Class<? extends ArgumentType<?>> clazz, class_7157 context, String args) {
        boolean single;
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(clazz, new Class[]{Boolean.TYPE, Boolean.TYPE}, single, switch (args) {
            case "entity" -> {
                single = true;
                yield false;
            }
            case "entities" -> {
                single = false;
                yield false;
            }
            case "player" -> {
                single = true;
                yield true;
            }
            case "players" -> {
                single = false;
                yield true;
            }
            default -> throw new IllegalArgumentException("Unknown entity selection type: \"" + args + "\". Use entity, entities, player or players.");
        });
    }

    private static ArgumentType<?> parseResourceArgumentType(Class<? extends ArgumentType<?>> clazz, class_7157 context, String args) {
        class_2960 resourceLocation = new class_2960(args);
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(clazz, new Class[]{class_7157.class, class_5321.class}, context, class_5321.method_29180((class_2960)resourceLocation));
    }

    private static ArgumentType<?> parseResourceKeyArgumentType(Class<? extends ArgumentType<?>> clazz, class_7157 context, String args) {
        class_2960 resourceLocation = new class_2960(args);
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(clazz, new Class[]{class_5321.class}, class_5321.method_29180((class_2960)resourceLocation));
    }

    private static ArgumentType<?> parseResourceOrTagArgumentType(Class<? extends ArgumentType<?>> clazz, class_7157 context, String args) {
        class_2960 resourceLocation = new class_2960(args);
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(clazz, new Class[]{class_7157.class, class_5321.class}, context, class_5321.method_29180((class_2960)resourceLocation));
    }

    private static ArgumentType<?> parseResourceOrTagKeyArgumentType(Class<? extends ArgumentType<?>> clazz, class_7157 context, String args) {
        class_2960 resourceLocation = new class_2960(args);
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(clazz, new Class[]{class_5321.class}, class_5321.method_29180((class_2960)resourceLocation));
    }

    private static ArgumentType<?> parseScoreHolderArgumentType(Class<? extends ArgumentType<?>> clazz, class_7157 context, String args) {
        boolean multiple = Boolean.parseBoolean(args);
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(clazz, new Class[]{Boolean.TYPE}, multiple);
    }

    private static ArgumentType<?> parseTimeArgumentType(Class<? extends ArgumentType<?>> clazz, class_7157 context, String args) {
        int minimum = Integer.parseInt(args);
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(clazz, new Class[]{Integer.TYPE}, minimum);
    }

    private static ArgumentType<?> parseVec2ArgumentType(Class<? extends ArgumentType<?>> clazz, class_7157 context, String args) {
        boolean centerCorrect = Boolean.parseBoolean(args);
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(clazz, new Class[]{Boolean.TYPE}, centerCorrect);
    }

    private static ArgumentType<?> parseVec3ArgumentType(Class<? extends ArgumentType<?>> clazz, class_7157 context, String args) {
        boolean centerCorrect = Boolean.parseBoolean(args);
        return MinecraftArgumentTypeParser.constructMinecraftArgumentType(clazz, new Class[]{Boolean.TYPE}, centerCorrect);
    }

    private static ArgumentType<?> constructMinecraftArgumentType(Class<? extends ArgumentType<?>> clazz, Class<?>[] argTypes, Object ... args) {
        try {
            Constructor<ArgumentType<?>> constructor = clazz.getDeclaredConstructor(argTypes);
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<? extends ArgumentType<?>> getClassByKey(class_2960 resourceLocation) throws IllegalArgumentException {
        class_2314 entry = (class_2314)class_7923.field_41192.method_10223(resourceLocation);
        if (entry == null) {
            throw new IllegalArgumentException(resourceLocation.toString());
        }
        Map<Class<?>, class_2314<?, ?>> map = ArgumentTypesAccessor.getBY_CLASS();
        for (Map.Entry<Class<?>, class_2314<?, ?>> mapEntry : map.entrySet()) {
            if (mapEntry.getValue() != entry) continue;
            return mapEntry.getKey();
        }
        throw new IllegalArgumentException(resourceLocation.toString());
    }

    @FunctionalInterface
    static interface ArgumentParserFunction {
        public ArgumentType<?> parse(Class<? extends ArgumentType<?>> var1, class_7157 var2, String var3);
    }
}

