/*
 * Decompiled with CFR 0.152.
 */
package me.drex.meliuscommands.util;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Function;
import java.util.function.Supplier;

public interface CodecUtil {
    public static <T, U> Codec<T> withAlternative(Codec<T> primary, Codec<U> alternative, Function<U, T> converter) {
        return Codec.either(primary, alternative).xmap(either -> either.map(v -> v, converter), Either::left);
    }

    public static <A> Codec<A> recursive(String name, Function<Codec<A>, Codec<A>> wrapped) {
        return new RecursiveCodec(name, wrapped);
    }

    public static <A> Codec<A> lazyInitialized(Supplier<Codec<A>> delegate) {
        return new RecursiveCodec(delegate.toString(), self -> (Codec)delegate.get());
    }

    public static class RecursiveCodec<T>
    implements Codec<T> {
        private final String name;
        private final Supplier<Codec<T>> wrapped;

        private RecursiveCodec(String name, Function<Codec<T>, Codec<T>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (Codec)wrapped.apply(this));
        }

        public <S> DataResult<Pair<T, S>> decode(DynamicOps<S> ops, S input) {
            return this.wrapped.get().decode(ops, input);
        }

        public <S> DataResult<S> encode(T input, DynamicOps<S> ops, S prefix) {
            return this.wrapped.get().encode(input, ops, prefix);
        }

        public String toString() {
            return "RecursiveCodec[" + this.name + "]";
        }
    }
}

