/*
 * Decompiled with CFR 0.152.
 */
package fuzs.moblassos.world.item;

import fuzs.moblassos.MobLassos;
import fuzs.moblassos.capability.VillagerContractCapability;
import fuzs.moblassos.config.ServerConfig;
import fuzs.moblassos.init.ModRegistry;
import fuzs.moblassos.util.LassoMobHelper;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1421;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1542;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3988;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class LassoItem
extends class_1792 {
    public static final String TAG_STORED_ENTITY = "StoredEntity";
    public static final String TAG_ENTITY_PICK_UP_TIME = "EntityPickUpTime";
    public static final String TAG_ENTITY_RELEASE_TIME = "EntityReleaseTime";
    private static final int BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);
    private final Type type;

    public LassoItem(class_1792.class_1793 properties, Type type) {
        super(properties);
        this.type = type;
    }

    public static EventResultHolder<class_1269> onEntityInteract(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity) {
        class_1799 stack = player.method_5998(hand);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof LassoItem) {
            LassoItem item = (LassoItem)class_17922;
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                if (entity.method_5805()) {
                    if (!(stack.method_7985() && stack.method_7969().method_10573(TAG_ENTITY_RELEASE_TIME, 4) || item.hasStoredEntity(stack) || !item.type.canPlayerPickUp(player, mob) || player.method_37908().field_9236)) {
                        entity.method_43077((class_3414)ModRegistry.LASSO_PICK_UP_SOUND_EVENT.get());
                        if (entity.method_16914()) {
                            stack.method_7977(entity.method_5797());
                        }
                        class_2487 tag = LassoMobHelper.saveEntity(entity);
                        entity.method_31472();
                        stack.method_7959(TAG_STORED_ENTITY, (class_2520)tag);
                        if (item.type.hasMaxHoldingTime()) {
                            stack.method_7969().method_10544(TAG_ENTITY_PICK_UP_TIME, level.method_8510());
                        }
                    }
                    return EventResultHolder.interrupt((Object)class_1269.method_29236((boolean)player.method_37908().field_9236));
                }
            }
        }
        return EventResultHolder.pass();
    }

    public int getColor(class_1799 stack, int tintIndex) {
        if (tintIndex == 0) {
            return -1;
        }
        class_1826 spawnEggItem = class_1826.method_8019(this.getStoredEntityType(stack));
        if (spawnEggItem == null) {
            return -1;
        }
        return spawnEggItem.method_8016(tintIndex - 1);
    }

    public boolean hasStoredEntity(class_1799 stack) {
        return stack.method_7985() && stack.method_7969().method_10545(TAG_STORED_ENTITY);
    }

    @Nullable
    public class_1299<?> getStoredEntityType(class_1799 stack) {
        if (!this.hasStoredEntity(stack)) {
            return null;
        }
        return class_1299.method_17684((class_2487)stack.method_7941(TAG_STORED_ENTITY)).orElse(null);
    }

    public class_1269 method_7884(class_1838 context) {
        if (!this.hasStoredEntity(context.method_8041())) {
            return class_1269.field_5811;
        }
        class_1937 level = context.method_8045();
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_1799 itemStack = context.method_8041();
        class_2338 clickedPos = context.method_8037();
        class_2350 direction = context.method_8038();
        class_2680 blockState = level.method_8320(clickedPos);
        class_2338 releasePos = blockState.method_26220((class_1922)level, clickedPos).method_1110() ? clickedPos : clickedPos.method_10093(direction);
        this.releaseContents((class_1297)context.method_8036(), level, itemStack, clickedPos, releasePos);
        this.tryConvertPickUpTime(level, itemStack);
        return class_1269.field_21466;
    }

    private void releaseContents(class_1297 entity, class_1937 level, class_1799 itemStack, class_2338 clickedPos, class_2338 releasePos) {
        class_2487 tag = itemStack.method_7941(TAG_STORED_ENTITY);
        if (this.releaseContentAt(tag, level, releasePos, itemStack)) {
            level.method_33596(entity, class_5712.field_28738, clickedPos);
        }
        itemStack.method_7983(TAG_STORED_ENTITY);
        itemStack.method_7925();
        this.tryClearTag(itemStack);
    }

    private void tryConvertPickUpTime(class_1937 level, class_1799 itemStack) {
        if (itemStack.method_7985() && itemStack.method_7969().method_10573(TAG_ENTITY_PICK_UP_TIME, 4)) {
            long pickUpTime = itemStack.method_7969().method_10537(TAG_ENTITY_PICK_UP_TIME);
            itemStack.method_7969().method_10551(TAG_ENTITY_PICK_UP_TIME);
            long currentHoldingTime = level.method_8510() - pickUpTime;
            itemStack.method_7969().method_10544(TAG_ENTITY_RELEASE_TIME, level.method_8510() + Math.min(0L, currentHoldingTime - (long)this.getMaxHoldingTime(itemStack)) / 5L);
            this.tryClearTag(itemStack);
        }
    }

    private boolean releaseContentAt(class_2487 tag, class_1937 level, class_2338 pos, class_1799 stack) {
        if (!level.field_9236 && !tag.method_33133()) {
            LassoMobHelper.removeTagKeys((class_3218)level, tag);
            return class_1299.method_5892((class_2487)tag, (class_1937)level).map(entity -> {
                LassoMobHelper.moveEntityTo(entity, level, pos, true);
                entity.method_18799(class_243.field_1353);
                level.method_8649(entity);
                if (stack.method_7938() && entity instanceof class_1309) {
                    entity.method_5665(stack.method_7964());
                }
                entity.method_43077((class_3414)ModRegistry.LASSO_RELEASE_SOUND_EVENT.get());
                return entity;
            }).isPresent();
        }
        return false;
    }

    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        int hostileDamageRate;
        if (this.type == Type.HOSTILE && this.hasStoredEntity(stack) && (hostileDamageRate = ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).hostileDamageRate) != -1 && level.method_8510() % ((long)hostileDamageRate * 20L) == 0L) {
            entity.method_5643(level.method_48963().method_48831(), 1.0f);
        }
        if (this.type.hasMaxHoldingTime() && stack.method_7985()) {
            int maxHoldingTime;
            long currentHoldingTime;
            if (stack.method_7969().method_10573(TAG_ENTITY_PICK_UP_TIME, 4) && (currentHoldingTime = this.getCurrentHoldingTime(level, stack, TAG_ENTITY_PICK_UP_TIME, maxHoldingTime = this.getMaxHoldingTime(stack))) >= (long)maxHoldingTime) {
                this.releaseContents(entity, level, stack, entity.method_24515(), entity.method_24515());
                this.tryConvertPickUpTime(level, stack);
            }
            if (stack.method_7969().method_10573(TAG_ENTITY_RELEASE_TIME, 4) && (currentHoldingTime = this.getCurrentHoldingTime(level, stack, TAG_ENTITY_RELEASE_TIME, maxHoldingTime = this.getMaxHoldingTime(stack) / 5)) >= (long)maxHoldingTime) {
                stack.method_7969().method_10551(TAG_ENTITY_RELEASE_TIME);
                this.tryClearTag(stack);
            }
        }
    }

    private void tryClearTag(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_33133()) {
            stack.method_7980(null);
        }
    }

    public boolean method_31567(class_1799 stack) {
        return this.type.hasMaxHoldingTime() && stack.method_7985() && (stack.method_7969().method_10573(TAG_ENTITY_PICK_UP_TIME, 4) || stack.method_7969().method_10573(TAG_ENTITY_RELEASE_TIME, 4));
    }

    public int method_31569(class_1799 stack) {
        int maxHoldingTime = this.getMaxHoldingTime(stack);
        long currentHoldingTime = 0L;
        if (stack.method_7969().method_10573(TAG_ENTITY_PICK_UP_TIME, 4)) {
            currentHoldingTime = this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), stack, TAG_ENTITY_PICK_UP_TIME, maxHoldingTime);
        }
        if (stack.method_7969().method_10573(TAG_ENTITY_RELEASE_TIME, 4)) {
            currentHoldingTime = (long)(maxHoldingTime /= 5) - this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), stack, TAG_ENTITY_RELEASE_TIME, maxHoldingTime);
        }
        return Math.round(13.0f - (float)currentHoldingTime * 13.0f / (float)maxHoldingTime);
    }

    public int method_31571(class_1799 stack) {
        return BAR_COLOR;
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        if (this.hasStoredEntity(stack)) {
            class_5250 component = class_2561.method_43469((String)"gui.entity_tooltip.type", (Object[])new Object[]{this.getStoredEntityType(stack).method_5897()});
            tooltipComponents.add((class_2561)component.method_27692(class_124.field_1078));
        } else {
            tooltipComponents.add((class_2561)class_2561.method_43471((String)(this.method_7876() + ".desc")).method_27692(class_124.field_1080));
            if (ModRegistry.EMERALD_LASSO_ITEM.isPresent() && this == ModRegistry.EMERALD_LASSO_ITEM.get()) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)(((class_1792)ModRegistry.CONTRACT_ITEM.get()).method_7876() + ".desc")).method_27692(class_124.field_1080));
            }
        }
        if (isAdvanced.method_8035() && stack.method_7985() && MobLassos.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
            boolean hasPickUpTime = stack.method_7969().method_10573(TAG_ENTITY_PICK_UP_TIME, 4);
            boolean hasReleaseTime = stack.method_7969().method_10573(TAG_ENTITY_RELEASE_TIME, 4);
            if (hasPickUpTime || hasReleaseTime) {
                int maxHoldingTime = this.getMaxHoldingTime(stack);
                long currentHoldingTime = 0L;
                if (hasPickUpTime) {
                    currentHoldingTime = this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), stack, TAG_ENTITY_PICK_UP_TIME, maxHoldingTime);
                }
                if (hasReleaseTime) {
                    currentHoldingTime = this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), stack, TAG_ENTITY_RELEASE_TIME, maxHoldingTime /= 5);
                }
                tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.moblassos.lasso.remaining", (Object[])new Object[]{((long)maxHoldingTime - currentHoldingTime) / 20L}).method_27692(class_124.field_1080));
            }
        }
    }

    private long getCurrentHoldingTime(class_1937 level, class_1799 stack, String timeTagKey, int maxHoldingTime) {
        long time = stack.method_7969().method_10537(timeTagKey);
        long currentHoldingTime = level.method_8510() - time;
        return Math.min(currentHoldingTime, (long)maxHoldingTime);
    }

    public int getMaxHoldingTime(class_1799 stack) {
        int time = this.type.getMaxHoldingTime();
        int level = class_1890.method_8225((class_1887)((class_1887)ModRegistry.HOLDING_ENCHANTMENT.get()), (class_1799)stack);
        if (level > 0) {
            time = (int)((double)time + (double)(time * level) * ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).holdingMultiplier);
        }
        return time;
    }

    public void method_33261(class_1542 itemEntity) {
        class_1799 stack = itemEntity.method_6983();
        if (this.hasStoredEntity(stack)) {
            class_2487 storedEntity = stack.method_7941(TAG_STORED_ENTITY);
            this.releaseContentAt(storedEntity, itemEntity.method_37908(), itemEntity.method_24515(), stack);
        }
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int method_7837() {
        return 1;
    }

    public boolean method_31568() {
        return false;
    }

    public boolean method_7886(class_1799 stack) {
        return false;
    }

    public static enum Type {
        GOLDEN(entity -> (entity instanceof class_1429 || entity instanceof class_1421) && !(entity instanceof class_1569), () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).goldenLassoTime, () -> ModRegistry.GOLDEN_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        AQUA(entity -> entity instanceof class_1480 && !(entity instanceof class_1569), () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).aquaLassoTime, () -> ModRegistry.AQUA_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        DIAMOND(entity -> (entity instanceof class_1429 || entity instanceof class_1421 || entity instanceof class_1480) && !(entity instanceof class_1569), () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).diamondLassoTime, () -> ModRegistry.DIAMOND_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        EMERALD(entity -> entity instanceof class_3988 && ModRegistry.VILLAGER_CONTRACT_CAPABILITY.maybeGet(entity).filter(VillagerContractCapability::hasAcceptedContract).isPresent(), () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).emeraldLassoTime, () -> ModRegistry.EMERALD_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        HOSTILE(entity -> entity instanceof class_1569, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).hostileLassoTime, () -> ModRegistry.HOSTILE_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        CREATIVE(entity -> true, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).creativeLassoTime, () -> ModRegistry.CREATIVE_LASSO_BLACKLIST_ENTITY_TYPE_TAG);

        private final Predicate<class_1308> mobFilter;
        private final IntSupplier holdingTime;
        private final Supplier<class_6862<class_1299<?>>> blacklist;

        private Type(Predicate<class_1308> mobFilter, IntSupplier holdingTime, Supplier<class_6862<class_1299<?>>> blacklist) {
            this.mobFilter = mobFilter;
            this.holdingTime = holdingTime;
            this.blacklist = blacklist;
        }

        public boolean hasMaxHoldingTime() {
            return this.holdingTime.getAsInt() != -1;
        }

        public int getMaxHoldingTime() {
            return this.holdingTime.getAsInt() * 20;
        }

        public boolean canPlayerPickUp(class_1657 player, class_1308 mob) {
            if (CommonAbstractions.INSTANCE.isBossMob(mob.method_5864())) {
                return false;
            }
            double hostileMobHealth = ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).hostileMobHealth;
            if (!mob.method_5864().method_20210(this.blacklist.get()) && this.mobFilter.test(mob)) {
                if (this == HOSTILE && (double)(mob.method_6032() / mob.method_6063()) >= hostileMobHealth) {
                    player.method_7353((class_2561)class_2561.method_43469((String)(((class_1792)ModRegistry.HOSTILE_LASSO_ITEM.get()).method_7876() + ".hostile"), (Object[])new Object[]{mob.method_5476(), String.format("%.0f", hostileMobHealth * (double)mob.method_6063()), String.format("%.0f", Float.valueOf(mob.method_6032()))}).method_27692(class_124.field_1061), true);
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

