/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.neruina.report;

import com.bawnorton.neruina.report.IssueFormatter;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.util.Objects;

public final class AutoReportConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private String modid;
    private String repo;
    private String title;
    private String body;

    public AutoReportConfig(String modid, String repo, String title, String body) {
        this.modid = modid;
        this.repo = repo;
        this.title = title;
        this.body = body;
    }

    public boolean isVaild() {
        return this.modid != null && this.repo != null;
    }

    public IssueFormatter createIssueFormatter() {
        return new IssueFormatter(this);
    }

    public static AutoReportConfig fromJson(JsonReader reader) {
        return (AutoReportConfig)GSON.fromJson(reader, AutoReportConfig.class);
    }

    public String modid() {
        return this.modid;
    }

    public String repo() {
        return this.repo;
    }

    public String title() {
        return this.title;
    }

    public String body() {
        return this.body;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AutoReportConfig that = (AutoReportConfig)obj;
        return Objects.equals(this.modid, that.modid) && Objects.equals(this.repo, that.repo) && Objects.equals(this.title, that.title) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.modid, this.repo, this.title, this.body);
    }

    public String toString() {
        return "AutoReportConfig[modid=" + this.modid + ", repo=" + this.repo + ", title=" + this.title + ", body=" + this.body + "]";
    }
}

