/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.common.block.entity;

import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.StoveBlock;

public abstract class AbstractStoveBlockEntity<R extends class_1874, RT extends class_3956<R>>
extends class_2586 {
    private static final class_265 GRILLING_AREA = class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private final class_2371<class_1799> items;
    private final int[] cookingProgress;
    private final int[] cookingTime;
    private final class_1863.class_7266<class_1263, R> recipeLookup;
    private final class_241[] itemRenderOffsets;

    protected AbstractStoveBlockEntity(class_2591<?> blockEntityType, int inventorySlotCount, RT recipeType, class_2338 pos, class_2680 state, class_241[] offsets) {
        super(blockEntityType, pos, state);
        this.items = class_2371.method_10213((int)inventorySlotCount, (Object)class_1799.field_8037);
        this.cookingProgress = new int[inventorySlotCount];
        this.cookingTime = new int[inventorySlotCount];
        this.recipeLookup = class_1863.method_42302(recipeType);
        this.itemRenderOffsets = new class_241[inventorySlotCount];
        System.arraycopy(offsets, 0, this.itemRenderOffsets, 0, Math.min(inventorySlotCount, offsets.length));
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public void method_11014(class_2487 nbtTag) {
        super.method_11014(nbtTag);
        this.items.clear();
        class_1262.method_5429((class_2487)nbtTag, this.items);
        if (nbtTag.method_10573("CookingTimes", 11)) {
            int[] arrayCookingTimes = nbtTag.method_10561("CookingTimes");
            System.arraycopy(arrayCookingTimes, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, arrayCookingTimes.length));
        }
        if (nbtTag.method_10573("CookingTotalTimes", 11)) {
            int[] arrayCookingTimesTotal = nbtTag.method_10561("CookingTotalTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, arrayCookingTimesTotal.length));
        }
    }

    public void method_11007(class_2487 nbtTag) {
        super.method_11007(nbtTag);
        class_1262.method_5427((class_2487)nbtTag, this.items, (boolean)true);
        nbtTag.method_10539("CookingTimes", this.cookingProgress);
        nbtTag.method_10539("CookingTotalTimes", this.cookingTime);
    }

    public class_2487 method_16887() {
        class_2487 nbtTag = super.method_16887();
        class_1262.method_5427((class_2487)nbtTag, this.items, (boolean)true);
        return nbtTag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public static void particleTick(class_1937 level, class_2338 pos, class_2680 state, AbstractStoveBlockEntity<?, ?> stove) {
        for (int i = 0; i < stove.items.size(); ++i) {
            if (((class_1799)stove.items.get(i)).method_7960() || level.field_9229.method_43057() >= 0.2f) continue;
            class_241 stoveItemVector = stove.getStoveItemOffset(i);
            class_2350 direction = (class_2350)state.method_11654((class_2769)StoveBlock.FACING);
            int directionIndex = direction.method_10161();
            class_241 offset = directionIndex % 2 == 0 ? stoveItemVector : new class_241(stoveItemVector.field_1342, stoveItemVector.field_1343);
            double x = (double)pos.method_10263() + 0.5 - (double)((float)direction.method_10148() * offset.field_1343) + (double)((float)direction.method_10170().method_10148() * offset.field_1343);
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5 - (double)((float)direction.method_10165() * offset.field_1342) + (double)((float)direction.method_10170().method_10165() * offset.field_1342);
            for (int k = 0; k < 3; ++k) {
                level.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public static void cooldownTick(class_1937 level, class_2338 pos, class_2680 state, AbstractStoveBlockEntity<?, ?> stove) {
        boolean didChange = false;
        for (int i = 0; i < stove.items.size(); ++i) {
            if (stove.cookingProgress[i] <= 0) continue;
            didChange = true;
            stove.cookingProgress[i] = class_3532.method_15340((int)(stove.cookingProgress[i] - 2), (int)0, (int)stove.cookingTime[i]);
        }
        if (!didChange) {
            return;
        }
        AbstractStoveBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
    }

    public static void cookTick(class_1937 level, class_2338 pos, class_2680 state, AbstractStoveBlockEntity<?, ?> stove) {
        if (level == null) {
            return;
        }
        boolean didChange = false;
        if (stove.isBlockedAbove()) {
            stove.dropAllItems(level, pos, state);
            return;
        }
        for (int i = 0; i < stove.items.size(); ++i) {
            class_1799 stoveStack = (class_1799)stove.items.get(i);
            if (stoveStack.method_7960()) continue;
            didChange = true;
            int n = i;
            stove.cookingProgress[n] = stove.cookingProgress[n] + 1;
            if (stove.cookingProgress[i] < stove.cookingTime[i]) continue;
            class_1277 inventoryWrapper = new class_1277(new class_1799[]{stoveStack});
            class_1799 result = stove.recipeLookup.method_42303((class_1263)inventoryWrapper, level).map(arg_0 -> AbstractStoveBlockEntity.lambda$cookTick$0((class_1263)inventoryWrapper, level, arg_0)).orElse(stoveStack);
            if (!result.method_45435(level.method_45162())) continue;
            class_1264.method_5449((class_1937)level, (double)((double)stove.field_11867.method_10263() + 0.5), (double)((double)stove.field_11867.method_10264() + 1.0), (double)((double)stove.field_11867.method_10260() + 0.5), (class_1799)result);
            stove.items.set(i, (Object)class_1799.field_8037);
            level.method_8413(pos, state, state, 3);
            level.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
        }
        if (!didChange) {
            return;
        }
        AbstractStoveBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
    }

    public Optional<R> getCookableRecipe(class_1799 item) {
        if (this.isBlockedAbove()) {
            return Optional.empty();
        }
        if (this.items.stream().noneMatch(class_1799::method_7960)) {
            return Optional.empty();
        }
        return this.recipeLookup.method_42303((class_1263)new class_1277(new class_1799[]{item}), this.field_11863);
    }

    public boolean placeFood(@Nullable class_1297 placer, class_1799 itemStackToPlace, int cookingTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 itemStack = (class_1799)this.items.get(i);
            if (!itemStack.method_7960()) continue;
            this.cookingTime[i] = cookingTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)itemStackToPlace.method_7971(1));
            this.field_11863.method_43276(class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43286((class_1297)placer, (class_2680)this.method_11010()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean isBlockedAbove() {
        if (this.field_11863 == null) {
            return false;
        }
        class_2680 above = this.field_11863.method_8320(this.field_11867.method_10084());
        return class_259.method_1074((class_265)GRILLING_AREA, (class_265)above.method_26218((class_1922)this.field_11863, this.field_11867.method_10084()), (class_247)class_247.field_16896);
    }

    public void dropAllItems(class_1937 level, class_2338 pos, class_2680 state) {
        if (level == null) {
            return;
        }
        class_1264.method_17349((class_1937)level, (class_2338)pos, this.items);
    }

    public class_241 getStoveItemOffset(int index) {
        return this.itemRenderOffsets[index];
    }

    protected void markUpdated() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void onExtinguish() {
    }

    public void extinguish() {
        if (this.field_11863 == null) {
            return;
        }
        this.onExtinguish();
        this.markUpdated();
    }

    private static /* synthetic */ class_1799 lambda$cookTick$0(class_1263 inventoryWrapper, class_1937 level, class_1874 recipe) {
        return recipe.method_8116(inventoryWrapper, level.method_30349());
    }
}

