/*
 * Decompiled with CFR 0.152.
 */
package com.sargerasarm.noseenotick.entity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sargerasarm.noseenotick.Utils;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ItemEntity {
    private static final Cache<UUID, Boolean> itemCollisionCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(1L)).build();

    public static boolean isGrounded(Level level, Entity entity, AABB aabb) {
        if (entity.m_20096_() && Utils.enoughPlayers(level)) {
            try {
                return (Boolean)itemCollisionCache.get((Object)entity.m_20148_(), () -> ItemEntity.noCollision(level, entity, aabb));
            }
            catch (ExecutionException e) {
                itemCollisionCache.invalidate((Object)entity.m_20148_());
                return false;
            }
        }
        return ItemEntity.noCollision(level, entity, aabb);
    }

    private static boolean noCollision(Level level, Entity entity, AABB aabb) {
        for (VoxelShape voxelShape : level.m_186434_(entity, aabb)) {
            if (voxelShape.m_83281_()) continue;
            return false;
        }
        if (!level.m_183134_(entity, aabb).isEmpty()) {
            return false;
        }
        if (entity != null) {
            WorldBorder worldBorder = level.m_6857_();
            VoxelShape borderCollision = worldBorder.m_187566_(entity, aabb) ? worldBorder.m_61946_() : null;
            return borderCollision == null || !Shapes.m_83157_((VoxelShape)borderCollision, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        }
        return true;
    }
}

