/*
 * Decompiled with CFR 0.152.
 */
package com.sargerasarm.noseenotick.mixin;

import com.sargerasarm.noseenotick.Config;
import com.sargerasarm.noseenotick.Utils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.class})
public class WorldEntitySpawnerOptimizationMixin {
    @Inject(at={@At(value="HEAD")}, method={"getRandomSpawnMobAt"}, cancellable=true)
    private static void getRandomSpawnMobAt(ServerLevel level, StructureManager arg2, ChunkGenerator arg3, MobCategory arg4, RandomSource arg5, BlockPos blockPos, CallbackInfoReturnable<Optional<MobSpawnSettings.SpawnerData>> cir) {
        int maxDistanceSquare;
        int maxHeight;
        if (!Utils.isInClaimedChunk((Level)level, blockPos) && Utils.enoughPlayers((Level)level) && !Utils.isNearPlayer((Level)level, blockPos, maxHeight = ((Integer)Config.maxEntitySpawnDistanceVertical.get()).intValue(), maxDistanceSquare = ((Integer)Config.maxEntitySpawnDistanceHorizontal.get()).intValue())) {
            cir.setReturnValue(Optional.empty());
        }
    }
}

