/*
 * Decompiled with CFR 0.152.
 */
package com.sargerasarm.noseenotick.network;

import com.google.common.collect.Lists;
import com.sargerasarm.noseenotick.client.ClaimedChunksClient;
import com.sargerasarm.noseenotick.network.ChunkDimPos;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SendClaimedChunksPacket {
    private List<ChunkDimPos> claimedChunks;

    public SendClaimedChunksPacket(List<ChunkDimPos> claimedChunks) {
        this.claimedChunks = claimedChunks;
    }

    public SendClaimedChunksPacket(FriendlyByteBuf buf) {
        this.claimedChunks = (List)buf.m_236838_(Lists::newArrayListWithCapacity, ChunkDimPos::decode);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236828_(this.claimedChunks, (buffer, e) -> e.encode((FriendlyByteBuf)buffer));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
                return;
            }
            ClaimedChunksClient.getInstance().updateChunks(this.claimedChunks);
        });
        ctx.get().setPacketHandled(true);
    }
}

