/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_345;

public final class BossBarsRenderRegistry {
    public static Function<class_310, Integer> DEFAULT_INCREMENT = minecraft -> {
        Objects.requireNonNull(minecraft.field_1772);
        return 10 + 9;
    };
    private static final List<Style> REGISTRY = new ArrayList<Style>();
    private static final List<Supplier<List<Style>>> REGISTRIES;

    public static void register(String key, boolean literal, boolean renderBar, boolean renderName, Function<class_310, Integer> increment, BossBarRenderer function) {
        Style style = new Style(key, literal, renderBar, renderName, increment, function);
        REGISTRY.add(style);
    }

    public static void register(List<Style> registry, String key, boolean literal, boolean renderBar, boolean renderName, Function<class_310, Integer> increment, BossBarRenderer function) {
        if (registry == null) {
            return;
        }
        Style style = new Style(key, literal, renderBar, renderName, increment, function);
        registry.add(style);
    }

    public static void addRegistry(Supplier<List<Style>> holder) {
        REGISTRIES.add(holder);
    }

    public static Optional<Style> getStyle(class_2561 bossBar) {
        for (Style style : BossBarsRenderRegistry.getStyles()) {
            if (!style.equals(bossBar)) continue;
            return Optional.of(style);
        }
        return Optional.empty();
    }

    public static List<Style> getStyles() {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (Supplier<List<Style>> list : REGISTRIES) {
            styles.addAll((Collection<Style>)list.get());
        }
        return styles;
    }

    static {
        ArrayList<Supplier<List<Style>>> list = new ArrayList<Supplier<List<Style>>>();
        list.add(() -> REGISTRY);
        REGISTRIES = list;
    }

    public static class Style {
        private final String KEY;
        private final boolean LITERAL_KEY;
        private final BossBarRenderer FUNCTION;
        private final Function<class_310, Integer> INCREMENT;
        private final boolean RENDER_BAR;
        private final boolean RENDER_NAME;

        private Style(String key, boolean literal, boolean renderBar, boolean renderName, Function<class_310, Integer> increment, BossBarRenderer function) {
            this.KEY = key;
            this.LITERAL_KEY = literal;
            this.FUNCTION = function;
            this.INCREMENT = increment;
            this.RENDER_BAR = renderBar;
            this.RENDER_NAME = renderName;
        }

        public boolean equals(class_2561 name) {
            return name.getString().equals(this.LITERAL_KEY ? this.KEY : class_2561.method_43471((String)this.KEY).getString());
        }

        public BossBarRenderer getFunction() {
            return this.FUNCTION;
        }

        public int getIncrement(class_310 minecraft) {
            return this.INCREMENT.apply(minecraft);
        }

        public boolean shouldRenderBar() {
            return this.RENDER_BAR;
        }

        public boolean shouldRenderName() {
            return this.RENDER_NAME;
        }
    }

    @FunctionalInterface
    public static interface BossBarRenderer {
        public void render(class_310 var1, class_332 var2, int var3, int var4, class_345 var5, class_2561 var6);
    }
}

