/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.hekate;

import com.obscuria.obscureapi.api.tools.ExceptionFilter;
import com.obscuria.obscureapi.network.AnimationPlayPacket;
import com.obscuria.obscureapi.network.AnimationStopPacket;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class Animation {
    private final byte ID;
    private int tick;
    private int duration;

    public Animation(int id) {
        this.ID = (byte)id;
    }

    public void tick() {
        if (this.duration > 0) {
            ++this.tick;
        }
        if (this.tick >= this.duration) {
            this.tick = 0;
            this.duration = 0;
        }
    }

    public void play(class_1297 entity, int duration) {
        this.play(entity, 0, duration, 256);
    }

    public void play(class_1297 entity, int tick, int duration) {
        this.play(entity, tick, duration, 256);
    }

    public void play(class_1297 entity, int tick, int duration, int distance) {
        if (entity == null || entity.method_37908().method_8608()) {
            return;
        }
        this.localPlay(tick, duration);
        for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
            ServerPlayNetworking.send((class_3222)player, (FabricPacket)new AnimationPlayPacket(entity.method_5628(), this.getID(), tick, duration));
        }
    }

    public void stop(class_1297 entity) {
        this.stop(entity, 256);
    }

    public void stop(class_1297 entity, int distance) {
        if (entity == null || entity.method_37908().method_8608()) {
            return;
        }
        this.localStop();
        for (class_3222 player : PlayerLookup.tracking((class_1297)entity)) {
            ServerPlayNetworking.send((class_3222)player, (FabricPacket)new AnimationStopPacket(entity.method_5628(), this.getID()));
        }
    }

    public void localPlay(int tick, int duration) {
        this.tick = tick;
        this.duration = duration;
    }

    public void localStop() {
        this.tick = 0;
        this.duration = 0;
    }

    public boolean sound(class_1297 entity, int tick, Supplier<class_3414> sound, class_3419 source, float volume, float pitch) {
        if (this.tick != tick) {
            return false;
        }
        entity.method_37908().method_8396(null, entity.method_24515(), sound.get(), source, volume, pitch);
        return true;
    }

    public byte getID() {
        return this.ID;
    }

    public int getTick() {
        return this.tick;
    }

    public boolean hasPlayed() {
        return this.isPlaying() && this.getTick() == this.getDuration() - 1;
    }

    public int getDuration() {
        return this.duration;
    }

    public float getProgress() {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf((float)this.tick / (float)this.duration)).floatValue();
    }

    public float getProgress(float partialTicks) {
        return ExceptionFilter.getNoNull(Float.valueOf(0.0f), () -> Float.valueOf(((float)this.tick + partialTicks) / (float)this.duration)).floatValue();
    }

    public boolean isPlaying() {
        return this.duration > 0 && this.tick < this.duration;
    }
}

