/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.common.classes.ability;

import com.obscuria.obscureapi.api.ClassRegistry;
import com.obscuria.obscureapi.api.tools.ExceptionFilter;
import com.obscuria.obscureapi.api.utils.TextUtils;
import com.obscuria.obscureapi.common.classes.GameClass;
import com.obscuria.obscureapi.common.classes.GameClassHelper;
import com.obscuria.obscureapi.common.classes.ability.context.AbilityContext;
import com.obscuria.obscureapi.common.classes.bonus.Bonus;
import com.obscuria.obscureapi.registry.ObscureAPIEffects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class Ability {
    private final Class<? extends class_1792> ITEM;
    private final String DESCRIPTION;
    private final Cost COST;
    private final Style STYLE;
    private final Action ACTION;
    private final List<Variable> VARIABLES;

    private Ability(Class<? extends class_1792> item, String description, Style style, Cost cost, List<Variable> variables, Action action) {
        this.ITEM = item;
        this.DESCRIPTION = description;
        this.STYLE = style;
        this.COST = cost;
        this.VARIABLES = variables;
        this.ACTION = action;
    }

    @Contract(value="_, _ -> new")
    public static Builder create(String modID, String name) {
        return new Builder(modID, name);
    }

    public boolean use(AbilityContext context) {
        if (!this.canUse(context.getStack(), context.getUser())) {
            return false;
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 1; !this.VARIABLES.isEmpty() && i <= this.VARIABLES.size(); ++i) {
            values.add(this.getVariable(context.getUser(), i));
        }
        if (this.ACTION.use(context, values)) {
            this.postUse(context.getStack(), context.getUser());
            return true;
        }
        return false;
    }

    public boolean canUse(class_1799 stack, class_1309 entity) {
        return this.COST.test(stack, entity, this.getCost(entity));
    }

    public void postUse(class_1799 stack, class_1309 entity) {
        this.COST.use(stack, entity, this.getCost(entity));
    }

    public String getDescription() {
        return this.DESCRIPTION;
    }

    public Style getStyle() {
        return this.STYLE;
    }

    public int getCost(@Nullable class_1309 entity) {
        if (this.COST.TYPE == CostType.NONE || entity == null) {
            return 0;
        }
        int mod1 = 0;
        int mod2 = 0;
        if (this.COST.TYPE == CostType.COOLDOWN && entity.method_6059((class_1291)ObscureAPIEffects.RUSH)) {
            mod2 += -10 - 10 * Objects.requireNonNull(entity.method_6112((class_1291)ObscureAPIEffects.RUSH)).method_5578();
        }
        if (GameClassHelper.hasClass(this.ITEM)) {
            GameClass clazz = GameClassHelper.getClass(this.ITEM).orElse(ClassRegistry.BLANK);
            String type = GameClassHelper.getType(this.ITEM).orElse("null");
            List<Bonus> ARMOR_HEAD = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6169)) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6169)) : null;
            List<Bonus> ARMOR_CHEST = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6174)) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6174)) : null;
            List<Bonus> ARMOR_LEGS = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6172)) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6172)) : null;
            List<Bonus> ARMOR_FEET = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6166)) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6166)) : null;
            List<Bonus> HAND = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6173)) && !(entity.method_6118(class_1304.field_6173).method_7909() instanceof class_1738) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6173)) : null;
            mod1 += this.calculateBonus(ARMOR_HEAD, clazz, type, this.COST.toBonus(), Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_CHEST, clazz, type, this.COST.toBonus(), Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_LEGS, clazz, type, this.COST.toBonus(), Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_FEET, clazz, type, this.COST.toBonus(), Bonus.Operation.AMOUNT) + this.calculateBonus(HAND, clazz, type, this.COST.toBonus(), Bonus.Operation.AMOUNT);
            mod2 += this.calculateBonus(ARMOR_HEAD, clazz, type, this.COST.toBonus(), Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_CHEST, clazz, type, this.COST.toBonus(), Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_LEGS, clazz, type, this.COST.toBonus(), Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_FEET, clazz, type, this.COST.toBonus(), Bonus.Operation.PERCENT) + this.calculateBonus(HAND, clazz, type, this.COST.toBonus(), Bonus.Operation.PERCENT);
        }
        mod2 = Math.max(mod2, -80);
        return (int)Math.max((double)Math.round((double)(this.COST.VALUE + mod1) + (double)this.COST.VALUE * ((double)mod2 / 100.0)), 1.0);
    }

    public int getVariable(@Nullable class_1309 entity, int index) {
        if (entity == null) {
            return 0;
        }
        int variable = this.getVariable(index);
        if (variable <= 0) {
            return 0;
        }
        int mod1 = 0;
        int mod2 = 0;
        if (entity.method_6059((class_1291)ObscureAPIEffects.FURY)) {
            mod2 += 10 + 10 * Objects.requireNonNull(entity.method_6112((class_1291)ObscureAPIEffects.FURY)).method_5578();
        }
        if (GameClassHelper.hasClass(this.ITEM)) {
            GameClass clazz = GameClassHelper.getClass(this.ITEM).orElse(ClassRegistry.BLANK);
            String type = GameClassHelper.getType(this.ITEM).orElse("null");
            List<Bonus> ARMOR_HEAD = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6169)) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6169)) : null;
            List<Bonus> ARMOR_CHEST = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6174)) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6174)) : null;
            List<Bonus> ARMOR_LEGS = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6172)) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6172)) : null;
            List<Bonus> ARMOR_FEET = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6166)) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6166)) : null;
            List<Bonus> HAND = GameClassHelper.hasBonuses(entity.method_6118(class_1304.field_6173)) && !(entity.method_6118(class_1304.field_6173).method_7909() instanceof class_1738) ? GameClassHelper.getVisibleBonuses(entity.method_6118(class_1304.field_6173)) : null;
            mod1 += this.calculateBonus(ARMOR_HEAD, clazz, type, Bonus.Type.POWER, Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_CHEST, clazz, type, Bonus.Type.POWER, Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_LEGS, clazz, type, Bonus.Type.POWER, Bonus.Operation.AMOUNT) + this.calculateBonus(ARMOR_FEET, clazz, type, Bonus.Type.POWER, Bonus.Operation.AMOUNT) + this.calculateBonus(HAND, clazz, type, Bonus.Type.POWER, Bonus.Operation.AMOUNT);
            mod2 += this.calculateBonus(ARMOR_HEAD, clazz, type, Bonus.Type.POWER, Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_CHEST, clazz, type, Bonus.Type.POWER, Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_LEGS, clazz, type, Bonus.Type.POWER, Bonus.Operation.PERCENT) + this.calculateBonus(ARMOR_FEET, clazz, type, Bonus.Type.POWER, Bonus.Operation.PERCENT) + this.calculateBonus(HAND, clazz, type, Bonus.Type.POWER, Bonus.Operation.PERCENT);
        }
        return (int)Math.max((double)Math.round((double)(variable + mod1) + (double)variable * ((double)mod2 / 100.0)), 1.0);
    }

    public int getVariable(int index) {
        return ExceptionFilter.getNoNull(0, () -> this.VARIABLES.get(index - 1).value());
    }

    public String getVariableType(int index) {
        return ExceptionFilter.getNoNull("", () -> this.VARIABLES.get(index - 1).type());
    }

    public String getCostString(class_1309 entity) {
        int cost = this.COST.VALUE;
        int mod2 = this.getCost(entity);
        String costString = TextUtils.translation("obscure_api.ability.cost." + this.COST.getName());
        String costAmount = cost < mod2 ? "\u00a7c" + mod2 : (cost > mod2 ? "\u00a72" + mod2 : Integer.valueOf(mod2));
        costString = costString.replace("#", costAmount);
        return costString + (String)(cost < mod2 ? " \u00a78+" + Math.round(((double)mod2 / 1.0 / (double)cost - 1.0) * 100.0) + "%" : (cost > mod2 ? " \u00a78-" + Math.round((1.0 - (double)mod2 / 1.0 / (double)cost) * 100.0) + "%" : ""));
    }

    public String getVariableString(class_1309 entity, int index) {
        int mod2;
        int variable = this.getVariable(index);
        return "" + (Serializable)(variable < (mod2 = this.getVariable(entity, index)) ? "\u00a72" + mod2 : (variable > mod2 ? "\u00a7c" + mod2 : Integer.valueOf(mod2)));
    }

    public String getVariableTypeString(int index) {
        String modifier = this.getVariableType(index);
        return modifier.equals("") ? "" : TextUtils.translation("obscure_api.ability.modifier." + modifier);
    }

    private int calculateBonus(@Nullable List<Bonus> list, GameClass clazz, String type, Bonus.Type bonus, Bonus.Operation operation) {
        int mod2 = 0;
        if (list != null && !list.isEmpty()) {
            for (Bonus entry : list) {
                if (!entry.canApply(clazz, type, bonus, operation)) continue;
                mod2 += entry.getValue();
            }
        }
        return mod2;
    }

    public static enum Style {
        COMMON("\u00a7f", "\u00a77"),
        ATTRIBUTE("\u00a7f", "\u00a79"),
        EPIC("\u00a7d", "\u00a75"),
        LEGENDARY("\u00a7e", "\u00a76"),
        MYTHIC("\u00a7c", "\u00a7c");

        public final String TITLE;
        public final String LINE;

        private Style(String title, String line) {
            this.TITLE = title;
            this.LINE = line;
        }
    }

    public static class Cost {
        final int VALUE;
        final CostType TYPE;

        public Cost(int value, CostType type) {
            this.VALUE = value;
            this.TYPE = type;
        }

        public boolean test(class_1799 stack, class_1309 entity, int cost) {
            return this.TYPE.CONDITION.test(stack, entity, cost);
        }

        public void use(class_1799 stack, class_1309 entity, int cost) {
            this.TYPE.USE.use(stack, entity, cost);
        }

        public String getName() {
            return this.TYPE.NAME;
        }

        @Contract(pure=true)
        public String getDescriptionId() {
            return "ability.cost." + this.getName();
        }

        public Bonus.Type toBonus() {
            if (this.TYPE.equals((Object)CostType.COOLDOWN)) {
                return Bonus.Type.COOLDOWN;
            }
            return Bonus.Type.POWER;
        }
    }

    @FunctionalInterface
    public static interface Action {
        public boolean use(AbilityContext var1, List<Integer> var2);
    }

    public static class Builder {
        private final String modID;
        private final String name;
        private Cost cost = new Cost(0, CostType.NONE);
        private Style style = Style.COMMON;
        private Action action = (context, variables) -> true;
        private final List<Variable> variables = new ArrayList<Variable>();

        private Builder(String modID, String name) {
            this.modID = modID;
            this.name = name;
        }

        public Builder cost(int value) {
            this.cost = new Cost(value, CostType.NONE);
            return this;
        }

        public Builder cost(CostType type, int value) {
            this.cost = new Cost(value, type);
            return this;
        }

        public Builder var(int value, String type) {
            this.variables.add(new Variable(value, type));
            return this;
        }

        public Builder var(int value) {
            return this.var(value, "");
        }

        public Builder sec(int value) {
            return this.var(value, "s");
        }

        public Builder mod(int value) {
            return this.var(value, "%");
        }

        public Builder style(Style style) {
            this.style = style;
            return this;
        }

        public Builder action(Action action) {
            this.action = action;
            return this;
        }

        public Ability build(Class<? extends class_1792> item) {
            return new Ability(item, "ability." + this.modID + "." + this.name, this.style, this.cost, this.variables, this.action);
        }
    }

    public static enum CostType {
        NONE("none", (stack, entity, cost) -> true, (stack, entity, cost) -> {}),
        DURABILITY("durability", (stack, entity, cost) -> stack.method_7936() - stack.method_7919() > cost, (stack, entity, cost) -> stack.method_7956(cost, entity, e -> {})),
        HEALTH("health", (stack, entity, cost) -> entity.method_6032() > (float)cost, (stack, entity, cost) -> entity.method_6033(entity.method_6032() - (float)cost)),
        COOLDOWN("cooldown", (stack, entity, cost) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return !player.method_7357().method_7904(stack.method_7909());
            }
            return true;
        }, (stack, entity, cost) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.method_7357().method_7906(stack.method_7909(), cost * 20);
            }
        }),
        EXP("exp", (stack, entity, cost) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return player.field_7495 >= cost;
            }
            return true;
        }, (stack, entity, cost) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.field_7495 -= cost;
            }
        }),
        LEVEL("level", (stack, entity, cost) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return player.field_7520 >= cost;
            }
            return true;
        }, (stack, entity, cost) -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                player.field_7520 -= cost;
            }
        });

        private final String NAME;
        private final UseCondition CONDITION;
        private final PostUseAction USE;

        private CostType(String name, UseCondition condition, PostUseAction use) {
            this.NAME = name;
            this.CONDITION = condition;
            this.USE = use;
        }

        @FunctionalInterface
        public static interface UseCondition {
            public boolean test(class_1799 var1, class_1309 var2, int var3);
        }

        @FunctionalInterface
        public static interface PostUseAction {
            public void use(class_1799 var1, class_1309 var2, int var3);
        }
    }

    protected record Variable(int value, String type) {
    }
}

