/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.common.entities;

import com.obscuria.obscureapi.api.utils.EntityUtils;
import com.obscuria.obscureapi.registry.ObscureAPIEntities;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class TextureFX
extends class_1297 {
    private static final String BLANK_TEXTURE_LOC = "obscure_api";
    private static final String BLANK_TEXTURE_NAME = "blank";
    private static final UUID BLANK_OWNER = UUID.fromString("0-0-0-0-0");
    private static final class_2940<Integer> LIFETIME = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> FORWARD = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SIDE = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> UP = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> X_OFF = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Y_OFF = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> X_OFF_MOD = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Y_OFF_MOD = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> X_OFF_MOD_A = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Y_OFF_MOD_A = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> X_ROT_MAIN = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Y_ROT_MAIN = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> X_ROT = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Y_ROT = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Z_ROT = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> X_MOD = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Y_MOD = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Z_MOD = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> X_MOD_A = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Y_MOD_A = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> Z_MOD_A = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SCALE = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SCALE_MOD = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SCALE_MOD_A = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ALPHA = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ALPHA_MOD = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ALPHA_MOD_A = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> OWNER_ID = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> BOUND_POS = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> BOUND_ROT = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> ANIMATED = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> FRAMES = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> FRAME_TIME = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13327);
    private static final class_2940<String> TEXTURE_LOC = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> TEXTURE_NAME = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Integer> RENDER_TYPE = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> AGE = class_2945.method_12791(TextureFX.class, (class_2941)class_2943.field_13327);
    private Consumer<TextureFX> action;
    private boolean created;
    private float xOff;
    private float xOffLerp;
    private float yOff;
    private float yOffLerp;
    private float xRot;
    private float xRotLerp;
    private float yRot;
    private float yRotLerp;
    private float zRot;
    private float zRotLerp;
    private float scale;
    private float scaleLerp;
    private float alpha;
    private float alphaLerp;
    private int frame;
    private int frameTime;

    public TextureFX(class_1299<? extends class_1297> type, class_1937 world) {
        super(type, world);
        this.action = textureFX -> {};
        this.created = false;
        this.frame = 1;
        this.frameTime = 0;
    }

    private TextureFX(Builder builder, class_1937 level) {
        super(ObscureAPIEntities.TEXTURE_FX, level);
        this.action = textureFX -> {};
        this.created = false;
        this.frame = 1;
        this.frameTime = 0;
        if (builder.owner != null) {
            this.method_5841().method_12778(OWNER_UUID, Optional.of(builder.owner.method_5667()));
        }
        this.method_5841().method_12778(FORWARD, (Object)Float.valueOf(builder.forward));
        this.method_5841().method_12778(SIDE, (Object)Float.valueOf(builder.side));
        this.method_5841().method_12778(UP, (Object)Float.valueOf(builder.up));
        this.method_5841().method_12778(X_OFF, (Object)Float.valueOf(builder.xOff));
        this.method_5841().method_12778(X_OFF_MOD, (Object)Float.valueOf(builder.xOffMod));
        this.method_5841().method_12778(X_OFF_MOD_A, (Object)Float.valueOf(builder.xOffModA));
        this.method_5841().method_12778(Y_OFF, (Object)Float.valueOf(builder.yOff));
        this.method_5841().method_12778(Y_OFF_MOD, (Object)Float.valueOf(builder.yOffMod));
        this.method_5841().method_12778(Y_OFF_MOD_A, (Object)Float.valueOf(builder.yOffModA));
        this.method_5841().method_12778(X_ROT_MAIN, (Object)Float.valueOf(builder.xRotMain));
        this.method_5841().method_12778(X_ROT, (Object)Float.valueOf(builder.xRot));
        this.method_5841().method_12778(X_MOD, (Object)Float.valueOf(builder.xMod));
        this.method_5841().method_12778(X_MOD_A, (Object)Float.valueOf(builder.xModA));
        this.method_5841().method_12778(Y_ROT_MAIN, (Object)Float.valueOf(builder.yRotMain));
        this.method_5841().method_12778(Y_ROT, (Object)Float.valueOf(builder.yRot));
        this.method_5841().method_12778(Y_MOD, (Object)Float.valueOf(builder.yMod));
        this.method_5841().method_12778(Y_MOD_A, (Object)Float.valueOf(builder.yModA));
        this.method_5841().method_12778(Z_ROT, (Object)Float.valueOf(builder.zRot));
        this.method_5841().method_12778(Z_MOD, (Object)Float.valueOf(builder.zMod));
        this.method_5841().method_12778(Z_MOD_A, (Object)Float.valueOf(builder.zModA));
        this.method_5841().method_12778(LIFETIME, (Object)builder.lifetime);
        this.method_5841().method_12778(SCALE, (Object)Float.valueOf(builder.scale));
        this.method_5841().method_12778(SCALE_MOD, (Object)Float.valueOf(builder.scaleMod));
        this.method_5841().method_12778(SCALE_MOD_A, (Object)Float.valueOf(builder.scaleModA));
        this.method_5841().method_12778(ALPHA, (Object)Float.valueOf(builder.alpha));
        this.method_5841().method_12778(ALPHA_MOD, (Object)Float.valueOf(builder.alphaMod));
        this.method_5841().method_12778(ALPHA_MOD_A, (Object)Float.valueOf(builder.alphaModA));
        this.method_5841().method_12778(BOUND_POS, (Object)builder.boundPos);
        this.method_5841().method_12778(BOUND_ROT, (Object)builder.boundRot);
        this.method_5841().method_12778(ANIMATED, (Object)builder.animated);
        this.method_5841().method_12778(FRAMES, (Object)builder.frames);
        this.method_5841().method_12778(FRAME_TIME, (Object)builder.frameTime);
        this.method_5841().method_12778(TEXTURE_LOC, (Object)builder.textureLoc);
        this.method_5841().method_12778(TEXTURE_NAME, (Object)builder.textureName);
        this.method_5841().method_12778(RENDER_TYPE, (Object)builder.renderType);
        this.action = builder.action;
        this.method_33574(new class_243((double)builder.x, (double)builder.y, (double)builder.z));
        level.method_8649((class_1297)this);
        if (builder.sound != null) {
            this.method_37908().method_8396(null, this.method_24515(), builder.sound, class_3419.field_15250, builder.volume, builder.pitch);
        }
    }

    protected void method_5693() {
        this.method_5841().method_12784(LIFETIME, (Object)20);
        this.method_5841().method_12784(FORWARD, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(SIDE, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(UP, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(X_OFF, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(X_OFF_MOD, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(X_OFF_MOD_A, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Y_OFF, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Y_OFF_MOD, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Y_OFF_MOD_A, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(X_ROT_MAIN, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(X_ROT, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(X_MOD, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(X_MOD_A, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Y_ROT_MAIN, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Y_ROT, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Y_MOD, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Y_MOD_A, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Z_ROT, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Z_MOD, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(Z_MOD_A, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(SCALE, (Object)Float.valueOf(1.0f));
        this.method_5841().method_12784(SCALE_MOD, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(SCALE_MOD_A, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(ALPHA, (Object)Float.valueOf(1.0f));
        this.method_5841().method_12784(ALPHA_MOD, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(ALPHA_MOD_A, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(OWNER_UUID, Optional.of(BLANK_OWNER));
        this.method_5841().method_12784(OWNER_ID, (Object)0);
        this.method_5841().method_12784(BOUND_POS, (Object)false);
        this.method_5841().method_12784(BOUND_ROT, (Object)false);
        this.method_5841().method_12784(AGE, (Object)0);
        this.method_5841().method_12784(ANIMATED, (Object)false);
        this.method_5841().method_12784(FRAMES, (Object)1);
        this.method_5841().method_12784(FRAME_TIME, (Object)20);
        this.method_5841().method_12784(TEXTURE_LOC, (Object)BLANK_TEXTURE_LOC);
        this.method_5841().method_12784(TEXTURE_NAME, (Object)BLANK_TEXTURE_NAME);
        this.method_5841().method_12784(RENDER_TYPE, (Object)0);
    }

    protected void method_5652(class_2487 data) {
        class_2487 tag = new class_2487();
        tag.method_10569("lifetime", ((Integer)this.method_5841().method_12789(LIFETIME)).intValue());
        tag.method_10548("forward", ((Float)this.method_5841().method_12789(FORWARD)).floatValue());
        tag.method_10548("side", ((Float)this.method_5841().method_12789(SIDE)).floatValue());
        tag.method_10548("up", ((Float)this.method_5841().method_12789(UP)).floatValue());
        tag.method_10548("xOff", ((Float)this.method_5841().method_12789(X_OFF)).floatValue());
        tag.method_10548("xOffMod", ((Float)this.method_5841().method_12789(X_OFF_MOD)).floatValue());
        tag.method_10548("xOffModA", ((Float)this.method_5841().method_12789(X_OFF_MOD_A)).floatValue());
        tag.method_10548("yOff", ((Float)this.method_5841().method_12789(Y_OFF)).floatValue());
        tag.method_10548("yOffMod", ((Float)this.method_5841().method_12789(Y_OFF_MOD)).floatValue());
        tag.method_10548("yOffModA", ((Float)this.method_5841().method_12789(Y_OFF_MOD_A)).floatValue());
        tag.method_10548("xRotMain", ((Float)this.method_5841().method_12789(X_ROT_MAIN)).floatValue());
        tag.method_10548("yRotMain", ((Float)this.method_5841().method_12789(Y_ROT_MAIN)).floatValue());
        tag.method_10548("xRot", ((Float)this.method_5841().method_12789(X_ROT)).floatValue());
        tag.method_10548("yRot", ((Float)this.method_5841().method_12789(Y_ROT)).floatValue());
        tag.method_10548("zRot", ((Float)this.method_5841().method_12789(Z_ROT)).floatValue());
        tag.method_10548("xMod", ((Float)this.method_5841().method_12789(X_MOD)).floatValue());
        tag.method_10548("yMod", ((Float)this.method_5841().method_12789(Y_MOD)).floatValue());
        tag.method_10548("zMod", ((Float)this.method_5841().method_12789(Z_MOD)).floatValue());
        tag.method_10548("xModA", ((Float)this.method_5841().method_12789(X_MOD_A)).floatValue());
        tag.method_10548("yModA", ((Float)this.method_5841().method_12789(Y_MOD_A)).floatValue());
        tag.method_10548("zModA", ((Float)this.method_5841().method_12789(Z_MOD_A)).floatValue());
        tag.method_10548("scale", ((Float)this.method_5841().method_12789(SCALE)).floatValue());
        tag.method_10548("scaleMod", ((Float)this.method_5841().method_12789(SCALE_MOD)).floatValue());
        tag.method_10548("scaleModA", ((Float)this.method_5841().method_12789(SCALE_MOD_A)).floatValue());
        tag.method_10548("alpha", ((Float)this.method_5841().method_12789(ALPHA)).floatValue());
        tag.method_10548("alphaMod", ((Float)this.method_5841().method_12789(ALPHA_MOD)).floatValue());
        tag.method_10548("alphaModA", ((Float)this.method_5841().method_12789(ALPHA_MOD_A)).floatValue());
        tag.method_25927("ownerUUID", ((Optional)this.method_5841().method_12789(OWNER_UUID)).orElse(BLANK_OWNER));
        tag.method_10569("ownerID", ((Integer)this.method_5841().method_12789(OWNER_ID)).intValue());
        tag.method_10556("boundPos", ((Boolean)this.method_5841().method_12789(BOUND_POS)).booleanValue());
        tag.method_10556("boundRot", ((Boolean)this.method_5841().method_12789(BOUND_ROT)).booleanValue());
        tag.method_10569("age", ((Integer)this.method_5841().method_12789(AGE)).intValue());
        tag.method_10556("animated", ((Boolean)this.method_5841().method_12789(ANIMATED)).booleanValue());
        tag.method_10569("frames", ((Integer)this.method_5841().method_12789(FRAMES)).intValue());
        tag.method_10569("frameTime", ((Integer)this.method_5841().method_12789(FRAME_TIME)).intValue());
        tag.method_10582("textureLoc", (String)this.method_5841().method_12789(TEXTURE_LOC));
        tag.method_10582("textureName", (String)this.method_5841().method_12789(TEXTURE_NAME));
        tag.method_10569("renderType", ((Integer)this.method_5841().method_12789(RENDER_TYPE)).intValue());
        data.method_10566("TextureFX", (class_2520)tag);
    }

    protected void method_5749(class_2487 data) {
        if (!data.method_10545("TextureFX")) {
            return;
        }
        class_2487 tag = data.method_10562("TextureFX");
        this.method_5841().method_12778(LIFETIME, (Object)tag.method_10550("lifetime"));
        this.method_5841().method_12778(FORWARD, (Object)Float.valueOf(tag.method_10583("forward")));
        this.method_5841().method_12778(SIDE, (Object)Float.valueOf(tag.method_10583("side")));
        this.method_5841().method_12778(UP, (Object)Float.valueOf(tag.method_10583("up")));
        this.method_5841().method_12778(X_OFF, (Object)Float.valueOf(tag.method_10583("xOff")));
        this.method_5841().method_12778(X_OFF_MOD, (Object)Float.valueOf(tag.method_10583("xOffMod")));
        this.method_5841().method_12778(X_OFF_MOD_A, (Object)Float.valueOf(tag.method_10583("xOffModA")));
        this.method_5841().method_12778(Y_OFF, (Object)Float.valueOf(tag.method_10583("yOff")));
        this.method_5841().method_12778(Y_OFF_MOD, (Object)Float.valueOf(tag.method_10583("yOffMod")));
        this.method_5841().method_12778(Y_OFF_MOD_A, (Object)Float.valueOf(tag.method_10583("yOffModA")));
        this.method_5841().method_12778(X_ROT_MAIN, (Object)Float.valueOf(tag.method_10583("xRotMain")));
        this.method_5841().method_12778(X_ROT, (Object)Float.valueOf(tag.method_10583("xRot")));
        this.method_5841().method_12778(X_MOD, (Object)Float.valueOf(tag.method_10583("xMod")));
        this.method_5841().method_12778(X_MOD_A, (Object)Float.valueOf(tag.method_10583("xModA")));
        this.method_5841().method_12778(Y_ROT_MAIN, (Object)Float.valueOf(tag.method_10583("yRotMain")));
        this.method_5841().method_12778(Y_ROT, (Object)Float.valueOf(tag.method_10583("yRot")));
        this.method_5841().method_12778(Y_MOD, (Object)Float.valueOf(tag.method_10583("yMod")));
        this.method_5841().method_12778(Y_MOD_A, (Object)Float.valueOf(tag.method_10583("yModA")));
        this.method_5841().method_12778(Z_ROT, (Object)Float.valueOf(tag.method_10583("zRot")));
        this.method_5841().method_12778(Z_MOD, (Object)Float.valueOf(tag.method_10583("zMod")));
        this.method_5841().method_12778(Z_MOD_A, (Object)Float.valueOf(tag.method_10583("zModA")));
        this.method_5841().method_12778(SCALE, (Object)Float.valueOf(tag.method_10583("scale")));
        this.method_5841().method_12778(SCALE_MOD, (Object)Float.valueOf(tag.method_10583("scaleMod")));
        this.method_5841().method_12778(SCALE_MOD_A, (Object)Float.valueOf(tag.method_10583("scaleModA")));
        this.method_5841().method_12778(ALPHA, (Object)Float.valueOf(tag.method_10583("alpha")));
        this.method_5841().method_12778(ALPHA_MOD, (Object)Float.valueOf(tag.method_10583("alphaMod")));
        this.method_5841().method_12778(ALPHA_MOD_A, (Object)Float.valueOf(tag.method_10583("alphaModA")));
        this.method_5841().method_12778(OWNER_UUID, Optional.of(tag.method_25926("ownerUUID")));
        this.method_5841().method_12778(OWNER_ID, (Object)tag.method_10550("ownerID"));
        this.method_5841().method_12778(BOUND_POS, (Object)tag.method_10577("boundPos"));
        this.method_5841().method_12778(BOUND_ROT, (Object)tag.method_10577("boundRot"));
        this.method_5841().method_12778(AGE, (Object)tag.method_10550("age"));
        this.method_5841().method_12778(ANIMATED, (Object)tag.method_10577("animated"));
        this.method_5841().method_12778(FRAMES, (Object)tag.method_10550("frames"));
        this.method_5841().method_12778(FRAME_TIME, (Object)tag.method_10550("frameTime"));
        this.method_5841().method_12778(TEXTURE_LOC, (Object)tag.method_10558("textureLoc"));
        this.method_5841().method_12778(TEXTURE_NAME, (Object)tag.method_10558("textureName"));
        this.method_5841().method_12778(RENDER_TYPE, (Object)tag.method_10550("renderType"));
    }

    public void method_5773() {
        this.xOffLerp = this.xOff;
        this.yOffLerp = this.yOff;
        this.xRotLerp = this.xRot;
        this.yRotLerp = this.yRot;
        this.zRotLerp = this.zRot;
        this.scaleLerp = this.scale;
        this.alphaLerp = this.alpha;
        this.xOff = ((Float)this.method_5841().method_12789(X_OFF)).floatValue();
        this.yOff = ((Float)this.method_5841().method_12789(Y_OFF)).floatValue();
        this.xRot = ((Float)this.method_5841().method_12789(X_ROT)).floatValue();
        this.yRot = ((Float)this.method_5841().method_12789(Y_ROT)).floatValue();
        this.zRot = ((Float)this.method_5841().method_12789(Z_ROT)).floatValue();
        this.scale = ((Float)this.method_5841().method_12789(SCALE)).floatValue();
        this.alpha = ((Float)this.method_5841().method_12789(ALPHA)).floatValue();
        if (!this.created) {
            this.xOffLerp = this.xOff;
            this.yOffLerp = this.yOff;
            this.xRotLerp = this.xRot;
            this.yRotLerp = this.yRot;
            this.zRotLerp = this.zRot;
            this.scaleLerp = this.scale;
            this.alphaLerp = this.alpha;
            this.created = true;
            this.method_5773();
        } else {
            this.action.accept(this);
        }
        if (!this.method_37908().method_8608()) {
            UUID ownerUUID;
            class_3218 server;
            class_1297 owner;
            this.method_5841().method_12778(AGE, (Object)((Integer)this.method_5841().method_12789(AGE) + 1));
            if ((Integer)this.method_5841().method_12789(AGE) >= (Integer)this.method_5841().method_12789(LIFETIME)) {
                this.method_31472();
            }
            this.method_5841().method_12778(X_OFF, (Object)Float.valueOf(((Float)this.method_5841().method_12789(X_OFF)).floatValue() + ((Float)this.method_5841().method_12789(X_OFF_MOD)).floatValue()));
            this.method_5841().method_12778(Y_OFF, (Object)Float.valueOf(((Float)this.method_5841().method_12789(Y_OFF)).floatValue() + ((Float)this.method_5841().method_12789(Y_OFF_MOD)).floatValue()));
            this.method_5841().method_12778(X_ROT, (Object)Float.valueOf(((Float)this.method_5841().method_12789(X_ROT)).floatValue() + ((Float)this.method_5841().method_12789(X_MOD)).floatValue()));
            this.method_5841().method_12778(Y_ROT, (Object)Float.valueOf(((Float)this.method_5841().method_12789(Y_ROT)).floatValue() + ((Float)this.method_5841().method_12789(Y_MOD)).floatValue()));
            this.method_5841().method_12778(Z_ROT, (Object)Float.valueOf(((Float)this.method_5841().method_12789(Z_ROT)).floatValue() + ((Float)this.method_5841().method_12789(Z_MOD)).floatValue()));
            this.method_5841().method_12778(SCALE, (Object)Float.valueOf(((Float)this.method_5841().method_12789(SCALE)).floatValue() + ((Float)this.method_5841().method_12789(SCALE_MOD)).floatValue()));
            this.method_5841().method_12778(ALPHA, (Object)Float.valueOf(((Float)this.method_5841().method_12789(ALPHA)).floatValue() + ((Float)this.method_5841().method_12789(ALPHA_MOD)).floatValue()));
            this.method_5841().method_12778(X_OFF_MOD, (Object)Float.valueOf(((Float)this.method_5841().method_12789(X_OFF_MOD)).floatValue() + ((Float)this.method_5841().method_12789(X_OFF_MOD_A)).floatValue()));
            this.method_5841().method_12778(Y_OFF_MOD, (Object)Float.valueOf(((Float)this.method_5841().method_12789(Y_OFF_MOD)).floatValue() + ((Float)this.method_5841().method_12789(Y_OFF_MOD_A)).floatValue()));
            this.method_5841().method_12778(X_MOD, (Object)Float.valueOf(((Float)this.method_5841().method_12789(X_MOD)).floatValue() + ((Float)this.method_5841().method_12789(X_MOD_A)).floatValue()));
            this.method_5841().method_12778(Y_MOD, (Object)Float.valueOf(((Float)this.method_5841().method_12789(Y_MOD)).floatValue() + ((Float)this.method_5841().method_12789(Y_MOD_A)).floatValue()));
            this.method_5841().method_12778(Z_MOD, (Object)Float.valueOf(((Float)this.method_5841().method_12789(Z_MOD)).floatValue() + ((Float)this.method_5841().method_12789(Z_MOD_A)).floatValue()));
            this.method_5841().method_12778(SCALE_MOD, (Object)Float.valueOf(((Float)this.method_5841().method_12789(SCALE_MOD)).floatValue() + ((Float)this.method_5841().method_12789(SCALE_MOD_A)).floatValue()));
            this.method_5841().method_12778(ALPHA_MOD, (Object)Float.valueOf(((Float)this.method_5841().method_12789(ALPHA_MOD)).floatValue() + ((Float)this.method_5841().method_12789(ALPHA_MOD_A)).floatValue()));
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218 && (owner = (server = (class_3218)class_19372).method_14190(ownerUUID = ((Optional)this.method_5841().method_12789(OWNER_UUID)).orElse(BLANK_OWNER))) != null) {
                this.method_5841().method_12778(OWNER_ID, (Object)owner.method_5628());
            }
            class_1297 owner2 = this.getOwner();
            if (((Boolean)this.method_5841().method_12789(BOUND_POS)).booleanValue() && owner2 != null) {
                this.method_33574(this.getRelativePos(owner2));
            }
        } else if (((Boolean)this.method_5841().method_12789(ANIMATED)).booleanValue()) {
            ++this.frameTime;
            if (this.frameTime >= (Integer)this.method_5841().method_12789(FRAME_TIME)) {
                this.frameTime = 0;
                ++this.frame;
                if (this.frame > (Integer)this.method_5841().method_12789(FRAMES)) {
                    this.frame = 1;
                }
            }
        }
        super.method_5773();
    }

    public int getAge() {
        return (Integer)this.method_5841().method_12789(AGE);
    }

    public int getLifeTime() {
        return (Integer)this.method_5841().method_12789(LIFETIME);
    }

    @Nullable
    public class_1297 getOwner() {
        return this.method_37908().method_8469(((Integer)this.method_5841().method_12789(OWNER_ID)).intValue());
    }

    public class_243 getRelativePos(class_1297 entity) {
        class_243 pos = entity.method_19538();
        return new class_243(pos.field_1352 + Math.cos(Math.toRadians(entity.method_5791() + 90.0f + ((Float)this.method_5841().method_12789(SIDE)).floatValue())) * (double)((Float)this.method_5841().method_12789(FORWARD)).floatValue(), pos.field_1351 + (double)((Float)this.method_5841().method_12789(UP)).floatValue(), pos.field_1350 + Math.sin(Math.toRadians(entity.method_5791() + 90.0f + ((Float)this.method_5841().method_12789(SIDE)).floatValue())) * (double)((Float)this.method_5841().method_12789(FORWARD)).floatValue());
    }

    public class_2960 getTexture() {
        if (((Boolean)this.method_5841().method_12789(ANIMATED)).booleanValue()) {
            return new class_2960((String)this.method_5841().method_12789(TEXTURE_LOC), "textures/vfx/" + (String)this.method_5841().method_12789(TEXTURE_NAME) + "_" + this.frame + ".png");
        }
        return new class_2960((String)this.method_5841().method_12789(TEXTURE_LOC), "textures/vfx/" + (String)this.method_5841().method_12789(TEXTURE_NAME) + ".png");
    }

    public float getXOff(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.xOffLerp, (float)this.xOff);
    }

    public float getYOff(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.yOffLerp, (float)this.yOff);
    }

    public float getXRotMain() {
        return ((Float)this.method_5841().method_12789(X_ROT_MAIN)).floatValue();
    }

    public float getYRotMain() {
        return ((Float)this.method_5841().method_12789(Y_ROT_MAIN)).floatValue();
    }

    public float getXRot(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.xRotLerp, (float)this.xRot);
    }

    public float getYRot(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.yRotLerp, (float)this.yRot);
    }

    public float getZRot(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.zRotLerp, (float)this.zRot);
    }

    public float getScale(float partialTicks) {
        return Math.max(0.0f, class_3532.method_16439((float)partialTicks, (float)this.scaleLerp, (float)this.scale));
    }

    public float getAlpha(float partialTicks) {
        return Math.min(1.0f, Math.max(0.0f, class_3532.method_16439((float)partialTicks, (float)this.alphaLerp, (float)this.alpha)));
    }

    public int getRenderType() {
        return (Integer)this.method_5841().method_12789(RENDER_TYPE);
    }

    public class_238 method_5830() {
        return this.method_5829().method_1014(10.0);
    }

    public static class Builder {
        private final int lifetime;
        private float x;
        private float y;
        private float z;
        private float forward;
        private float side;
        private float up;
        private float xRotMain;
        private float yRotMain;
        private float xRot;
        private float yRot;
        private float zRot;
        private float xOff;
        private float xOffMod;
        private float xOffModA;
        private float yOff;
        private float yOffMod;
        private float yOffModA;
        private float xMod;
        private float yMod;
        private float zMod;
        private float xModA;
        private float yModA;
        private float zModA;
        private float scaleMod;
        private float scaleModA;
        private float alphaMod;
        private float alphaModA;
        private float scale;
        private float alpha = 1.0f;
        @Nullable
        private class_1297 owner = null;
        private boolean boundPos;
        private boolean boundRot;
        private boolean animated = false;
        private int frames = 1;
        private int frameTime = 20;
        private String textureLoc = "obscure_api";
        private String textureName = "blank";
        private int renderType;
        private Consumer<TextureFX> action = textureFX -> {};
        @Nullable
        private class_3414 sound = null;
        private float volume;
        private float pitch = 1.0f;

        private Builder(int lifetime) {
            this.lifetime = lifetime;
        }

        @Contract(value="_ -> new", pure=true)
        public static Builder create(int lifetime) {
            return new Builder(lifetime);
        }

        public Builder pos(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder pos(class_243 pos) {
            this.x = (float)pos.field_1352;
            this.y = (float)pos.field_1351;
            this.z = (float)pos.field_1350;
            return this;
        }

        public Builder pos(double x, double y, double z) {
            this.x = (float)x;
            this.y = (float)y;
            this.z = (float)z;
            return this;
        }

        public Builder relativePos(class_1309 entity, float forward, float left, float up) {
            class_243 pos = EntityUtils.getRelativePos((class_1297)entity, forward, left, up);
            this.x = (float)pos.field_1352;
            this.y = (float)pos.field_1351;
            this.z = (float)pos.field_1350;
            return this;
        }

        public Builder moveForward(float offset, float mod2, float modA) {
            this.xOff = offset * -1.0f;
            this.xOffMod = mod2 * -1.0f;
            this.xOffModA = modA * -1.0f;
            return this;
        }

        public Builder moveUp(float offset, float mod2, float modA) {
            this.yOff = offset * -1.0f;
            this.yOffMod = mod2 * -1.0f;
            this.yOffModA = modA * -1.0f;
            return this;
        }

        public Builder xRot(float rot, float mod2, float modA) {
            this.xRot += rot;
            this.xMod = mod2;
            this.xModA = modA;
            return this;
        }

        public Builder yRot(float rot, float mod2, float modA) {
            this.yRot += rot;
            this.yMod = mod2;
            this.yModA = modA;
            return this;
        }

        public Builder zRot(float rot, float mod2, float modA) {
            this.zRot += rot;
            this.zMod = mod2;
            this.zModA = modA;
            return this;
        }

        public Builder mainRot(float xRot, float yRot) {
            if (xRot != 0.0f) {
                this.xRotMain = xRot;
            }
            if (yRot != 0.0f) {
                this.yRotMain = yRot;
            }
            return this;
        }

        public Builder relativeRot(class_1309 entity, boolean x, boolean y) {
            if (x) {
                this.xRotMain = entity.method_5695(1.0f);
            }
            if (y) {
                this.yRotMain = entity.method_5705(1.0f) - 90.0f;
            }
            return this;
        }

        public Builder scale(float scale, float mod2, float modA) {
            this.scale = scale;
            this.scaleMod = mod2;
            this.scaleModA = modA;
            return this;
        }

        public Builder alpha(float alpha, float mod2, float modA) {
            this.alpha = alpha;
            this.alphaMod = mod2;
            this.alphaModA = modA;
            return this;
        }

        public Builder owner(class_1297 owner) {
            this.owner = owner;
            return this;
        }

        public Builder boundPos(boolean flag, float relativeFront, float relativeSide, float relativeUp) {
            this.boundPos = flag;
            this.forward = relativeFront;
            this.side = relativeSide;
            this.up = relativeUp;
            return this;
        }

        public Builder boundRot(boolean flag) {
            this.boundRot = flag;
            return this;
        }

        public Builder texture(String modID, String name) {
            this.textureLoc = modID;
            this.textureName = name;
            return this;
        }

        public Builder animatedTexture(String modID, String name, int frames, int frameTime) {
            this.animated = true;
            this.textureLoc = modID;
            this.textureName = name;
            this.frames = frames;
            this.frameTime = frameTime;
            return this;
        }

        public Builder render(RenderType type) {
            this.renderType = type.getValue();
            return this;
        }

        public Builder sound(class_3414 sound, float volume, float pitch) {
            this.sound = sound;
            this.volume = volume;
            this.pitch = pitch;
            return this;
        }

        public Builder action(Consumer<TextureFX> action) {
            this.action = action;
            return this;
        }

        public void build(class_1937 level) {
            if (!level.method_8608()) {
                new TextureFX(this, level);
            }
        }

        public static enum RenderType {
            TRANSLUCENT_EMISSIVE(0),
            EYES(1),
            END_GATEWAY(2),
            END_PORTAL(3);

            private final int VALUE;

            private RenderType(int value) {
                this.VALUE = value;
            }

            public int getValue() {
                return this.VALUE;
            }
        }
    }
}

