/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.mixin.attributes;

import com.obscuria.obscureapi.registry.ObscureAPIAttributes;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_5132;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class}, priority=0)
public abstract class LivingEntityMixin {
    @Unique
    private class_1282 sourceDamage;
    @Unique
    private class_1282 sourceApplyArmorToDamage;

    @Inject(method={"damage"}, at={@At(value="HEAD")})
    private void saveSource(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        this.sourceDamage = source;
    }

    @Inject(method={"applyArmorToDamage"}, at={@At(value="HEAD")})
    private void saveArmorSource(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        this.sourceApplyArmorToDamage = source;
    }

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void parryAndDodge(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 living;
        class_1309 attacker;
        class_1309 entity = (class_1309)this;
        class_1297 class_12972 = source.method_5529();
        class_1309 class_13092 = attacker = class_12972 instanceof class_1309 ? (living = (class_1309)class_12972) : null;
        if (attacker == null || entity.field_6008 > 10) {
            return;
        }
        float accuracy = ObscureAPIAttributes.getAccuracy(attacker);
        float parry = ObscureAPIAttributes.getParry(entity);
        float dodge = ObscureAPIAttributes.getDodge(entity);
        if (Math.random() <= (double)(parry - accuracy)) {
            cir.setReturnValue((Object)false);
            entity.field_6008 = 20;
            attacker.method_5643(attacker.method_48923().method_48812(entity), amount);
            return;
        }
        if (Math.random() <= (double)(dodge - accuracy)) {
            cir.setReturnValue((Object)false);
            entity.field_6008 = 20;
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    private float criticalHitAndMagicResistance(float amount) {
        class_1309 living;
        class_1309 attacker;
        if (this.sourceDamage == null) {
            return amount;
        }
        class_1309 entity = (class_1309)this;
        class_1297 class_12972 = this.sourceDamage.method_5529();
        class_1309 class_13092 = attacker = class_12972 instanceof class_1309 ? (living = (class_1309)class_12972) : null;
        if (attacker == null) {
            return amount;
        }
        if (!this.sourceDamage.method_49708(class_8111.field_42349)) {
            double criticalHit = ObscureAPIAttributes.getCriticalHit(attacker);
            double criticalDamage = ObscureAPIAttributes.getCriticalDamage(attacker);
            double resilience = ObscureAPIAttributes.getResilience(entity);
            if (Math.random() <= criticalHit - resilience) {
                float criticalAmount = amount * (float)criticalDamage * (float)(1.0 - resilience);
                return Math.max(criticalAmount, amount);
            }
        } else {
            return amount * (1.0f - ObscureAPIAttributes.getMagicResistance(entity));
        }
        return amount;
    }

    @Redirect(method={"applyArmorToDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/DamageUtil;getDamageLeft(FFF)F"))
    private float penetration(float damage, float armor, float armorToughness) {
        float f;
        if (this.sourceApplyArmorToDamage == null) {
            return class_1280.method_5496((float)damage, (float)armor, (float)armorToughness);
        }
        class_1297 class_12972 = this.sourceApplyArmorToDamage.method_5526();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            f = ObscureAPIAttributes.getPenetration(living);
        } else {
            f = 0.0f;
        }
        float penetration = f;
        return class_1280.method_5496((float)damage, (float)(armor * (1.0f - penetration)), (float)(armorToughness * (1.0f - penetration)));
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void regeneration(CallbackInfo ci) {
        float regeneration;
        class_1309 entity = (class_1309)this;
        if (!entity.method_37908().method_8608() && (regeneration = ObscureAPIAttributes.getRegeneration(entity)) > 0.0f && (float)entity.field_6012 % (410.0f - 10.0f * regeneration) == 0.0f) {
            entity.method_6025(1.0f);
        }
    }

    @ModifyVariable(method={"heal"}, at=@At(value="HEAD"), argsOnly=true)
    private float healPower(float amount) {
        return amount * ObscureAPIAttributes.getHealingPower((class_1309)this);
    }

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static void registerAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(ObscureAPIAttributes.CRITICAL_HIT).method_26867(ObscureAPIAttributes.CRITICAL_DAMAGE).method_26867(ObscureAPIAttributes.DODGE).method_26867(ObscureAPIAttributes.PARRY).method_26867(ObscureAPIAttributes.ACCURACY).method_26867(ObscureAPIAttributes.MAGIC_RESISTANCE).method_26867(ObscureAPIAttributes.PENETRATION).method_26867(ObscureAPIAttributes.REGENERATION).method_26867(ObscureAPIAttributes.HEALING_POWER).method_26867(ObscureAPIAttributes.RESILIENCE);
    }
}

