/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2405;
import net.minecraft.class_2444;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeProvider
extends class_2446 {
    private final String modId;

    public AbstractRecipeProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractRecipeProvider(String modId, class_7784 packOutput) {
        super(packOutput);
        this.modId = modId;
    }

    @Nullable
    private static <T> JsonElement searchAndReplaceValue(@Nullable JsonElement jsonElement, T searchFor, T replaceWith) {
        block10: {
            block11: {
                Objects.requireNonNull(searchFor, "search for is null");
                Objects.requireNonNull(replaceWith, "replace with is null");
                if (jsonElement == null || jsonElement.isJsonNull()) break block10;
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                    if (jsonPrimitive.isNumber()) {
                        if (searchFor.equals(jsonPrimitive.getAsNumber())) {
                            return new JsonPrimitive((Number)replaceWith);
                        }
                    } else if (jsonPrimitive.isBoolean()) {
                        if (searchFor.equals(jsonPrimitive.getAsBoolean())) {
                            return new JsonPrimitive((Boolean)replaceWith);
                        }
                    } else if (jsonPrimitive.isString() && searchFor.toString().equals(jsonPrimitive.getAsString())) {
                        return new JsonPrimitive(replaceWith.toString());
                    }
                    return jsonElement;
                }
                if (!jsonElement.isJsonArray()) break block11;
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    jsonArray.set(i, AbstractRecipeProvider.searchAndReplaceValue(jsonArray.get(i), searchFor, replaceWith));
                }
                break block10;
            }
            if (!jsonElement.isJsonObject()) break block10;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                entry.setValue(AbstractRecipeProvider.searchAndReplaceValue((JsonElement)entry.getValue(), searchFor, replaceWith));
            }
        }
        return jsonElement;
    }

    protected static String getHasName(class_1935 item, class_1935 ... items) {
        return "has_" + Stream.concat(Stream.of(item), Stream.of(items)).map(class_2446::method_33716).collect(Collectors.joining("_and_"));
    }

    protected static class_2066.class_2068 has(class_1935 item, class_1935 ... items) {
        return AbstractRecipeProvider.method_10423((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8977((class_1935[])Stream.concat(Stream.of(item), Stream.of(items)).toArray(class_1935[]::new)).method_8976()});
    }

    public CompletableFuture<?> method_10319(class_7403 output) {
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.method_10419(finishedRecipe -> {
            class_2960 id = new class_2960(this.modId, finishedRecipe.method_10417().method_12832());
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(id));
            }
            list.add(class_2405.method_10320((class_7403)output, (JsonElement)finishedRecipe.method_17799(), (Path)this.field_39378.method_44107(id)));
            JsonObject jsonElement = finishedRecipe.method_10415();
            if (jsonElement != null) {
                jsonElement = AbstractRecipeProvider.searchAndReplaceValue((JsonElement)jsonElement, finishedRecipe.method_10417(), id);
                class_2960 advancementId = new class_2960(this.modId, finishedRecipe.method_10418().method_12832());
                list.add(class_2405.method_10320((class_7403)output, (JsonElement)jsonElement, (Path)this.field_39379.method_44107(advancementId)));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public final void method_10419(Consumer<class_2444> exporter) {
        this.addRecipes(exporter);
    }

    public abstract void addRecipes(Consumer<class_2444> var1);
}

