/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.simplerpc.jodd.http;

import com.hypherionmc.simplerpc.jodd.http.HttpProgressListener;
import com.hypherionmc.simplerpc.jodd.http.upload.Uploadable;
import com.hypherionmc.simplerpc.jodd.io.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;

public class Buffer {
    protected LinkedList<Object> list = new LinkedList();
    protected ByteArrayOutputStream last;
    protected int size;

    public Buffer append(String string) {
        this.ensureLast();
        byte[] bytes = string.getBytes(StandardCharsets.ISO_8859_1);
        this.last.write(bytes, 0, bytes.length);
        this.size += bytes.length;
        return this;
    }

    public Buffer append(char c) {
        this.append(Character.toString(c));
        return this;
    }

    public Buffer append(int number) {
        this.append(Integer.toString(number));
        return this;
    }

    public Buffer append(Uploadable uploadable) {
        this.list.add(uploadable);
        this.size += uploadable.getSize();
        this.last = null;
        return this;
    }

    public Buffer append(Buffer buffer) {
        if (buffer.list.isEmpty()) {
            return buffer;
        }
        this.list.addAll(buffer.list);
        this.last = buffer.last;
        this.size += buffer.size;
        return this;
    }

    public int size() {
        return this.size;
    }

    private void ensureLast() {
        if (this.last == null) {
            this.last = new ByteArrayOutputStream();
            this.list.add(this.last);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Writer writer) throws IOException {
        for (Object e : this.list) {
            if (e instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)e;
                byte[] array = baos.toByteArray();
                writer.write(new String(array, StandardCharsets.ISO_8859_1));
                continue;
            }
            if (!(e instanceof Uploadable)) continue;
            Uploadable uploadable = (Uploadable)e;
            InputStream inputStream = uploadable.openInputStream();
            try {
                IOUtil.copy(inputStream, writer, StandardCharsets.ISO_8859_1);
            }
            finally {
                IOUtil.close(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        for (Object e : this.list) {
            if (e instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream arrays = (ByteArrayOutputStream)e;
                out.write(arrays.toByteArray());
                continue;
            }
            if (!(e instanceof Uploadable)) continue;
            Uploadable uploadable = (Uploadable)e;
            InputStream inputStream = uploadable.openInputStream();
            try {
                IOUtil.copy(inputStream, out);
            }
            finally {
                IOUtil.close(inputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out, HttpProgressListener progressListener) throws IOException {
        int size = this.size();
        int callbackSize = progressListener.callbackSize(size);
        int count = 0;
        int step = 0;
        progressListener.transferred(count);
        for (Object e : this.list) {
            int chunk;
            if (e instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream baos = (ByteArrayOutputStream)e;
                byte[] bytes = baos.toByteArray();
                int offset = 0;
                while (offset < bytes.length) {
                    chunk = callbackSize - step;
                    if (offset + chunk > bytes.length) {
                        chunk = bytes.length - offset;
                    }
                    out.write(bytes, offset, chunk);
                    offset += chunk;
                    count += chunk;
                    if ((step += chunk) < callbackSize) continue;
                    progressListener.transferred(count);
                    step -= callbackSize;
                }
                continue;
            }
            if (!(e instanceof Uploadable)) continue;
            Uploadable uploadable = (Uploadable)e;
            InputStream inputStream = uploadable.openInputStream();
            int remaining = uploadable.getSize();
            try {
                while (remaining > 0) {
                    chunk = callbackSize - step;
                    if (chunk > remaining) {
                        chunk = remaining;
                    }
                    IOUtil.copy(inputStream, out, chunk);
                    remaining -= chunk;
                    count += chunk;
                    if ((step += chunk) < callbackSize) continue;
                    progressListener.transferred(count);
                    step -= callbackSize;
                }
            }
            finally {
                IOUtil.close(inputStream);
            }
        }
        if (step != 0) {
            progressListener.transferred(count);
        }
    }
}

