/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.api;

import draylar.tiered.api.AttributeTemplate;
import draylar.tiered.api.TieredItemTags;
import elocindev.tierify.Tierify;
import elocindev.tierify.compat.ItemBordersCompat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.stats.Skill;
import net.libz.util.SortList;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ModifierUtils {
    @Nullable
    public static class_2960 getRandomAttributeIDFor(@Nullable class_1657 playerEntity, class_1792 item, boolean reforge) {
        int i;
        ArrayList potentialAttributes = new ArrayList();
        ArrayList<Integer> attributeWeights = new ArrayList<Integer>();
        Tierify.ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
            if (attribute.isValid(class_7923.field_41178.method_10221((Object)item)) && (attribute.getWeight() > 0 || reforge)) {
                potentialAttributes.add(new class_2960(attribute.getID()));
                attributeWeights.add(reforge ? attribute.getWeight() + 1 : attribute.getWeight());
            }
        });
        if (potentialAttributes.size() <= 0) {
            return null;
        }
        if (reforge && attributeWeights.size() > 2) {
            SortList.concurrentSort(attributeWeights, (List[])new List[]{attributeWeights, potentialAttributes});
            int maxWeight = (Integer)attributeWeights.get(attributeWeights.size() - 1);
            for (i = 0; i < attributeWeights.size(); ++i) {
                if ((Integer)attributeWeights.get(i) <= maxWeight / 2) continue;
                attributeWeights.set(i, (int)((float)((Integer)attributeWeights.get(i)).intValue() * Tierify.CONFIG.reforgeModifier));
            }
        }
        if (Tierify.isLevelZLoaded && playerEntity != null) {
            int newMaxWeight = (Integer)Collections.max(attributeWeights);
            for (i = 0; i < attributeWeights.size(); ++i) {
                if ((Integer)attributeWeights.get(i) <= newMaxWeight / 3) continue;
                attributeWeights.set(i, (int)((float)((Integer)attributeWeights.get(i)).intValue() * (1.0f - Tierify.CONFIG.levelzReforgeModifier * (float)((PlayerStatsManagerAccess)playerEntity).getPlayerStatsManager().getSkillLevel(Skill.SMITHING))));
            }
        }
        if (playerEntity != null) {
            int luckMaxWeight = (Integer)Collections.max(attributeWeights);
            for (i = 0; i < attributeWeights.size(); ++i) {
                if ((Integer)attributeWeights.get(i) <= luckMaxWeight / 3) continue;
                attributeWeights.set(i, (int)((float)((Integer)attributeWeights.get(i)).intValue() * (1.0f - Tierify.CONFIG.luckReforgeModifier * playerEntity.method_7292())));
            }
        }
        if (potentialAttributes.size() > 0) {
            int totalWeight = 0;
            for (Integer weight : attributeWeights) {
                totalWeight += weight.intValue();
            }
            int randomChoice = new Random().nextInt(totalWeight);
            SortList.concurrentSort(attributeWeights, (List[])new List[]{attributeWeights, potentialAttributes});
            for (int i2 = 0; i2 < attributeWeights.size(); ++i2) {
                if (randomChoice < (Integer)attributeWeights.get(i2)) {
                    return (class_2960)potentialAttributes.get(i2);
                }
                randomChoice -= ((Integer)attributeWeights.get(i2)).intValue();
            }
            return (class_2960)potentialAttributes.get(new Random().nextInt(potentialAttributes.size()));
        }
        return null;
    }

    public static List<class_2960> getAttributeIDsForQuality(String quality, class_1792 item) {
        ArrayList<class_2960> matchingAttributes = new ArrayList<class_2960>();
        Tierify.ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
            if (attribute.isValid(class_7923.field_41178.method_10221((Object)item)) && id.toString().contains(quality.toLowerCase())) {
                matchingAttributes.add((class_2960)id);
            }
        });
        return matchingAttributes;
    }

    public static class_2960 getRandomAttributeForQuality(List<String> qualities, class_1792 item, boolean reforge) {
        ArrayList matchingAttributes = new ArrayList();
        ArrayList matchingAttributeWeights = new ArrayList();
        Tierify.ATTRIBUTE_DATA_LOADER.getItemAttributes().forEach((id, attribute) -> {
            if (attribute.isValid(class_7923.field_41178.method_10221((Object)item)) && qualities.stream().anyMatch(quality -> id.toString().contains(quality.toLowerCase())) && (attribute.getWeight() > 0 || reforge)) {
                matchingAttributes.add(id);
                matchingAttributeWeights.add(reforge ? attribute.getWeight() + 1 : attribute.getWeight());
            }
        });
        if (matchingAttributes.isEmpty()) {
            return null;
        }
        int totalWeight = matchingAttributeWeights.stream().mapToInt(Integer::intValue).sum();
        int randomIndex = new Random().nextInt(totalWeight);
        for (int i = 0; i < matchingAttributes.size(); ++i) {
            if ((randomIndex -= ((Integer)matchingAttributeWeights.get(i)).intValue()) >= 0) continue;
            return (class_2960)matchingAttributes.get(i);
        }
        return null;
    }

    public static void setItemStackAttribute(class_2960 potentialAttributeID, class_1799 stack) {
        if (potentialAttributeID != null) {
            stack.method_7911("Tiered").method_10582("Tier", potentialAttributeID.toString());
            stack.method_7911("itemborders_colors").method_10582("top", ItemBordersCompat.getColorForIdentifier(potentialAttributeID));
            stack.method_7911("itemborders_colors").method_10582("bottom", ItemBordersCompat.getColorForIdentifier(potentialAttributeID));
            HashMap<String, Object> nbtMap = Tierify.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(new class_2960(potentialAttributeID.toString())).getNbtValues();
            List<AttributeTemplate> attributeList = Tierify.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(new class_2960(potentialAttributeID.toString())).getAttributes();
            for (int i = 0; i < attributeList.size(); ++i) {
                if (!attributeList.get(i).getAttributeTypeID().equals("tiered:generic.durable")) continue;
                if (nbtMap == null) {
                    nbtMap = new HashMap();
                }
                nbtMap.put("durable", (double)Math.round(attributeList.get(i).getEntityAttributeModifier().method_6186() * 100.0) / 100.0);
                break;
            }
            if (nbtMap != null) {
                class_2487 nbtCompound = stack.method_7969();
                for (Map.Entry<String, Object> entry : nbtMap.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        nbtCompound.method_10582(key, (String)value);
                        continue;
                    }
                    if (value instanceof Boolean) {
                        nbtCompound.method_10556(key, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (!(value instanceof Double)) continue;
                    if (Math.abs((Double)value) % 1.0 < 1.0E-4) {
                        nbtCompound.method_10569(key, (int)Math.round((Double)value));
                        continue;
                    }
                    nbtCompound.method_10549(key, (double)Math.round((Double)value * 100.0) / 100.0);
                }
                stack.method_7980(nbtCompound);
            }
        }
    }

    public static void setItemStackAttribute(@Nullable class_1657 playerEntity, class_1799 stack, boolean reforge, class_1799 reforgeMaterial) {
        if (reforge && reforgeMaterial != null) {
            class_2960 possibleAttribute;
            ArrayList<String> qualities = null;
            if (reforgeMaterial.method_31573(TieredItemTags.TIER_1_ITEM)) {
                qualities = Tierify.CONFIG.tier_1_qualities;
            } else if (reforgeMaterial.method_31573(TieredItemTags.TIER_2_ITEM)) {
                qualities = Tierify.CONFIG.tier_2_qualities;
            } else if (reforgeMaterial.method_31573(TieredItemTags.TIER_3_ITEM)) {
                qualities = Tierify.CONFIG.tier_3_qualities;
            }
            if (qualities != null && (possibleAttribute = ModifierUtils.getRandomAttributeForQuality(qualities, stack.method_7909(), reforge)) != null) {
                ModifierUtils.setItemStackAttribute(possibleAttribute, stack);
                return;
            }
        }
        ModifierUtils.setItemStackAttribute(playerEntity, stack, reforge);
    }

    public static void setItemStackAttribute(@Nullable class_1657 playerEntity, class_1799 stack, boolean reforge) {
        if (stack.method_7941("Tiered") == null) {
            ModifierUtils.setItemStackAttribute(ModifierUtils.getRandomAttributeIDFor(playerEntity, stack.method_7909(), reforge), stack);
        }
    }

    public static void removeItemStackAttribute(class_1799 itemStack) {
        if (itemStack.method_7985() && itemStack.method_7941("Tiered") != null) {
            class_2960 tier = new class_2960(itemStack.method_7911("Tiered").method_10558("Tier"));
            if (Tierify.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier) != null) {
                int i;
                HashMap<String, Object> nbtMap = Tierify.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier).getNbtValues();
                ArrayList nbtKeys = new ArrayList();
                if (nbtMap != null) {
                    nbtKeys.addAll(nbtMap.keySet().stream().toList());
                }
                List<AttributeTemplate> attributeList = Tierify.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier).getAttributes();
                for (i = 0; i < attributeList.size(); ++i) {
                    if (!attributeList.get(i).getAttributeTypeID().equals("tiered:generic.durable")) continue;
                    nbtKeys.add("durable");
                    break;
                }
                if (!nbtKeys.isEmpty()) {
                    for (i = 0; i < nbtKeys.size(); ++i) {
                        if (((String)nbtKeys.get(i)).equals("Damage")) continue;
                        itemStack.method_7969().method_10551((String)nbtKeys.get(i));
                    }
                }
            }
            itemStack.method_7983("Tiered");
        }
    }

    @Nullable
    public static class_2960 getAttributeID(class_1799 itemStack) {
        if (itemStack.method_7941("Tiered") != null) {
            return new class_2960(itemStack.method_7941("Tiered").method_10558("Tier"));
        }
        return null;
    }
}

