/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.world.feature;

import com.yungnickyoung.minecraft.betterendisland.BetterEndIslandCommon;
import com.yungnickyoung.minecraft.betterendisland.world.IDragonFight;
import com.yungnickyoung.minecraft.betterendisland.world.processor.BlockReplaceProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.DragonEggProcessor;
import com.yungnickyoung.minecraft.betterendisland.world.processor.ObsidianProcessor;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_3218;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class BetterEndPodiumFeature
extends class_3031<class_3111> {
    private static final List<class_3491> PROCESSORS = List.of(new BlockReplaceProcessor(class_2246.field_10038.method_9564(), new BlockStateRandomizer(class_2246.field_9987.method_9564()), false, false, false, false), new DragonEggProcessor());
    private static final class_3491 ACTIVE_PORTAL_PROCESSOR = new BlockReplaceProcessor(class_2246.field_10058.method_9564(), new BlockStateRandomizer(class_2246.field_10027.method_9564()), false, false, false, false);
    private static final class_3491 INACTIVE_PORTAL_PROCESSOR = new BlockReplaceProcessor(class_2246.field_10058.method_9564(), new BlockStateRandomizer(class_2246.field_10124.method_9564()), false, false, false, false);
    private final boolean isInitialSpawn;
    private final boolean isBottomOnly;
    private final boolean isActive;

    public BetterEndPodiumFeature(boolean isInitialSpawn, boolean isBottomOnly, boolean isActive) {
        super(class_3111.field_24893);
        this.isInitialSpawn = isInitialSpawn;
        this.isBottomOnly = isBottomOnly;
        this.isActive = isActive;
    }

    public boolean method_13151(class_5821<class_3111> ctx) {
        class_3218 serverLevel;
        class_5281 level = ctx.method_33652();
        class_5819 randomSource = ctx.method_33654();
        class_2338 pos = ctx.method_33655();
        int numberTimesDragonKilled = 0;
        if (level instanceof class_3218 && (serverLevel = (class_3218)level).method_29198() != null) {
            numberTimesDragonKilled = ((IDragonFight)serverLevel.method_29198()).betterendisland$numTimesDragonKilled();
        }
        class_2960 template = this.chooseTemplate();
        boolean placed = this.placeTemplate((class_5425)level, randomSource, pos, class_2470.field_11467, template, numberTimesDragonKilled);
        if (this.isInitialSpawn) {
            class_2338 centerPos = pos.method_10086(6);
            for (class_2350 direction : class_2350.class_2353.field_11062) {
                class_2338 crystalPos = centerPos.method_10079(direction, 8);
                class_1511 crystal = new class_1511((class_1937)level, (double)crystalPos.method_10263() + 0.5, (double)crystalPos.method_10264(), (double)crystalPos.method_10260() + 0.5);
                crystal.method_6839(false);
                crystal.method_5684(true);
                level.method_8649((class_1297)crystal);
            }
        }
        return placed;
    }

    private class_2960 chooseTemplate() {
        if (this.isBottomOnly) {
            return new class_2960("betterendisland", "tower_bottom_open");
        }
        String towerType = this.isInitialSpawn ? "initial" : "broken";
        String towerName = "tower_" + towerType;
        return new class_2960("betterendisland", towerName);
    }

    private boolean placeTemplate(class_5425 level, class_5819 randomSource, class_2338 centerPos, class_2470 rotation, class_2960 id, int numberTimesDragonKilled) {
        Optional templateOptional = level.method_8410().method_14183().method_15094(id);
        if (templateOptional.isEmpty()) {
            BetterEndIslandCommon.LOGGER.warn("Failed to create invalid feature {}", (Object)id);
            return false;
        }
        class_3499 template = (class_3499)templateOptional.get();
        class_2338 cornerPos = centerPos.method_10069(-template.method_15160().method_10263() / 2, 0, -template.method_15160().method_10260() / 2);
        class_3492 structurePlaceSettings = new class_3492();
        PROCESSORS.forEach(arg_0 -> ((class_3492)structurePlaceSettings).method_16184(arg_0));
        if (this.isActive) {
            structurePlaceSettings.method_16184(ACTIVE_PORTAL_PROCESSOR);
        } else {
            structurePlaceSettings.method_16184(INACTIVE_PORTAL_PROCESSOR);
        }
        structurePlaceSettings.method_16184((class_3491)new ObsidianProcessor(numberTimesDragonKilled));
        structurePlaceSettings.method_15123(rotation);
        structurePlaceSettings.method_15119(this.isBottomOnly ? new class_2338(3, 0, 3) : new class_2338(14, 0, 14));
        template.method_15172(level, cornerPos, centerPos, structurePlaceSettings, randomSource, 2);
        return true;
    }
}

