/*
 * Decompiled with CFR 0.152.
 */
package mod.chloeprime.aaaparticles.api.common;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mod.chloeprime.aaaparticles.api.client.effekseer.ParticleEmitter;
import mod.chloeprime.aaaparticles.api.common.DynamicParameter;
import mod.chloeprime.aaaparticles.client.installer.NativePlatform;
import mod.chloeprime.aaaparticles.client.registry.EffectRegistry;
import mod.chloeprime.aaaparticles.common.network.S2CAddParticle;
import mod.chloeprime.aaaparticles.common.util.Basis;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;

public class ParticleEmitterInfo
implements Cloneable {
    public final class_2960 effek;
    public final class_2960 emitter;
    protected int flags;
    protected double x;
    protected double y;
    protected double z;
    protected float rotX;
    protected float rotY;
    protected float rotZ;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    protected float scaleZ = 1.0f;
    protected double esX;
    protected double esY;
    protected double esZ;
    protected int boundEntity;
    protected final List<DynamicParameter> parameters = new ArrayList<DynamicParameter>();
    protected final IntList triggers = new IntArrayList();
    private static final class_243 VEC3_ONES = new class_243(1.0, 1.0, 1.0);

    public static ParticleEmitterInfo create(class_1937 level, class_2960 location) {
        return level.method_8608() ? new ParticleEmitterInfo(location) : new S2CAddParticle(location);
    }

    public static ParticleEmitterInfo create(class_1937 level, class_2960 location, class_2960 emitterName) {
        return level.method_8608() ? new ParticleEmitterInfo(location, emitterName) : new S2CAddParticle(location, emitterName);
    }

    @ApiStatus.Internal
    public ParticleEmitterInfo(class_2960 effek) {
        this(effek, null);
    }

    @ApiStatus.Internal
    public ParticleEmitterInfo(class_2960 effek, class_2960 emitter) {
        this.effek = effek;
        this.emitter = emitter;
        if (emitter != null) {
            this.flags |= 1;
        }
    }

    public ParticleEmitterInfo clone() {
        try {
            return (ParticleEmitterInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean hasEmitter() {
        return (this.flags & 1) != 0;
    }

    public final boolean isPositionSet() {
        return (this.flags & 2) != 0;
    }

    public final boolean isRotationSet() {
        return (this.flags & 4) != 0;
    }

    public final boolean isScaleSet() {
        return (this.flags & 8) != 0;
    }

    public final boolean hasParameters() {
        return (this.flags & 0x80) != 0;
    }

    public final boolean hasTriggers() {
        return (this.flags & 0x100) != 0;
    }

    public final boolean hasBoundEntity() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean isEntitySpaceRelativePosSet() {
        return (this.flags & 0x20) != 0;
    }

    public final boolean usingEntityHeadSpace() {
        return (this.flags & 0x40) != 0;
    }

    public ParticleEmitterInfo position(class_243 pos) {
        return this.position(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public ParticleEmitterInfo position(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.flags |= 2;
        return this;
    }

    public ParticleEmitterInfo rotation(class_241 rot) {
        return this.rotation(rot.field_1343, rot.field_1342, 0.0f);
    }

    public ParticleEmitterInfo rotation(float x, float y, float z) {
        this.rotX = x;
        this.rotY = y;
        this.rotZ = z;
        this.flags |= 4;
        return this;
    }

    public ParticleEmitterInfo scale(float scale) {
        return this.scale(scale, scale, scale);
    }

    public ParticleEmitterInfo scale(float x, float y, float z) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
        this.flags |= 8;
        return this;
    }

    public ParticleEmitterInfo parameter(int index, float value) {
        this.parameters.add(new DynamicParameter(index, value));
        this.flags |= 0x80;
        return this;
    }

    public ParticleEmitterInfo trigger(int index) {
        this.triggers.add(index);
        this.flags |= 0x100;
        return this;
    }

    public ParticleEmitterInfo bindOnEntity(class_1297 entity) {
        this.boundEntity = entity.method_5628();
        this.flags |= 0x10;
        return this;
    }

    public ParticleEmitterInfo entitySpaceRelativePosition(class_243 pos) {
        return this.entitySpaceRelativePosition(pos.field_1352, pos.field_1351, pos.field_1350);
    }

    public ParticleEmitterInfo entitySpaceRelativePosition(double x, double y, double z) {
        this.esX = x;
        this.esY = y;
        this.esZ = z;
        this.flags |= 0x20;
        return this;
    }

    public ParticleEmitterInfo useEntityHeadSpace() {
        return this.useEntityHeadSpace(true);
    }

    public ParticleEmitterInfo useEntityHeadSpace(boolean value) {
        this.flags = value ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
        return this;
    }

    public final class_243 position() {
        return this.isPositionSet() ? new class_243(this.x, this.y, this.z) : class_243.field_1353;
    }

    public final class_243 rotation() {
        return this.isRotationSet() ? new class_243((double)this.rotX, (double)this.rotY, (double)this.rotZ) : class_243.field_1353;
    }

    public final class_243 scale() {
        return this.isScaleSet() ? new class_243((double)this.scaleX, (double)this.scaleY, (double)this.scaleZ) : VEC3_ONES;
    }

    public Optional<class_1297> getBoundEntity(class_1937 level) {
        return this.hasBoundEntity() ? Optional.ofNullable(level.method_8469(this.boundEntity)) : Optional.empty();
    }

    public void encode(class_2540 buf) {
        buf.method_10812(this.effek);
        buf.method_10804(this.flags);
        if (this.hasEmitter()) {
            buf.method_10812(this.emitter);
        }
        if (this.isPositionSet()) {
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
        }
        if (this.isRotationSet()) {
            buf.writeFloat(this.rotX);
            buf.writeFloat(this.rotY);
            buf.writeFloat(this.rotZ);
        }
        if (this.isScaleSet()) {
            buf.writeFloat(this.scaleX);
            buf.writeFloat(this.scaleY);
            buf.writeFloat(this.scaleZ);
        }
        if (this.hasParameters()) {
            buf.method_10804(this.parameters.size());
            this.parameters.forEach(param -> {
                buf.method_10804(param.index());
                buf.writeFloat(param.value());
            });
        }
        if (this.hasTriggers()) {
            buf.method_10806(this.triggers.toIntArray());
        }
        if (this.hasBoundEntity()) {
            buf.method_10804(this.boundEntity);
        }
        if (this.isEntitySpaceRelativePosSet()) {
            buf.writeDouble(this.esX);
            buf.writeDouble(this.esY);
            buf.writeDouble(this.esZ);
        }
    }

    public ParticleEmitterInfo(class_2540 buf) {
        this.effek = buf.method_10810();
        this.flags = buf.method_10816();
        this.emitter = this.hasEmitter() ? buf.method_10810() : null;
        if (this.isPositionSet()) {
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
        }
        if (this.isRotationSet()) {
            this.rotX = buf.readFloat();
            this.rotY = buf.readFloat();
            this.rotZ = buf.readFloat();
        }
        if (this.isScaleSet()) {
            this.scaleX = buf.readFloat();
            this.scaleY = buf.readFloat();
            this.scaleZ = buf.readFloat();
        }
        if (this.hasParameters()) {
            int paramCount = buf.method_10816();
            for (int i = 0; i < paramCount; ++i) {
                int index = buf.method_10816();
                float value = buf.readFloat();
                this.parameters.add(new DynamicParameter(index, value));
            }
        }
        if (this.hasTriggers()) {
            this.triggers.addElements(0, buf.method_10787());
        }
        if (this.hasBoundEntity()) {
            this.boundEntity = buf.method_10816();
        }
        if (this.isEntitySpaceRelativePosSet()) {
            this.esX = buf.readDouble();
            this.esY = buf.readDouble();
            this.esZ = buf.readDouble();
        }
    }

    @ApiStatus.Internal
    public void spawnInWorld(class_1937 level, class_1657 player) {
        if (NativePlatform.isRunningOnUnsupportedPlatform()) {
            return;
        }
        Optional.ofNullable(EffectRegistry.get(this.effek)).ifPresent(effek -> {
            float z;
            float y;
            float x;
            ParticleEmitter emitter = this.hasEmitter() ? effek.play(this.emitter) : effek.play();
            boolean hasBoundEntity = this.hasBoundEntity();
            boolean isPositionSet = this.isPositionSet();
            boolean isRotationSet = this.isRotationSet();
            boolean isScaleSet = this.isScaleSet();
            boolean hasParams = this.hasParameters();
            boolean hasTriggs = this.hasTriggers();
            if (isPositionSet) {
                x = (float)this.x;
                y = (float)this.y;
                z = (float)this.z;
            } else if (!hasBoundEntity && player != null) {
                x = (float)player.method_23317();
                y = (float)player.method_23318();
                z = (float)player.method_23321();
            } else {
                z = 0.0f;
                y = 0.0f;
                x = 0.0f;
            }
            emitter.setPosition(x, y, z);
            if (isRotationSet) {
                emitter.setRotation(this.rotX, this.rotY, this.rotZ);
            }
            if (isScaleSet) {
                emitter.setScale(this.scaleX, this.scaleY, this.scaleZ);
            }
            if (hasParams) {
                for (DynamicParameter parameter : this.parameters) {
                    emitter.setDynamicInput(parameter.index(), parameter.value());
                }
            }
            if (hasTriggs) {
                this.triggers.forEach(emitter::sendTrigger);
            }
            if (hasBoundEntity) {
                WeakReference<class_1297> entity = new WeakReference<class_1297>(level.method_8469(this.boundEntity));
                boolean headSpace = this.usingEntityHeadSpace();
                boolean entitySpace = headSpace || this.isEntitySpaceRelativePosSet();
                float rotZ = this.rotZ;
                emitter.addPreDrawCallback((em, partial) -> Optional.ofNullable((class_1297)entity.get()).filter(class_1297::method_5805).ifPresentOrElse(et -> {
                    float relZ;
                    float relY;
                    float relX;
                    if (entitySpace) {
                        Basis basis;
                        float rotX;
                        float rotY;
                        if (headSpace) {
                            rotY = (float)Math.toRadians(et.method_5705(partial));
                            rotX = (float)Math.toRadians(et.method_5695(partial));
                            basis = Basis.fromEuler(new class_243((double)(-rotX), (double)((float)Math.PI - rotY), (double)rotZ));
                        } else {
                            rotY = (float)Math.toRadians(class_3532.method_16439((float)partial, (float)et.field_5982, (float)et.method_36454()));
                            rotX = 0.0f;
                            basis = Basis.fromEntityBody(et);
                        }
                        class_243 esRelPos = basis.toGlobal(new class_243(this.esX, this.esY, this.esZ));
                        relX = (float)((double)x + esRelPos.field_1352);
                        relY = (float)((double)y + esRelPos.field_1351);
                        relZ = (float)((double)z + esRelPos.field_1350);
                        em.setRotation(this.rotX + rotX, this.rotY - rotY, rotZ);
                    } else {
                        relX = x;
                        relY = y;
                        relZ = z;
                    }
                    em.setPosition((float)class_3532.method_16436((double)partial, (double)et.field_6038, (double)et.method_23317()) + relX, (float)class_3532.method_16436((double)partial, (double)et.field_5971, (double)et.method_23318()) + relY + (headSpace ? et.method_5751() : 0.0f), (float)class_3532.method_16436((double)partial, (double)et.field_5989, (double)et.method_23321()) + relZ);
                }, em::stop));
            }
        });
    }

    @ApiStatus.Internal
    public void copyTo(ParticleEmitterInfo target) {
        target.flags = this.flags;
        target.x = this.x;
        target.y = this.y;
        target.z = this.z;
        target.rotX = this.rotX;
        target.rotY = this.rotY;
        target.rotZ = this.rotZ;
        target.scaleX = this.scaleX;
        target.scaleY = this.scaleY;
        target.scaleZ = this.scaleZ;
        target.parameters.clear();
        target.parameters.addAll(this.parameters);
        target.triggers.clear();
        target.triggers.addAll(this.triggers);
        target.boundEntity = this.boundEntity;
    }
}

