/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.allthetrims.mixin;

import com.bawnorton.allthetrims.json.JsonHelper;
import com.bawnorton.allthetrims.json.TrimMaterialJson;
import com.bawnorton.allthetrims.util.DebugHelper;
import com.bawnorton.allthetrims.util.TrimMaterialHelper;
import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_7655;
import net.minecraft.class_7923;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_7655.class})
public abstract class RegistryLoaderMixin {
    @ModifyExpressionValue(method={"load(Lnet/minecraft/registry/RegistryOps$RegistryInfoGetter;Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/registry/MutableRegistry;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/resource/ResourceFinder;findResources(Lnet/minecraft/resource/ResourceManager;)Ljava/util/Map;")})
    private static Map<class_2960, class_3298> addAllTrimMaterialJsonFiles(Map<class_2960, class_3298> original) {
        Iterator<Map.Entry<class_2960, class_3298>> iterator = original.entrySet().iterator();
        if (!iterator.hasNext()) {
            return original;
        }
        Map.Entry<class_2960, class_3298> first = original.entrySet().iterator().next();
        if (!first.getKey().method_12832().contains("trim_material")) {
            return original;
        }
        for (Map.Entry<class_2960, class_3298> resourceEntry : original.entrySet()) {
            try {
                BufferedReader reader = resourceEntry.getValue().method_43039();
                try {
                    JsonObject trimJson = JsonHelper.fromJsonReader(reader, JsonObject.class);
                    TrimMaterialHelper.BUILTIN_TRIM_MATERIALS.add(TrimMaterialJson.fromJson(trimJson));
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        TrimMaterialHelper.forEachTrimMaterial((item, builtin) -> {
            if (builtin.booleanValue()) {
                return;
            }
            class_2960 itemId = class_7923.field_41178.method_10221(item);
            TrimMaterialJson trimMaterialJson = new TrimMaterialJson("dynamic", "#FFFFFF", class_2561.method_43469((String)"text.allthetrims.material", (Object[])new Object[]{item.method_7848().getString()}).getString(), itemId.toString(), Float.valueOf(Float.MAX_VALUE));
            JsonObject resourceJson = trimMaterialJson.asJson();
            class_3298 resource = new class_3298(((class_3298)first.getValue()).method_45304(), () -> IOUtils.toInputStream((String)resourceJson.toString(), (String)"UTF-8"));
            class_2960 resourceId = new class_2960(itemId.method_12836(), "trim_material/" + itemId.method_12832() + ".json");
            original.put(resourceId, resource);
            DebugHelper.createDebugFile("trim_materials", itemId + ".json", resourceJson.toString());
        });
        return original;
    }

    @Unique
    private static String allTheTrims$escape(String string) {
        return string.replace("\"", "\\\"");
    }
}

