/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Objects;
import net.mehvahdjukaar.amendments.common.recipe.CauldronCraftingContainer;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.common.recipe.SoftFluidIngredient;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public class CauldronRecipe
implements class_1860<CauldronCraftingContainer> {
    private final class_2960 id;
    private final String group;
    private final class_2371<class_1856> inputItems;
    private final SoftFluidIngredient inputFluid;
    private final SoftFluidIngredient outputFluid;
    private final class_1799 outputItem;
    private final boolean requireBoiling = false;
    private final int fluidAmountDifference;

    protected CauldronRecipe(class_2960 id, String group, SoftFluidIngredient inputFluid, class_2371<class_1856> inputItems, SoftFluidIngredient outputFluid, class_1799 outputItem, int fluidAmountDifference, boolean requireBoiling) {
        this.id = id;
        this.group = group;
        this.inputItems = inputItems;
        this.inputFluid = inputFluid;
        this.outputItem = outputItem;
        this.outputFluid = outputFluid;
        this.fluidAmountDifference = fluidAmountDifference;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ModRegistry.CAULDRON_RECIPE_SERIALIZER.get();
    }

    public class_3956<?> method_17716() {
        return ModRegistry.CAULDRON_RECIPE_TYPE.get();
    }

    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.outputItem;
    }

    public class_2371<class_1856> method_8117() {
        return this.inputItems;
    }

    public boolean matches(CauldronCraftingContainer inv, class_1937 level) {
        Objects.requireNonNull(this);
        class_1662 stackedContents = new class_1662();
        int i = 0;
        for (int j = 0; j < inv.method_5439(); ++j) {
            class_1799 itemStack = inv.method_5438(j);
            if (itemStack.method_7960()) continue;
            ++i;
            stackedContents.method_20478(itemStack, 1);
        }
        SoftFluidStack tankFluid = inv.getFluid();
        int newCount = tankFluid.getCount() + this.fluidAmountDifference;
        if (!this.inputFluid.matches(tankFluid) || newCount < 0 || newCount > inv.getMaxAllowedFluidCount()) {
            return false;
        }
        return i == this.inputItems.size() && stackedContents.method_7402((class_1860)this, null);
    }

    @Deprecated
    public class_1799 assemble(CauldronCraftingContainer container, class_5455 registryAccess) {
        return this.method_8110(registryAccess);
    }

    public FluidAndItemCraftResult assembleFluid(CauldronCraftingContainer container, class_5455 registryAccess) {
        SoftFluidStack tankFluid = container.getFluid();
        class_1799 craftedItem = this.outputItem.method_7972();
        SoftFluidStack newTankFluid = this.outputFluid.isEmpty() ? tankFluid : this.outputFluid.createStack();
        newTankFluid.setCount(tankFluid.getCount() + this.fluidAmountDifference);
        return FluidAndItemCraftResult.of(craftedItem, newTankFluid);
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public static class Serializer
    implements class_1865<CauldronRecipe> {
        public CauldronRecipe fromJson(class_2960 recipeId, JsonObject json) {
            String group = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> inputItems = Serializer.itemsFromJson(class_3518.method_15261((JsonObject)json, (String)"input_items"));
            if (inputItems.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)Utils.hackyGetRegistryAccess());
            SoftFluidStack inputFluid = (SoftFluidStack)((Pair)SoftFluidStack.CODEC.decode((DynamicOps)ops, (Object)class_3518.method_15296((JsonObject)json, (String)"input_fluid")).getOrThrow(false, s -> {})).getFirst();
            if (inputFluid.getCount() != 1) {
                throw new JsonParseException("Input fluid amount must be 1 for cauldron recipes, got: " + inputFluid.getCount());
            }
            JsonObject fiJson = class_3518.method_15281((JsonObject)json, (String)"output_fluid", null);
            SoftFluidStack outputFluid = fiJson == null ? SoftFluidStack.empty() : (SoftFluidStack)((Pair)SoftFluidStack.CODEC.decode((DynamicOps)ops, (Object)fiJson).getOrThrow(false, s -> {})).getFirst();
            JsonObject oiJson = class_3518.method_15281((JsonObject)json, (String)"output_item", null);
            class_1799 outputItem = oiJson == null ? class_1799.field_8037 : (class_1799)((Pair)class_1799.field_24671.decode((DynamicOps)ops, (Object)oiJson).getOrThrow(false, s -> {})).getFirst();
            int fluidDifference = class_3518.method_15282((JsonObject)json, (String)"fluid_amount_difference", (int)0);
            boolean requireBoiling = class_3518.method_15258((JsonObject)json, (String)"require_boiling", (boolean)false);
            return new CauldronRecipe(recipeId, group, SoftFluidIngredient.containing(inputFluid), inputItems, SoftFluidIngredient.containing(outputFluid), outputItem, fluidDifference, requireBoiling);
        }

        private static class_2371<class_1856> itemsFromJson(JsonArray ingredientArray) {
            class_2371 nonNullList = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_8102((JsonElement)ingredientArray.get(i), (boolean)false);
                if (ingredient.method_8103()) continue;
                nonNullList.add((Object)ingredient);
            }
            return nonNullList;
        }

        public CauldronRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            String string = buffer.method_19772();
            int i = buffer.method_10816();
            class_2371 inputItems = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            inputItems.replaceAll(ignored -> class_1856.method_8086((class_2540)buffer));
            SoftFluidIngredient inputFluid = SoftFluidIngredient.loadFromBuffer(buffer);
            SoftFluidIngredient outputIFluid = SoftFluidIngredient.loadFromBuffer(buffer);
            class_1799 outputItem = buffer.method_10819();
            int differenceAmount = buffer.method_10816();
            boolean requireBoiling = buffer.readBoolean();
            return new CauldronRecipe(recipeId, string, inputFluid, (class_2371<class_1856>)inputItems, outputIFluid, outputItem, differenceAmount, requireBoiling);
        }

        public void toNetwork(class_2540 buffer, CauldronRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.inputItems.size());
            for (class_1856 ingredient : recipe.inputItems) {
                ingredient.method_8088(buffer);
            }
            recipe.outputFluid.saveToBuffer(buffer);
            recipe.inputFluid.saveToBuffer(buffer);
            buffer.method_10793(recipe.outputItem);
            buffer.method_10804(recipe.fluidAmountDifference);
            buffer.writeBoolean(recipe.requireBoiling);
        }
    }
}

