/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.amethyst_imbuement.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.amethyst_core.scepter_util.LoreTier;
import me.fzzyhmstrs.amethyst_core.scepter_util.SpellType;
import me.fzzyhmstrs.amethyst_core.scepter_util.augments.AugmentDatapoint;
import me.fzzyhmstrs.amethyst_core.scepter_util.augments.AugmentHelper;
import me.fzzyhmstrs.amethyst_imbuement.util.ImbuingRecipe;
import me.fzzyhmstrs.amethyst_imbuement.util.ImbuingRecipeFormat;
import me.fzzyhmstrs.amethyst_imbuement.util.RecipeUtil;
import me.fzzyhmstrs.fzzy_core.coding_util.PerLvlI;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\t\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lme/fzzyhmstrs/amethyst_imbuement/util/ImbuingRecipeSerializer;", "Lnet/minecraft/class_1865;", "Lme/fzzyhmstrs/amethyst_imbuement/util/ImbuingRecipe;", "<init>", "()V", "Lnet/minecraft/class_2960;", "id", "Lcom/google/gson/JsonObject;", "json", "read", "(Lnet/minecraft/class_2960;Lcom/google/gson/JsonObject;)Lme/fzzyhmstrs/amethyst_imbuement/util/ImbuingRecipe;", "Lnet/minecraft/class_2540;", "buf", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_2540;)Lme/fzzyhmstrs/amethyst_imbuement/util/ImbuingRecipe;", "recipe", "", "write", "(Lnet/minecraft/class_2540;Lme/fzzyhmstrs/amethyst_imbuement/util/ImbuingRecipe;)V", "ID", "Lnet/minecraft/class_2960;", "getID", "()Lnet/minecraft/class_2960;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "amethyst_imbuement"})
public final class ImbuingRecipeSerializer
implements class_1865<ImbuingRecipe> {
    @NotNull
    public static final ImbuingRecipeSerializer INSTANCE = new ImbuingRecipeSerializer();
    @NotNull
    private static final class_2960 ID = new class_2960("amethyst_imbuement", "imbuing");
    @NotNull
    private static final Gson gson = new Gson();

    private ImbuingRecipeSerializer() {
    }

    @NotNull
    public final class_2960 getID() {
        return ID;
    }

    @NotNull
    public ImbuingRecipe read(@NotNull class_2960 id2, @NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Object object = gson.fromJson((JsonElement)json, ImbuingRecipeFormat.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        ImbuingRecipeFormat recipeJson = (ImbuingRecipeFormat)object;
        class_1856[] class_1856Array = new class_1856[]{RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getImbueA()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getImbueB()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getCraftA()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getCraftB()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getCraftC()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getCraftD()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getCraftE()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getCraftF()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getCraftG()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getCraftH()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getCraftI()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getImbueC()), RecipeUtil.INSTANCE.ingredientFromJson(recipeJson.getImbueD())};
        class_1856[] inputsArray = class_1856Array;
        String titleA = recipeJson.getTitle();
        int costA = recipeJson.getCost();
        String augmentA = recipeJson.getAugment();
        String resultA = recipeJson.getResultA();
        if (Intrinsics.areEqual((Object)augmentA, (Object)"") && Intrinsics.areEqual((Object)resultA, (Object)"")) {
            throw new JsonSyntaxException("Need either an augment or item output!: " + id2);
        }
        if (!Intrinsics.areEqual((Object)augmentA, (Object)"") && !Intrinsics.areEqual((Object)resultA, (Object)"")) {
            throw new JsonSyntaxException("Can't have both outputs and augments!: " + id2);
        }
        if (!Intrinsics.areEqual((Object)augmentA, (Object)"")) {
            String string = new class_2960(augmentA).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String augId = string;
            if (AugmentHelper.INSTANCE.checkAugmentStat(augId)) {
                SpellType type = AugmentHelper.INSTANCE.getAugmentType(augId);
                PerLvlI cooldown = AugmentHelper.INSTANCE.getAugmentCooldown(augId);
                int manaCost = AugmentHelper.getAugmentManaCost$default((AugmentHelper)AugmentHelper.INSTANCE, (String)augId, (double)0.0, (int)2, null);
                int minLevel = AugmentHelper.INSTANCE.getAugmentMinLvl(augId);
                int castXp = AugmentHelper.INSTANCE.getAugmentCastXp(augId);
                LoreTier bookOfLoreTier = AugmentHelper.INSTANCE.getAugmentTier(augId);
                class_1792 keyItem = AugmentHelper.INSTANCE.getAugmentItem(augId);
                boolean enabled = AugmentHelper.INSTANCE.getAugmentEnabled(augId);
                boolean pvpMode = AugmentHelper.INSTANCE.getAugmentPvpMode(augId);
                AugmentDatapoint datapoint = new AugmentDatapoint(type, cooldown, manaCost, minLevel, costA, castXp, bookOfLoreTier, keyItem, enabled, pvpMode);
                AugmentHelper.INSTANCE.registerAugmentStat(augId, datapoint, true);
            }
        }
        int countA = Math.max(1, recipeJson.getCountA());
        boolean transferEnchant = recipeJson.getTransferEnchant();
        return new ImbuingRecipe(inputsArray, resultA, countA, augmentA, transferEnchant, titleA, costA, id2);
    }

    public void write(@NotNull class_2540 buf, @NotNull ImbuingRecipe recipe) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)recipe, (String)"recipe");
        class_1856[] inputs = recipe.getInputs();
        for (int i = 0; i < 13; ++i) {
            inputs[i].method_8088(buf);
        }
        buf.method_10814(recipe.getTitle());
        buf.writeInt(recipe.getCost());
        buf.method_10814(recipe.getAugment());
        buf.method_10814(recipe.getResult());
        buf.writeInt(recipe.getCount());
        buf.writeBoolean(recipe.getTransferEnchant());
    }

    @NotNull
    public ImbuingRecipe read(@NotNull class_2960 id2, @NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        class_1856[] class_1856Array = new class_1856[13];
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        Intrinsics.checkNotNullExpressionValue((Object)class_1856.method_8086((class_2540)buf), (String)"fromPacket(...)");
        class_1856[] inputsArray = class_1856Array;
        String titleA = buf.method_19772();
        int costA = buf.readInt();
        String augmentA = buf.method_19772();
        String resultA = buf.method_19772();
        int countA = buf.readInt();
        boolean transferEnchant = buf.readBoolean();
        Intrinsics.checkNotNull((Object)resultA);
        Intrinsics.checkNotNull((Object)augmentA);
        Intrinsics.checkNotNull((Object)titleA);
        return new ImbuingRecipe(inputsArray, resultA, countA, augmentA, transferEnchant, titleA, costA, id2);
    }
}

