/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.amethyst_imbuement.util;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lme/fzzyhmstrs/amethyst_imbuement/util/LoggerUtil;", "", "<init>", "()V", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "LogFormat", "amethyst_imbuement"})
public final class LoggerUtil {
    @NotNull
    public static final LoggerUtil INSTANCE = new LoggerUtil();

    private LoggerUtil() {
    }

    @NotNull
    public final Logger getLogger() {
        Logger logger = Logger.getLogger("amethyst_imbuement");
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogFormat());
        handler.setLevel(Level.ALL);
        logger.setLevel(Level.ALL);
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        Intrinsics.checkNotNull((Object)logger);
        return logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/fzzyhmstrs/amethyst_imbuement/util/LoggerUtil$LogFormat;", "Ljava/util/logging/Formatter;", "<init>", "()V", "Ljava/util/logging/LogRecord;", "record", "", "format", "(Ljava/util/logging/LogRecord;)Ljava/lang/String;", "amethyst_imbuement"})
    private static final class LogFormat
    extends Formatter {
        @Override
        @NotNull
        public String format(@NotNull LogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            ZonedDateTime zdt = ZonedDateTime.ofInstant(record.getInstant(), ZoneId.systemDefault());
            String a = "[" + zdt.getHour() + ":" + zdt.getMinute() + ":" + zdt.getSecond() + "] ";
            String b = "[Amethyst Imbuement/" + record.getLevel().getLocalizedName() + "] [" + record.getSourceClassName() + "]: ";
            String c = record.getMessage() + "\n";
            return a + b + c;
        }
    }
}

