/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.compat;

import dev.cheos.armorpointspp.config.ApppConfig;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.Side;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.adapter.IDataProvider;
import dev.cheos.armorpointspp.core.adapter.IMath;
import dev.cheos.armorpointspp.core.adapter.IProfiler;
import dev.cheos.armorpointspp.core.adapter.IRenderer;
import dev.cheos.armorpointspp.core.render.Components;
import dev.cheos.armorpointspp.impl.DataProviderImpl;
import dev.cheos.armorpointspp.impl.EnchantmentHelperImpl;
import dev.cheos.armorpointspp.impl.PoseStackImpl;
import dev.cheos.armorpointspp.impl.ProfilerImpl;
import dev.cheos.armorpointspp.impl.RendererImpl;
import dev.cheos.libhud.LibhudGui;
import dev.cheos.libhud.VanillaComponents;
import dev.cheos.libhud.api.Component;
import dev.cheos.libhud.api.LibhudApi;
import dev.cheos.libhud.api.event.RegisterComponentsEvent;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class Libhud
implements LibhudApi {
    private static final IDataProvider DATA_PROVIDER = new DataProviderImpl();
    private static final IRenderer RENDERER = new RendererImpl();
    private static final IProfiler PROFILER = new ProfilerImpl();
    private static final class_310 minecraft = class_310.method_1551();
    private static int lastArmorY = 0;
    private static int lastHealthY = 0;
    private static int lastToughnessY = 0;
    public static final Component.NamedComponent ARMOR = Component.named((class_2960)VanillaComponents.ARMOR.getName(), Libhud::armorLevel);
    public static final Component.NamedComponent HEALTH = Component.named((class_2960)VanillaComponents.HEALTH.getName(), Libhud::playerHealth);
    public static final Component.NamedComponent ABSORPTION = Component.named((class_2960)new class_2960("armorpointspp", "absorption"), Libhud::absorption);
    public static final Component.NamedComponent ABSORPTION_OV = Component.named((class_2960)new class_2960("armorpointspp", "absorption_ov"), Libhud::absorptionOv);
    public static final Component.NamedComponent MAGIC_SHIELD = Component.named((class_2960)new class_2960("armorpointspp", "pc_magic_shield"), Libhud::magicShield);
    public static final Component.NamedComponent RESISTANCE = Component.named((class_2960)new class_2960("armorpointspp", "resistance"), Libhud::resistance);
    public static final Component.NamedComponent PROTECTION = Component.named((class_2960)new class_2960("armorpointspp", "protection"), Libhud::protection);
    public static final Component.NamedComponent ARMOR_TOUGHNESS = Component.named((class_2960)new class_2960("armorpointspp", "toughness"), Libhud::armorToughness);
    public static final Component.NamedComponent ARMOR_TOUGHNESS_OV = Component.named((class_2960)new class_2960("armorpointspp", "toughness_ov"), Libhud::armorToughnessOv);
    public static final Component.NamedComponent ARMOR_TEXT = Component.named((class_2960)new class_2960("armorpointspp", "armor_text"), Libhud::armorText);
    public static final Component.NamedComponent HEALTH_TEXT = Component.named((class_2960)new class_2960("armorpointspp", "health_text"), Libhud::healthText);
    public static final Component.NamedComponent TOUGHNESS_TEXT = Component.named((class_2960)new class_2960("armorpointspp", "toughness_text"), Libhud::toughnessText);
    public static final Component.NamedComponent DEBUG = Component.named((class_2960)new class_2960("armorpointspp", "debug"), Libhud::debug);

    public void onRegisterComponents(RegisterComponentsEvent event) {
        event.replace(HEALTH);
        event.registerAbove(HEALTH, ABSORPTION);
        event.registerAbove(ABSORPTION, ABSORPTION_OV);
        event.replace(ARMOR);
        event.registerAbove(ARMOR, MAGIC_SHIELD);
        event.registerAbove(MAGIC_SHIELD, RESISTANCE);
        event.registerAbove(RESISTANCE, PROTECTION);
        event.registerAbove(PROTECTION, ARMOR_TOUGHNESS_OV);
        event.registerAbove(VanillaComponents.VEHICLE_HEALTH, ARMOR_TOUGHNESS);
        event.registerAbove(VanillaComponents.ITEM_NAME, ARMOR_TEXT);
        event.registerAbove(VanillaComponents.ITEM_NAME, HEALTH_TEXT);
        event.registerAbove(VanillaComponents.ITEM_NAME, TOUGHNESS_TEXT);
        event.registerTop(DEBUG);
    }

    static boolean playerHealth(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        lastHealthY = Libhud.baseY(gui, screenHeight);
        if (!ApppConfig.instance().bool(IConfig.BooleanOption.HEALTH_ENABLE)) {
            if (!Libhud.minecraft.field_1690.field_1842 && DATA_PROVIDER.shouldDrawSurvivalElements()) {
                VanillaComponents.HEALTH.render(gui, graphics, partialTicks, screenWidth, screenHeight);
                return true;
            }
        } else if (Components.HEALTH.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastHealthY))) {
            gui.leftOffset += 10;
            return true;
        }
        return false;
    }

    static boolean absorption(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        return Components.ABSORPTION.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastHealthY));
    }

    static boolean absorptionOv(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        return Components.ABSORPTION_OVER.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastHealthY));
    }

    static boolean armorLevel(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        lastArmorY = Libhud.baseY(gui, screenHeight);
        RenderContext ctx = Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastArmorY);
        boolean flag = false;
        flag = !ApppConfig.instance().bool(IConfig.BooleanOption.ARMOR_ENABLE) ? Components.VANILLA_ARMOR.render(ctx) : Components.ARMOR.render(ctx);
        if (flag) {
            gui.leftOffset += 10;
        }
        return flag;
    }

    static boolean armorToughness(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        Side side = ApppConfig.instance().enm(IConfig.EnumOption.TOUGHNESS_SIDE);
        lastToughnessY = Libhud.baseY(gui, screenHeight, side);
        if (Components.TOUGHNESS.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth, side), lastToughnessY))) {
            switch (side) {
                case LEFT: {
                    gui.leftOffset += 10;
                    return true;
                }
                case RIGHT: {
                    gui.rightOffset += 10;
                    return true;
                }
            }
        }
        return false;
    }

    static boolean resistance(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        return Components.RESISTANCE.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastArmorY));
    }

    static boolean protection(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        return Components.PROTECTION.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastArmorY));
    }

    static boolean armorToughnessOv(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        return Components.TOUGHNESS_OVER.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastArmorY));
    }

    static boolean magicShield(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        return Components.MAGIC_SHIELD.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastArmorY));
    }

    static boolean armorText(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        return Components.ARMOR_TEXT.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastArmorY));
    }

    static boolean healthText(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        return Components.HEALTH_TEXT.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastHealthY));
    }

    static boolean toughnessText(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        return Components.TOUGHNESS_TEXT.render(Libhud.ctx(graphics, Libhud.baseX(screenWidth, ApppConfig.instance().enm(IConfig.EnumOption.TOUGHNESS_SIDE)), lastToughnessY));
    }

    static boolean debug(LibhudGui gui, class_332 graphics, float partialTicks, int screenWidth, int screenHeight) {
        RenderContext ctx = Libhud.ctx(graphics, Libhud.baseX(screenWidth), lastArmorY);
        return Components.DEBUG.render(ctx) & Components.DEBUG_TEXT.render(ctx);
    }

    public static RenderContext ctx(class_332 graphics, int x, int y) {
        return new RenderContext(ApppConfig.instance(), DATA_PROVIDER, EnchantmentHelperImpl.INSTANCE, IMath.INSTANCE, RENDERER, new PoseStackImpl(graphics), PROFILER, x, y);
    }

    static void cleanup() {
        RENDERER.setupVanilla();
    }

    private static int baseX(int width) {
        return Libhud.baseX(width, Side.LEFT);
    }

    private static int baseX(int width, Side side) {
        return width / 2 + (side == Side.LEFT ? -91 : 10);
    }

    private static int baseY(LibhudGui gui, int height) {
        return Libhud.baseY(gui, height, Side.LEFT);
    }

    private static int baseY(LibhudGui gui, int height, Side side) {
        return height - (side == Side.LEFT ? gui.leftOffset : gui.rightOffset);
    }
}

