/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.compat;

import com.google.common.collect.ImmutableList;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import dev.cheos.armorpointspp.config.ApppConfig;
import dev.cheos.armorpointspp.config.ApppConfigValue;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4892;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7919;

public class Modmenu
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return ModmenuScreen::new;
    }

    public static class ModmenuScreen
    extends class_437 {
        private final class_437 prev;
        private int selectedCategory = 0;
        private List<TabButton> tabs = new ArrayList<TabButton>();
        private List<EntryList> tabContents = new ArrayList<EntryList>();

        public ModmenuScreen(class_437 prev) {
            super((class_2561)class_2561.method_43471((String)"armorpointspp.modmenu.title"));
            this.prev = prev;
        }

        protected void method_25426() {
            if (this.tabs.isEmpty()) {
                List<class_5250> names = Arrays.stream(IConfig.Category.values()).filter(cat -> cat.hasOptions(ApppConfig.VERSION)).map(cat -> class_2561.method_43471((String)("armorpointspp.tab." + cat.getPathJoined()))).toList();
                List<Integer> widths = names.stream().map(comp -> this.field_22793.method_27525((class_5348)comp) + 10).toList();
                ArrayList<Integer> cmlWidths = new ArrayList<Integer>(widths);
                cmlWidths.set(0, (Integer)cmlWidths.get(0) + 4);
                for (int i = 1; i < cmlWidths.size(); ++i) {
                    cmlWidths.set(i, (Integer)cmlWidths.get(i - 1) + (Integer)cmlWidths.get(i) + 4);
                }
                cmlWidths.set(cmlWidths.size() - 1, (Integer)cmlWidths.get(cmlWidths.size() - 1) - 4);
                int xoff = -((Integer)cmlWidths.get(cmlWidths.size() - 1)).intValue() / 2;
                int i = 0;
                for (IConfig.Category cat2 : IConfig.Category.values()) {
                    if (!cat2.hasOptions(ApppConfig.VERSION)) continue;
                    TabButton tb = new TabButton(i, this.field_22789 / 2 + xoff + (i == 0 ? 0 : (Integer)cmlWidths.get(i - 1)), 20, widths.get(i), 20, (class_2561)names.get(i), (class_2561)class_2561.method_43470((String)""));
                    this.tabs.add(tb);
                    EntryList list = new EntryList(this.field_22787, this.field_22789, this.field_22790, 50, this.field_22790 - 50, 25);
                    this.tabContents.add(list);
                    for (IConfig.Option<?> opt : cat2.getOptions()) {
                        if (!opt.isAvailableIn(ApppConfig.VERSION)) continue;
                        ApppConfigValue<?, ?, ?> val = ApppConfig.findValue(opt);
                        WidgetProvider widget = null;
                        if (val instanceof ApppConfigValue.BoolValue) {
                            ApppConfigValue.BoolValue bv = (ApppConfigValue.BoolValue)val;
                            widget = new TrueFalseOption(bv::set, bv::get);
                        } else if (val instanceof ApppConfigValue.HexValue) {
                            ApppConfigValue.HexValue hv = (ApppConfigValue.HexValue)val;
                            widget = new EditOption(hv::set, hv::getHex);
                        } else if (val instanceof ApppConfigValue.StringValue) {
                            ApppConfigValue.StringValue sv = (ApppConfigValue.StringValue)val;
                            widget = new EditOption(sv::set, sv::get);
                        } else if (val instanceof ApppConfigValue.FloatValue) {
                            ApppConfigValue.FloatValue fv = (ApppConfigValue.FloatValue)val;
                            widget = fv.min != 0.0f && fv.max != Float.MAX_VALUE && fv.min < fv.max ? new SliderOption(fv.min, fv.max, 0.1f, fv::set, fv::get) : new EditOption(fv::set, () -> fv.get().toString());
                        } else if (val instanceof ApppConfigValue.EnumValue) {
                            ApppConfigValue.EnumValue ev = (ApppConfigValue.EnumValue)val;
                            widget = new EnumCycleOption(ev::set, () -> ((Enum)ev.get()).name(), Arrays.stream((Enum[])ev.type.getEnumConstants()).map(Enum::name).toList());
                        }
                        list.addSmall(new TextOption(opt.key(), opt.comments()), widget);
                    }
                    ++i;
                }
            }
            this.method_25429((class_364)this.tabContents.get(this.selectedCategory));
            for (TabButton tb : this.tabs) {
                this.method_37063((class_364)tb);
            }
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, btn -> {
                ApppConfig.save();
                this.field_22787.method_1507(this.prev);
            }).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, btn -> {
                ApppConfig.load();
                ApppConfig.save();
                this.field_22787.method_1507(this.prev);
            }).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20).method_46431());
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            this.method_25420(graphics);
            this.tabContents.get(this.selectedCategory).method_25394(graphics, mouseX, mouseY, partialTicks);
            graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 5, 0xFFFFFF);
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
        }

        protected void method_37067() {
            this.tabs.clear();
            this.tabContents.clear();
            super.method_37067();
        }

        public void method_25419() {
            ApppConfig.load();
            super.method_25419();
        }

        public class TabButton
        extends class_4264 {
            private final int index;

            public TabButton(int index, int x, int y, int w, int h, class_2561 component, class_2561 tooltip) {
                super(x, y, w, h, component);
                this.index = index;
                this.method_47400(class_7919.method_47407((class_2561)tooltip));
            }

            public void method_25306() {
                if (this.index != -1) {
                    ModmenuScreen.this.selectedCategory = this.index;
                }
                ModmenuScreen.this.method_25423(class_310.method_1551(), ModmenuScreen.this.field_22789, ModmenuScreen.this.field_22790);
            }

            public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
                this.field_22763 = this.index != ModmenuScreen.this.selectedCategory;
                super.method_48579(graphics, mouseX, mouseY, partialTicks);
            }

            protected boolean method_25361(double mx, double my) {
                return this.field_22764 && this.field_22763 && this.method_25405(mx, my);
            }

            public boolean method_25405(double mx, double my) {
                return this.field_22764 && mx >= (double)this.method_46426() && my >= (double)this.method_46427() && mx < (double)(this.method_46426() + this.field_22758) && my < (double)(this.method_46427() + this.field_22759) && mx >= 20.0 && mx < (double)(ModmenuScreen.this.field_22789 - 20);
            }

            protected void method_47399(class_6382 elem) {
            }
        }

        public static class EntryList
        extends class_4265<Entry> {
            public EntryList(class_310 minecraft, int i, int j, int k, int l, int m) {
                super(minecraft, i, j, k, l, m);
                this.field_22744 = false;
            }

            public void addBig(WidgetProvider widget) {
                this.method_25321((class_350.class_351)Entry.big(this.field_22742, widget));
            }

            public void addSmall(WidgetProvider left, WidgetProvider right) {
                this.method_25321((class_350.class_351)Entry.small(this.field_22742, left, right));
            }

            public int method_25322() {
                return 400;
            }

            protected int method_25329() {
                return super.method_25329() + 32;
            }

            public Optional<class_339> getMouseOver(double mx, double my) {
                for (Entry entry : this.method_25396()) {
                    for (class_339 widget : entry.children) {
                        if (!widget.method_25405(mx, my)) continue;
                        return Optional.of(widget);
                    }
                }
                return Optional.empty();
            }

            public static class Entry
            extends class_4265.class_4266<Entry> {
                private final List<class_339> children;

                private Entry(List<class_339> children) {
                    this.children = children;
                }

                public static Entry big(int width, WidgetProvider provider) {
                    return new Entry((List<class_339>)ImmutableList.of((Object)provider.createButton(width / 2 - 155, 0, 310)));
                }

                public static Entry small(int width, WidgetProvider left, WidgetProvider right) {
                    class_339 widget = left.createButton(width / 2 - 155, 0, 150);
                    return right == null ? new Entry((List<class_339>)ImmutableList.of((Object)widget)) : new Entry((List<class_339>)ImmutableList.of((Object)widget, (Object)right.createButton(width / 2 + 5, 0, 150)));
                }

                public List<? extends class_364> method_25396() {
                    return this.children;
                }

                public List<? extends class_6379> method_37025() {
                    return this.children;
                }

                public void method_25343(class_332 graphics, int i, int j, int k, int l, int m, int n, int o, boolean bl, float f) {
                    this.children.forEach(w -> {
                        w.method_46419(j);
                        w.method_25394(graphics, n, o, f);
                    });
                }
            }
        }

        public class TrueFalseOption
        implements WidgetProvider {
            private final Consumer<Boolean> onChange;
            private final Supplier<Boolean> provider;

            public TrueFalseOption(Consumer<Boolean> onChange, Supplier<Boolean> provider) {
                this.onChange = onChange;
                this.provider = provider;
            }

            @Override
            public class_339 createButton(int x, int y, int w) {
                return class_5676.method_32614().method_32619((Object)this.provider.get()).method_32616().method_32617(x, y, w, 20, (class_2561)class_2561.method_43470((String)""), (btn, b) -> this.onChange.accept((Boolean)b));
            }
        }

        public class EditOption
        implements WidgetProvider {
            private final Consumer<String> onChange;
            private final Supplier<String> provider;

            public EditOption(Consumer<String> onChange, Supplier<String> provider) {
                this.onChange = onChange;
                this.provider = provider;
            }

            @Override
            public class_339 createButton(int x, int y, int w) {
                class_342 editBox = new class_342(ModmenuScreen.this.field_22793, x, y, w, 20, (class_2561)class_2561.method_43470((String)""));
                editBox.method_1863(this.onChange);
                editBox.method_1852(this.provider.get());
                return editBox;
            }
        }

        public class SliderOption
        implements WidgetProvider {
            private final float min;
            private final float max;
            private final float step;
            private final Consumer<Float> onChange;
            private final Supplier<Float> provider;

            public SliderOption(float min, float max, float step, Consumer<Float> onChange, Supplier<Float> provider) {
                this.min = min;
                this.max = max;
                this.step = step;
                this.onChange = onChange;
                this.provider = provider;
            }

            @Override
            public class_339 createButton(int x, int y, int w) {
                return new SliderWidget(x, y, w, 20, this.min, this.max, this.step, this.onChange, this.provider);
            }
        }

        public class EnumCycleOption
        implements WidgetProvider {
            private final Consumer<String> onChange;
            private final Supplier<String> provider;
            private final List<String> values;

            public EnumCycleOption(Consumer<String> onChange, Supplier<String> provider, List<String> values) {
                this.onChange = onChange;
                this.provider = provider;
                this.values = values;
            }

            @Override
            public class_339 createButton(int x, int y, int w) {
                return class_5676.method_32606(s -> class_2561.method_43470((String)s)).method_32619((Object)this.provider.get()).method_32620(this.values).method_32616().method_32617(x, y, w, 20, (class_2561)class_2561.method_43470((String)""), (btn, s) -> this.onChange.accept((String)s));
            }
        }

        public class TextOption
        implements WidgetProvider {
            private final class_2561 text;
            private final class_2561 tooltip;

            public TextOption(String text, String[] tooltip) {
                this.text = class_2561.method_43470((String)text);
                this.tooltip = class_2561.method_43470((String)String.join((CharSequence)"\n", tooltip));
            }

            @Override
            public class_339 createButton(int x, int y, int w) {
                return new TextWidget(x, y, w, 20, this.text, this.tooltip);
            }
        }

        public static interface WidgetProvider {
            public class_339 createButton(int var1, int var2, int var3);
        }

        public class SliderWidget
        extends class_4892 {
            private final float min;
            private final float max;
            private final float step;
            private final Consumer<Float> onChange;
            private final Supplier<Float> provider;

            protected SliderWidget(int x, int y, int w, int h, float min, float max, float step, Consumer<Float> onChange, Supplier<Float> provider) {
                super(((ModmenuScreen)ModmenuScreen.this).field_22787.field_1690, x, y, w, h, (double)SliderWidget.toPct(provider.get().floatValue(), min, max, step));
                this.min = min;
                this.max = max;
                this.step = step;
                this.onChange = onChange;
                this.provider = provider;
                this.method_25346();
            }

            protected void method_25346() {
                this.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(this.provider.get())));
            }

            protected void method_25344() {
                this.onChange.accept(Float.valueOf(this.toValue((float)this.field_22753)));
            }

            public float toPct(float val) {
                return class_3532.method_15363((float)((this.clamp(val) - this.min) / (this.max - this.min)), (float)0.0f, (float)1.0f);
            }

            public static float toPct(float val, float min, float max, float step) {
                return class_3532.method_15363((float)((SliderWidget.clamp(val, min, max, step) - min) / (max - min)), (float)0.0f, (float)1.0f);
            }

            public float toValue(float val) {
                return this.clamp(class_3532.method_16439((float)class_3532.method_15363((float)val, (float)0.0f, (float)1.0f), (float)this.min, (float)this.max));
            }

            public static float toValue(float val, float min, float max, float step) {
                return SliderWidget.clamp(class_3532.method_16439((float)class_3532.method_15363((float)val, (float)0.0f, (float)1.0f), (float)min, (float)max), min, max, step);
            }

            public float clamp(float val) {
                if (this.step > 0.0f) {
                    val = this.step * (float)Math.round(val / this.step);
                }
                return class_3532.method_15363((float)val, (float)this.min, (float)this.max);
            }

            private static float clamp(float val, float min, float max, float step) {
                if (step > 0.0f) {
                    val = step * (float)Math.round(val / step);
                }
                return class_3532.method_15363((float)val, (float)min, (float)max);
            }
        }

        public class TextWidget
        extends class_339 {
            public TextWidget(int x, int y, int w, int h, class_2561 text, class_2561 tooltip) {
                super(x, y, w, h, text);
                this.method_47400(class_7919.method_47407((class_2561)tooltip));
                this.field_22763 = false;
            }

            public void method_48579(class_332 graphics, int mx, int my, float partialTicks) {
                graphics.method_27534(ModmenuScreen.this.field_22793, this.method_25369(), this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, 0xFFFFFF | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
            }

            public boolean method_25405(double mx, double my) {
                return this.field_22764 && mx >= (double)this.method_46426() && my >= (double)this.method_46427() && mx < (double)(this.method_46426() + this.field_22758) && my < (double)(this.method_46427() + this.field_22759);
            }

            protected void method_47399(class_6382 elem) {
            }
        }
    }
}

