/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.config;

import dev.cheos.armorpointspp.config.ApppConfigValue;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;

public class ApppConfig
implements IConfig {
    private static ApppConfig INSTANCE;
    private static ConfigTree tree;
    private static final Path configFile;
    public static final IConfig.Version VERSION;
    private static final Map<String, ApppConfigValue.BoolValue> boolConfigs;
    private static final Map<String, ApppConfigValue.IntValue> intConfigs;
    private static final Map<String, ApppConfigValue.HexValue> hexConfigs;
    private static final Map<String, ApppConfigValue.FloatValue> floatConfigs;
    private static final Map<String, ApppConfigValue.StringValue> stringConfigs;
    private static final Map<String, ApppConfigValue.EnumValue<?>> enumConfigs;

    public static void init() {
        if (INSTANCE != null) {
            return;
        }
        ApppConfig.define();
        new ConfigBuilder(ConfigTree.builder());
        ApppConfig.load();
        ApppConfig.save();
        INSTANCE = new ApppConfig();
    }

    public static void load() {
        if (Files.isRegularFile(configFile, new LinkOption[0])) {
            try {
                FiberSerialization.deserialize((ConfigTree)tree, (InputStream)Files.newInputStream(configFile, new OpenOption[0]), (ValueSerializer)new JanksonValueSerializer(false));
            }
            catch (ValueDeserializationException | IOException e) {
                e.printStackTrace();
            }
        } else if (Files.isRegularFile(configFile.resolveSibling("armorpointspp.json"), new LinkOption[0])) {
            try {
                Path legacy = configFile.resolveSibling("armorpointspp.json");
                FiberSerialization.deserialize((ConfigTree)tree, (InputStream)Files.newInputStream(legacy, new OpenOption[0]), (ValueSerializer)new JanksonValueSerializer(false));
                Files.delete(legacy);
            }
            catch (ValueDeserializationException | IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        try {
            if (Files.notExists(configFile, new LinkOption[0])) {
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            }
            if (Files.isDirectory(configFile, new LinkOption[0])) {
                throw new IllegalStateException("config file must not be a directory: " + configFile.toAbsolutePath());
            }
            FiberSerialization.serialize((ConfigTree)tree, (OutputStream)Files.newOutputStream(configFile, new OpenOption[0]), (ValueSerializer)new JanksonValueSerializer(false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static IConfig instance() {
        if (INSTANCE == null) {
            ApppConfig.init();
        }
        return INSTANCE;
    }

    @Override
    public boolean bool(IConfig.Option<Boolean> key) {
        return boolConfigs.containsKey(key.key()) ? (Boolean)boolConfigs.get(key.key()).get() : key.def();
    }

    @Override
    public int num(IConfig.Option<Integer> key) {
        return intConfigs.containsKey(key.key()) ? intConfigs.get(key.key()).get() : key.def();
    }

    @Override
    public int hex(IConfig.Option<Integer> key) {
        return hexConfigs.containsKey(key.key()) ? hexConfigs.get(key.key()).get() : key.def();
    }

    @Override
    public float dec(IConfig.Option<Float> key) {
        return (floatConfigs.containsKey(key.key()) ? floatConfigs.get(key.key()).get() : key.def()).floatValue();
    }

    @Override
    public String str(IConfig.Option<String> key) {
        return stringConfigs.containsKey(key.key()) ? (String)stringConfigs.get(key.key()).get() : key.def();
    }

    @Override
    public <T extends Enum<T>> T enm(IConfig.Option<T> key) {
        return (T)(enumConfigs.containsKey(key.key()) ? enumConfigs.get(key.key()).get() : (Enum)key.def());
    }

    @Override
    @Deprecated
    public void invalidateAll() {
    }

    private static void define() {
        for (IConfig.BooleanOption booleanOption : IConfig.BooleanOption.values()) {
            if (!booleanOption.isAvailableIn(VERSION)) continue;
            boolConfigs.put(booleanOption.key(), new ApppConfigValue.BoolValue(booleanOption.key(), booleanOption.def(), booleanOption.comments()));
        }
        for (Enum enum_ : IConfig.IntegerOption.values()) {
            if (!((IConfig.IntegerOption)enum_).isAvailableIn(VERSION)) continue;
            intConfigs.put(((IConfig.IntegerOption)enum_).key(), new ApppConfigValue.IntValue(((IConfig.IntegerOption)enum_).key(), (int)((IConfig.IntegerOption)enum_).def(), ((IConfig.IntegerOption)enum_).comments()));
        }
        for (Enum enum_ : IConfig.HexOption.values()) {
            if (!((IConfig.HexOption)enum_).isAvailableIn(VERSION)) continue;
            hexConfigs.put(((IConfig.HexOption)enum_).key(), new ApppConfigValue.HexValue(((IConfig.HexOption)enum_).key(), ((IConfig.HexOption)enum_).def(), ((IConfig.HexOption)enum_).comments()));
        }
        for (Enum enum_ : IConfig.FloatOption.values()) {
            if (!((IConfig.FloatOption)enum_).isAvailableIn(VERSION)) continue;
            floatConfigs.put(((IConfig.FloatOption)enum_).key(), new ApppConfigValue.FloatValue(((IConfig.FloatOption)enum_).key(), ((IConfig.FloatOption)enum_).def().floatValue(), ((IConfig.FloatOption)enum_).min().floatValue(), ((IConfig.FloatOption)enum_).max().floatValue(), ((IConfig.FloatOption)enum_).comments()));
        }
        for (Enum enum_ : IConfig.StringOption.values()) {
            if (!((IConfig.StringOption)enum_).isAvailableIn(VERSION)) continue;
            stringConfigs.put(((IConfig.StringOption)enum_).key(), new ApppConfigValue.StringValue(((IConfig.StringOption)enum_).key(), ((IConfig.StringOption)enum_).def(), ((IConfig.StringOption)enum_).comments()));
        }
        for (IConfig.EnumOption enumOption : IConfig.EnumOption.values()) {
            if (!enumOption.isAvailableIn(VERSION)) continue;
            enumConfigs.put(enumOption.key(), ApppConfigValue.EnumValue.of(enumOption));
        }
    }

    public static ApppConfigValue<?, ?, ?> findValue(IConfig.Option<?> option) {
        if (option instanceof IConfig.BooleanOption) {
            return boolConfigs.get(option.key());
        }
        if (option instanceof IConfig.IntegerOption) {
            return intConfigs.get(option.key());
        }
        if (option instanceof IConfig.HexOption) {
            return hexConfigs.get(option.key());
        }
        if (option instanceof IConfig.FloatOption) {
            return floatConfigs.get(option.key());
        }
        if (option instanceof IConfig.StringOption) {
            return stringConfigs.get(option.key());
        }
        if (option instanceof IConfig.EnumOption) {
            return enumConfigs.get(option.key());
        }
        return null;
    }

    static {
        configFile = FabricLoader.getInstance().getConfigDir().resolve("armorpointspp.json5");
        VERSION = IConfig.Version.v1_19;
        boolConfigs = new HashMap<String, ApppConfigValue.BoolValue>();
        intConfigs = new HashMap<String, ApppConfigValue.IntValue>();
        hexConfigs = new HashMap<String, ApppConfigValue.HexValue>();
        floatConfigs = new HashMap<String, ApppConfigValue.FloatValue>();
        stringConfigs = new HashMap<String, ApppConfigValue.StringValue>();
        enumConfigs = new HashMap();
    }

    public static class ConfigBuilder {
        final Set<IConfig.Category> done = new HashSet<IConfig.Category>();

        public ConfigBuilder(ConfigTreeBuilder builder) {
            for (IConfig.Category category : IConfig.Category.values()) {
                this.configure(builder, category, 0);
            }
            tree = builder.build();
        }

        private void configure(ConfigTreeBuilder builder, IConfig.Category category, int currentDepth) {
            if (!this.done.add(category) || !category.hasOptions(VERSION)) {
                return;
            }
            for (String string : category.getPath().subList(currentDepth, category.getPath().size())) {
                builder = builder.fork(string);
            }
            for (IConfig.Option option : category.getOptions()) {
                if (!option.isAvailableIn(VERSION)) continue;
                ApppConfig.findValue(option).define(builder);
            }
            for (IConfig.Category category2 : category.getSubCategories()) {
                this.configure(builder, category2, category.getPath().size());
            }
            for (int i = 0; i < category.getPath().size() - currentDepth; ++i) {
                builder = builder.finishBranch();
            }
        }
    }
}

