/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.render.Components;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;

public class AbsorptionComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        if (!ctx.shouldRender() || !ctx.config.bool(IConfig.BooleanOption.ABSORPTION_ENABLE) || !ctx.config.bool(IConfig.BooleanOption.HEALTH_ENABLE) || ctx.config.bool(IConfig.BooleanOption.ABSORPTION_OVERLAY) || ctx.config.bool(IConfig.BooleanOption.HEALTH_HIDDEN)) {
            return false;
        }
        ctx.profiler.push("absorption");
        ITextureSheet tex = this.tex(ctx).bind(ctx);
        float absorbAmp = ctx.config.dec(IConfig.FloatOption.ABSORPTION_VALUE);
        int absorb = ctx.math.ceil(ctx.data.absorption());
        int fullBorders = ctx.math.floor(0.05f * (float)absorb * absorbAmp);
        if (absorb <= 0 || absorbAmp <= 0.0f) {
            return this.popReturn(ctx, false);
        }
        boolean highlight = Components.HEALTH.healthBlinkTime() > (long)Components.HEALTH.lastGuiTicks() && (Components.HEALTH.healthBlinkTime() - (long)Components.HEALTH.lastGuiTicks()) / 3L % 2L == 1L;
        for (int i = 9; i >= 0; --i) {
            if (i > fullBorders) continue;
            int heartX = ctx.x + i * 8;
            int heartY = Components.HEALTH.lastHeartY()[i];
            if (i < fullBorders) {
                tex.drawAbsorb(ctx, heartX, heartY, 20, highlight);
                continue;
            }
            if (i != fullBorders || (float)absorb * absorbAmp % 20.0f == 0.0f) continue;
            tex.drawAbsorb(ctx, heartX, heartY, ctx.math.ceil((float)absorb * absorbAmp) % 20, highlight);
        }
        return this.popReturn(ctx, true);
    }
}

