/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.EnableState;
import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.Side;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;

public class ToughnessComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        if (!(ctx.shouldRenderToughness() && ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_ENABLE) && ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_BAR))) {
            return false;
        }
        ctx.profiler.push("toughness");
        ITextureSheet tex = this.tex(ctx).bind(ctx);
        long toughness = ctx.math.floor(ctx.data.toughness() * 2.0);
        EnableState mirroring = ctx.config.enm(IConfig.EnumOption.TOUGHNESS_MIRRORING);
        boolean mirror = mirroring == EnableState.ALWAYS || mirroring == EnableState.AUTO && ctx.config.enm(IConfig.EnumOption.TOUGHNESS_SIDE) == Side.RIGHT;
        for (int i = 0; i < 10; ++i) {
            tex.drawToughness(ctx, ctx.x + 8 * (mirror ? 9 - i : i), ctx.y, (int)((float)(toughness - (long)(2 * (i + 1)) + 20L) * 0.05f), toughness % 20L - (long)(2 * i) == 1L, false, mirror);
        }
        return this.popReturn(ctx, true);
    }
}

